/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.template;

import cn.bran.japid.util.WebUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public abstract class JapidTemplateBaseStreaming {
    private static final String UTF_8 = "UTF-8";
    private OutputStream out;
    Charset UTF8 = Charset.forName("UTF-8");

    protected OutputStream getOut() {
        return this.out;
    }

    public JapidTemplateBaseStreaming(OutputStream out2) {
        if (out2 == null) {
            throw new RuntimeException("JapidTemplateBaseStreaming do not take null OutputStream.");
        }
        this.out = out2;
    }

    public void runtimeInit() {
    }

    protected final void p(byte[] ba) {
        try {
            this.out.write(ba);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void p(String s) {
        try {
            this.writeString(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void pln(String s) {
        try {
            this.writeString(s);
            this.out.write(10);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeString(String s) throws IOException, UnsupportedEncodingException {
        if (s != null) {
            this.out.write(s.getBytes(UTF_8));
        }
    }

    protected final void pln(byte[] ba) {
        try {
            this.out.write(ba);
            this.out.write(10);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void p(Object ... ss) {
        for (Object s : ss) {
            if (s == null) continue;
            this.writeObject(s);
        }
    }

    private void writeObject(Object s) {
        try {
            if (s instanceof byte[]) {
                this.out.write((byte[])s);
            } else {
                this.writeString(s.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected final void pln(Object ... ss) {
        for (Object s : ss) {
            if (s == null) continue;
            this.writeObject(s);
        }
        this.pln();
    }

    protected final void pln() {
        try {
            this.out.write(10);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void layout() {
        this.doLayout();
    }

    protected abstract void doLayout();

    public boolean asBoolean(Object o) {
        return WebUtils.asBoolean(o);
    }

    protected static byte[] getBytes(String src) {
        if (src == null || src.length() == 0) {
            return new byte[0];
        }
        try {
            return src.getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

