/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MethodCallExpr;
import japa.parser.ast.type.Type;
import japa.parser.ast.visitor.VoidVisitor;
import japa.parser.ast.visitor.VoidVisitorAdapter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSyntaxTool {
    private static final String UTF_8 = "UTF-8";
    private static final String classTempForParams = "class T { void t(%s) {} }";
    private static final String classTempForArgs = "class T {  {  foo(%s); } }";
    private static final String classTempForExpr = "class T {  {  f = %s ; } }";

    public static CompilationUnit parse(String src) throws ParseException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(src.getBytes(UTF_8));
            CompilationUnit cu = JavaParser.parse((InputStream)in, (String)UTF_8);
            return cu;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isValid(String src) {
        try {
            CompilationUnit cu = JavaSyntaxTool.parse(src);
            return true;
        }
        catch (ParseException e) {
            String m = e.getMessage();
            System.out.println(m.substring(0, m.indexOf(10)));
            return false;
        }
    }

    public static List<Parameter> parseParams(String line) {
        final ArrayList<Parameter> ret = new ArrayList<Parameter>();
        if (line == null || line.trim().length() == 0) {
            return ret;
        }
        String cl = String.format(classTempForParams, line);
        try {
            CompilationUnit cu = JavaSyntaxTool.parse(cl);
            VoidVisitorAdapter visitor = new VoidVisitorAdapter(){

                public void visit(Parameter p, Object arg) {
                    ret.add(p);
                }
            };
            cu.accept((VoidVisitor)visitor, null);
        }
        catch (ParseException e) {
            throw new RuntimeException("the line does not seem to be a valid param declaration list: " + line);
        }
        return ret;
    }

    public static List<String> parseArgs(String line) {
        final ArrayList<String> ret = new ArrayList<String>();
        if (line == null || line.trim().length() == 0) {
            return ret;
        }
        if ((line = line.trim()).startsWith("(")) {
            if (line.endsWith(")")) {
                line = line.substring(1, line.length() - 1);
            } else {
                throw new RuntimeException("no closing ')' in arg expression: " + line);
            }
        }
        String cl = String.format(classTempForArgs, line);
        try {
            CompilationUnit cu = JavaSyntaxTool.parse(cl);
            VoidVisitorAdapter visitor = new VoidVisitorAdapter(){

                public void visit(MethodCallExpr n, Object arg) {
                    List args = n.getArgs();
                    if (args != null) {
                        for (Expression e : args) {
                            ret.add(e.toString());
                        }
                    }
                }
            };
            cu.accept((VoidVisitor)visitor, null);
        }
        catch (ParseException e) {
            throw new RuntimeException("the line does not seem to be a valid arg list: " + line);
        }
        return ret;
    }

    public static boolean hasMethod(String javaSource, String string) throws ParseException {
        CompilationUnit cu = JavaSyntaxTool.parse(javaSource);
        return JavaSyntaxTool.hasMethod(cu, string);
    }

    public static boolean hasMethodInvocatioin(CompilationUnit cu, final String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        final StringBuilder re = new StringBuilder();
        VoidVisitorAdapter visitor = new VoidVisitorAdapter(){

            public void visit(MethodCallExpr n, Object arg) {
                if (string.equals(n.getName())) {
                    re.append(1);
                    return;
                }
                super.visit(n, arg);
            }
        };
        cu.accept((VoidVisitor)visitor, null);
        return re.length() != 0;
    }

    public static boolean hasMethod(CompilationUnit cu, final String string) {
        final StringBuilder sb = new StringBuilder();
        VoidVisitorAdapter visitor = new VoidVisitorAdapter(){

            public void visit(MethodDeclaration n, Object arg) {
                if (n.getName().equals(string)) {
                    sb.append(1);
                    return;
                }
            }
        };
        cu.accept((VoidVisitor)visitor, null);
        return sb.length() != 0;
    }

    public static boolean hasMethod(CompilationUnit cu, final String name, final int modis, final String returnType, String paramList) {
        final StringBuilder sb = new StringBuilder();
        if (paramList == null) {
            paramList = "";
        }
        String formalParamList = JavaSyntaxTool.addParamNamesPlaceHolder(paramList);
        final List<Parameter> params = JavaSyntaxTool.parseParams(formalParamList);
        VoidVisitorAdapter visitor = new VoidVisitorAdapter(){

            public void visit(MethodDeclaration n, Object arg) {
                Type type;
                int modifiers2;
                if (n.getName().equals(name) && (modifiers2 = n.getModifiers()) == modis && (type = n.getType()).toString().equals(returnType)) {
                    ArrayList<Parameter> ps = n.getParameters();
                    if (ps == null) {
                        ps = new ArrayList<Parameter>();
                    }
                    if (JavaSyntaxTool.paramsMatch(params, ps)) {
                        sb.append(1);
                        return;
                    }
                }
            }
        };
        cu.accept((VoidVisitor)visitor, null);
        return sb.length() != 0;
    }

    public static boolean hasMethod(CompilationUnit cu, String name, String modifiers, String returnType, String paramList) {
        int modis = JavaSyntaxTool.parseModifiers(modifiers);
        return JavaSyntaxTool.hasMethod(cu, name, modis, returnType, paramList);
    }

    static String addParamNamesPlaceHolder(String paramList) {
        List<String> names = JavaSyntaxTool.getNames(paramList);
        String formalParamList = "";
        for (int i = 0; i < names.size(); ++i) {
            formalParamList = formalParamList + names.get(i) + " " + (char)(97 + i) + ",";
        }
        if (formalParamList.endsWith(",")) {
            formalParamList = formalParamList.substring(0, formalParamList.length() - 1);
        }
        return formalParamList;
    }

    private static List<String> getNames(String paramList) {
        paramList = paramList.replace(' ', ',');
        String[] pams = paramList.split(",");
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < pams.length; ++i) {
            String p = pams[i].trim();
            if (p.length() <= 0) continue;
            names.add(p);
        }
        return names;
    }

    protected static boolean paramsMatch(List<Parameter> params, List<Parameter> ps) {
        if (params == ps) {
            return true;
        }
        if (params == null && ps != null || params != null && ps == null) {
            return false;
        }
        if (params.size() != ps.size()) {
            return false;
        }
        for (int i = 0; i < params.size(); ++i) {
            Parameter p2;
            Parameter p1 = params.get(i);
            if (JavaSyntaxTool.matchParams(p1, p2 = ps.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchParams(Parameter p1, Parameter p2) {
        if (p1.equals((Object)p2)) {
            return true;
        }
        if (p1.getModifiers() != p2.getModifiers()) {
            return false;
        }
        return p1.getType().equals((Object)p2.getType());
    }

    private static int parseModifiers(String modifiers) {
        int ret = 0;
        List<String> names = JavaSyntaxTool.getNames(modifiers);
        for (String m : names) {
            if (m.equals("public")) {
                ret |= 1;
                continue;
            }
            if (m.equals("private")) {
                ret |= 2;
                continue;
            }
            if (m.equals("protected")) {
                ret |= 4;
                continue;
            }
            if (m.equals("static")) {
                ret |= 8;
                continue;
            }
            if (m.equals("final")) {
                ret |= 0x10;
                continue;
            }
            if (m.equals("final")) {
                ret |= 0x10;
                continue;
            }
            if (!m.equals("synchronized")) continue;
            ret |= 0x20;
        }
        return ret;
    }

    public static String addFinalToAllParams(String paramline) {
        if (paramline == null) {
            return null;
        }
        if ((paramline = paramline.trim()).length() == 0) {
            return "";
        }
        List<Parameter> params = JavaSyntaxTool.parseParams(paramline);
        String s = "";
        for (Parameter p : params) {
            s = s + "final " + p.getType() + " " + p.getId().getName() + ", ";
        }
        return s.substring(0, s.lastIndexOf(", "));
    }

    public static String matchLongestPossibleExpr(String src) {
        if (src == null || src.trim().length() == 0) {
            return "";
        }
        src = src.trim();
        String expr = "";
        for (int i = src.length(); i > 0; --i) {
            expr = src.substring(0, i);
            String ss = String.format(classTempForExpr, expr);
            try {
                JavaSyntaxTool.parse(ss);
                break;
            }
            catch (ParseException e) {
                continue;
            }
        }
        return expr.trim();
    }

    public static class Param {
        public String type;
        public String name;

        public Param(String type, String name) {
            this.type = type;
            this.name = name;
        }
    }
}

