/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.rendererloader;

import cn.bran.japid.rendererloader.RendererClass;
import cn.bran.japid.rendererloader.TemplateClassLoader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendererCompiler {
    Map<String, Boolean> packagesCache = new HashMap<String, Boolean>();
    Map<String, RendererClass> classes;
    TemplateClassLoader crlr;
    Map<String, String> settings = new HashMap<String, String>();

    public RendererCompiler(Map<String, RendererClass> classes, TemplateClassLoader cl) {
        this.settings.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        this.settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        this.settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        this.settings.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        this.settings.put("org.eclipse.jdt.core.encoding", "UTF-8");
        this.settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        String javaVersion = "1.6";
        this.settings.put("org.eclipse.jdt.core.compiler.source", javaVersion);
        this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", javaVersion);
        this.settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        this.settings.put("org.eclipse.jdt.core.compiler.compliance", javaVersion);
        this.classes = classes;
        this.crlr = cl;
    }

    public void compile(String[] classNames) {
        ICompilationUnit[] compilationUnits = new CompilationUnit[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            compilationUnits[i] = new CompilationUnit(classNames[i]);
        }
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitOnFirstError();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.ENGLISH);
        INameEnvironment nameEnvironment = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    if (i != 0) {
                        result.append('.');
                    }
                    result.append(compoundTypeName[i]);
                }
                return this.findType(result.toString());
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < packageName.length; ++i) {
                    result.append(packageName[i]);
                    result.append('.');
                }
                result.append(typeName);
                return this.findType(result.toString());
            }

            private NameEnvironmentAnswer findType(String name) {
                try {
                    if (!name.startsWith("japidviews.")) {
                        byte[] bytes = RendererCompiler.this.crlr.getClassDefinition(name);
                        if (bytes != null) {
                            ClassFileReader classFileReader = new ClassFileReader(bytes, name.toCharArray(), true);
                            return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                        }
                        return null;
                    }
                    char[] fileName = name.toCharArray();
                    RendererClass applicationClass = RendererCompiler.this.classes.get(name);
                    if (applicationClass != null) {
                        byte[] bytecode = applicationClass.getBytecode();
                        if (bytecode != null) {
                            ClassFileReader classFileReader = new ClassFileReader(bytecode, fileName, true);
                            return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                        }
                        CompilationUnit compilationUnit = new CompilationUnit(name);
                        return new NameEnvironmentAnswer((ICompilationUnit)compilationUnit, null);
                    }
                    byte[] bytes = RendererCompiler.this.crlr.getClassDefinition(name);
                    if (bytes != null) {
                        ClassFileReader classFileReader = new ClassFileReader(bytes, fileName, true);
                        return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                    }
                    return null;
                }
                catch (ClassFormatException e) {
                    throw new RuntimeException(e);
                }
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                StringBuilder sb = new StringBuilder();
                if (parentPackageName != null) {
                    for (char[] p : parentPackageName) {
                        sb.append(new String(p));
                        sb.append(".");
                    }
                }
                sb.append(new String(packageName));
                String name = sb.toString();
                if (RendererCompiler.this.packagesCache.containsKey(name)) {
                    return RendererCompiler.this.packagesCache.get(name);
                }
                if (RendererCompiler.this.crlr.getClassDefinition(name) != null) {
                    RendererCompiler.this.packagesCache.put(name, false);
                    return false;
                }
                if (RendererCompiler.this.classes.get(name) != null) {
                    RendererCompiler.this.packagesCache.put(name, false);
                    return false;
                }
                RendererCompiler.this.packagesCache.put(name, true);
                return true;
            }

            public void cleanup() {
            }
        };
        ICompilerRequestor compilerRequestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                CategorizedProblem[] arr$;
                int len$;
                int i$;
                if (result.hasErrors() && (i$ = 0) < (len$ = (arr$ = result.getErrors()).length)) {
                    CategorizedProblem problem = arr$[i$];
                    String className = new String(problem.getOriginatingFileName()).replace("/", ".");
                    className = className.substring(0, className.length() - 5);
                    String message = problem.getMessage();
                    if (problem.getID() == 268435843) {
                        message = problem.getArguments()[0] + " cannot be resolved";
                    }
                    throw new RuntimeException(className + ": " + message);
                }
                ClassFile[] clazzFiles = result.getClassFiles();
                for (int i = 0; i < clazzFiles.length; ++i) {
                    ClassFile clazzFile = clazzFiles[i];
                    char[][] compoundName = clazzFile.getCompoundName();
                    StringBuffer clazzName = new StringBuffer();
                    for (int j = 0; j < compoundName.length; ++j) {
                        if (j != 0) {
                            clazzName.append('.');
                        }
                        clazzName.append(compoundName[j]);
                    }
                    byte[] bytes = clazzFile.getBytes();
                    System.out.println("[RenderCompiler]Compiled " + clazzName);
                    String cname = clazzName.toString();
                    RendererClass rc = RendererCompiler.this.classes.get(cname);
                    if (rc == null) {
                        if (cname.contains("$")) {
                            rc = new RendererClass();
                            rc.className = cname;
                            RendererCompiler.this.classes.put(cname, rc);
                        } else {
                            throw new RuntimeException("name not in the classes container: " + cname);
                        }
                    }
                    rc.setBytecode(bytes);
                }
            }
        };
        Compiler jdtCompiler = new Compiler(nameEnvironment, policy, this.settings, compilerRequestor, (IProblemFactory)problemFactory){

            protected void handleInternalException(Throwable e, CompilationUnitDeclaration ud, CompilationResult result) {
            }
        };
        jdtCompiler.compile(compilationUnits);
    }

    final class CompilationUnit
    implements ICompilationUnit {
        private final String clazzName;
        private final String fileName;
        private final char[] typeName;
        private final char[][] packageName;

        CompilationUnit(String pClazzName) {
            this.clazzName = pClazzName;
            if (pClazzName.contains("$")) {
                pClazzName = pClazzName.substring(0, pClazzName.indexOf("$"));
            }
            this.fileName = pClazzName.replace('.', '/') + ".java";
            int dot = pClazzName.lastIndexOf(46);
            this.typeName = dot > 0 ? pClazzName.substring(dot + 1).toCharArray() : pClazzName.toCharArray();
            StringTokenizer izer = new StringTokenizer(pClazzName, ".");
            this.packageName = new char[izer.countTokens() - 1][];
            for (int i = 0; i < this.packageName.length; ++i) {
                this.packageName[i] = izer.nextToken().toCharArray();
            }
        }

        public char[] getFileName() {
            return this.fileName.toCharArray();
        }

        public char[] getContents() {
            return RendererCompiler.this.classes.get(this.clazzName).getSourceCode().toCharArray();
        }

        public char[] getMainTypeName() {
            return this.typeName;
        }

        public char[][] getPackageName() {
            return this.packageName;
        }
    }
}

