/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import cn.bran.japid.compiler.TokenPair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidParser {
    private char MARKER_CHAR = (char)96;
    private String MARKER_STRING = "`";
    private static final String VERBATIM2 = "verbatim";
    private String pageSource;
    Stack<Token> emthodCallStackInExpr = new Stack();
    private int end;
    private int begin;
    private int end2;
    private int begin2;
    private int len;
    private Token state = Token.PLAIN;
    private Token lastState;
    public boolean verbatim;

    public JapidParser(String pageSource) {
        this.pageSource = pageSource;
        this.len = pageSource.length();
        char mar = JapidParser.detectMarker(pageSource);
        this.setMarker(mar);
    }

    public static char detectMarker(String pageSource) {
        BufferedReader br = new BufferedReader(new StringReader(pageSource));
        try {
            String line = br.readLine();
            while (line != null) {
                if ((line = line.trim()).startsWith("@")) {
                    return '@';
                }
                if (line.startsWith("`") && !line.startsWith("``") && !line.startsWith("`@")) {
                    return '`';
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return '`';
    }

    public void setMarker(char m) {
        this.MARKER_CHAR = m;
        this.MARKER_STRING = new String(new char[]{m});
    }

    public void resetMarker() {
        this.MARKER_CHAR = (char)96;
        this.MARKER_STRING = new String(new char[]{this.MARKER_CHAR});
    }

    private Token found(Token newState, int skip) {
        this.begin2 = this.begin;
        this.end2 = --this.end;
        this.begin = this.end += skip;
        this.lastState = this.state == Token.EXPR_NATURAL ? Token.EXPR : this.state;
        this.state = newState;
        return this.lastState;
    }

    private void skip(int skip) {
        this.end2 = --this.end;
        this.end += skip;
    }

    public Integer getLineNumber() {
        String token = this.pageSource.substring(0, this.begin2);
        if (token.indexOf("\n") == -1) {
            return 1;
        }
        return token.split("\n").length;
    }

    public String getToken() {
        String tokenString = this.pageSource.substring(this.begin2, this.end2);
        if (this.lastState == Token.PLAIN) {
            tokenString = tokenString.replace("``", "`").replace("`@", "@");
        }
        return tokenString;
    }

    public String checkNext() {
        if (this.end2 < this.pageSource.length()) {
            return this.pageSource.charAt(this.end2) + "";
        }
        return "";
    }

    public Token nextToken() {
        block20: while (true) {
            int left;
            if ((left = this.len - this.end) == 0) {
                ++this.end;
                return this.found(Token.EOF, 0);
            }
            char c = this.pageSource.charAt(this.end++);
            char c1 = left > 1 ? this.pageSource.charAt(this.end) : (char)'\u0000';
            char c2 = left > 2 ? this.pageSource.charAt(this.end + 1) : (char)'\u0000';
            switch (this.state) {
                case PLAIN: {
                    if (c == '%' && c1 == '{') {
                        return this.found(Token.SCRIPT, 2);
                    }
                    if (c == '{' && c1 == '%') {
                        return this.found(Token.SCRIPT, 2);
                    }
                    if (c == '~' && c1 == '[') {
                        return this.found(Token.SCRIPT, 2);
                    }
                    if (c == '$' && c1 == '{') {
                        return this.found(Token.EXPR, 2);
                    }
                    if (c == '~' && c1 == '{') {
                        return this.found(Token.EXPR_ESCAPED, 2);
                    }
                    if (c == '~' && c1 == '(') {
                        return this.found(Token.TEMPLATE_ARGS, 2);
                    }
                    if (c == '~' && c1 != '~' && (Character.isJavaIdentifierStart(c1) || '\'' == c1)) {
                        return this.found(Token.EXPR_NATURAL_ESCAPED, 1);
                    }
                    if (c == '$' && c1 != '$' && (Character.isJavaIdentifierStart(c1) || '\'' == c1)) {
                        return this.found(Token.EXPR_NATURAL, 1);
                    }
                    if (c == '#' && c1 == '{' && c2 == '/') {
                        return this.found(Token.END_TAG, 3);
                    }
                    if (c == '#' && c1 == '{') {
                        return this.found(Token.START_TAG, 2);
                    }
                    if (c == '&' && c1 == '{') {
                        return this.found(Token.MESSAGE, 2);
                    }
                    if (c == '@' && c1 == '@' && c2 == '{') {
                        return this.found(Token.ABS_ACTION, 3);
                    }
                    if (c == '@' && c1 == '{') {
                        return this.found(Token.ACTION, 2);
                    }
                    if (c == '*' && c1 == '{') {
                        return this.found(Token.COMMENT, 2);
                    }
                    if (c == '`' && (c1 == '@' || c1 == '`')) {
                        this.skip(2);
                        break;
                    }
                    if (c != this.MARKER_CHAR) break;
                    if (c1 == this.MARKER_CHAR) {
                        this.skip(2);
                        break;
                    }
                    if (c1 == '(') {
                        return this.found(Token.TEMPLATE_ARGS, 2);
                    }
                    if (this.nextMatch(VERBATIM2)) {
                        return this.found(Token.VERBATIM, VERBATIM2.length() + 1);
                    }
                    return this.found(Token.SCRIPT_LINE, 1);
                }
                case CLOSING_BRACE: {
                    if (c == '\n') {
                        return this.found(Token.PLAIN, 1);
                    }
                    return this.found(Token.SCRIPT_LINE, 1);
                }
                case SCRIPT: {
                    if (c == '}' && c1 == '%') {
                        return this.found(Token.PLAIN, 2);
                    }
                    if (c == '%' && c1 == '}') {
                        return this.found(Token.PLAIN, 2);
                    }
                    if (c == '}' && c1 == '~') {
                        return this.found(Token.PLAIN, 2);
                    }
                    if (c != ']' || c1 != '~') continue block20;
                    return this.found(Token.PLAIN, 2);
                }
                case VERBATIM: {
                    if (c != this.MARKER_CHAR) break;
                    String currentLine = JapidParser.getCurrentLine(this.pageSource, this.end - 1);
                    if (!currentLine.trim().equals(this.MARKER_STRING)) continue block20;
                    int skip = currentLine.length() - currentLine.indexOf(this.MARKER_CHAR);
                    return this.found(Token.PLAIN, skip);
                }
                case SCRIPT_LINE: {
                    if (c == '\r') {
                        if (c1 == '\n') {
                            return this.found(Token.PLAIN, 2);
                        }
                        return this.found(Token.PLAIN, 1);
                    }
                    if (c == '\n') {
                        return this.found(Token.PLAIN, 1);
                    }
                    if (c != this.MARKER_CHAR) break;
                    return this.found(Token.PLAIN, 1);
                }
                case COMMENT: {
                    if (c != '}' || c1 != '*') continue block20;
                    return this.found(Token.PLAIN, 2);
                }
                case START_TAG: {
                    if (c == '}') {
                        return this.found(Token.PLAIN, 1);
                    }
                    if (c != '/' || c1 != '}') continue block20;
                    return this.found(Token.END_TAG, 1);
                }
                case END_TAG: {
                    if (c != '}') break;
                    return this.found(Token.PLAIN, 1);
                }
                case EXPR: 
                case EXPR_ESCAPED: {
                    if (c != '}') break;
                    return this.found(Token.PLAIN, 1);
                }
                case TEMPLATE_ARGS: {
                    if (c != ')') break;
                    return this.found(Token.PLAIN, 1);
                }
                case EXPR_NATURAL: 
                case EXPR_NATURAL_ESCAPED: {
                    if ('(' == c) {
                        this.skipAhead(Token.EXPR_NATURAL_METHOD_CALL, 1);
                        break;
                    }
                    if ('[' == c) {
                        this.skipAhead(Token.EXPR_NATURAL_ARRAY_OP, 1);
                        break;
                    }
                    if ('\'' == c) {
                        this.skipAhead(Token.EXPR_NATURAL_STRING_LITERAL, 1);
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        return this.found(Token.PLAIN, 0);
                    }
                    if (Character.isJavaIdentifierPart(c)) break;
                    if (c != '?' && c != '.' && c != ':' && c != '=') {
                        return this.found(Token.PLAIN, 0);
                    }
                    if (Character.isJavaIdentifierStart(c1)) break;
                    if (c == '=' && c1 == '=') {
                        if (Character.isWhitespace(c2)) {
                            return this.found(Token.PLAIN, 0);
                        }
                        this.skip(2);
                        break;
                    }
                    return this.found(Token.PLAIN, 0);
                }
                case EXPR_NATURAL_METHOD_CALL: {
                    if ('(' == c) {
                        this.skipAhead(Token.EXPR_NATURAL_METHOD_CALL, 1);
                        break;
                    }
                    if (')' != c) break;
                    this.state = this.emthodCallStackInExpr.pop();
                    this.skip(1);
                    break;
                }
                case EXPR_NATURAL_ARRAY_OP: {
                    if ('[' == c) {
                        this.skipAhead(Token.EXPR_NATURAL_ARRAY_OP, 1);
                        break;
                    }
                    if (']' != c) break;
                    this.state = this.emthodCallStackInExpr.pop();
                    this.skip(1);
                    break;
                }
                case EXPR_NATURAL_STRING_LITERAL: {
                    if ('\\' == c && '\'' == c1) {
                        this.skip(2);
                    }
                    if ('\'' != c) break;
                    this.state = this.emthodCallStackInExpr.pop();
                    this.skip(1);
                    break;
                }
                case ACTION: {
                    if (c == '}') {
                        return this.found(Token.PLAIN, 1);
                    }
                    if (c != '{') break;
                    this.skipAhead(Token.ACTION_CURLY, 1);
                    break;
                }
                case ABS_ACTION: {
                    if (c == '}') {
                        return this.found(Token.PLAIN, 1);
                    }
                    if (c != '{') break;
                    this.skipAhead(Token.ACTION_CURLY, 1);
                    break;
                }
                case ACTION_CURLY: {
                    if (c == '}') {
                        this.state = this.emthodCallStackInExpr.pop();
                        this.skip(1);
                        break;
                    }
                    if (c != '{') break;
                    this.skipAhead(Token.ACTION_CURLY, 1);
                    break;
                }
                case MESSAGE: {
                    if (c != '}') break;
                    return this.found(Token.PLAIN, 1);
                }
            }
        }
    }

    private boolean isStandAloneBackQuote() {
        String currentLine = JapidParser.getCurrentLine(this.pageSource, this.end);
        return currentLine.trim().equals(this.MARKER_STRING);
    }

    static String getCurrentLine(String src, int pos) {
        char charAt;
        int length;
        char charAt2;
        int begin = 0;
        int endp = 0;
        int i = 1;
        while ((begin = pos - i++) >= 0 && (charAt2 = src.charAt(begin)) != '\n') {
        }
        i = 1;
        while ((endp = pos + i++) < (length = src.length()) && (charAt = src.charAt(endp)) != '\n') {
        }
        return src.substring(++begin, endp);
    }

    private boolean nextMatch(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            int index = this.end + i;
            if (index < this.pageSource.length()) {
                if (c == this.pageSource.charAt(index)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private String getPrevTokenString() {
        return this.pageSource.substring(this.end2, this.end - 1);
    }

    static boolean allLeadingSpaceInline(String curToken) {
        char ch;
        boolean allLeadingSpace = true;
        int len = curToken.length();
        for (int i = len - 1; i > -1 && (ch = curToken.charAt(i)) != '\n'; --i) {
            if (ch == ' ' || ch == '\t') continue;
            allLeadingSpace = false;
            break;
        }
        return allLeadingSpace;
    }

    private void skipAhead(Token token, int i) {
        this.emthodCallStackInExpr.push(this.state);
        this.state = token;
        this.skip(i);
    }

    void reset() {
        this.begin2 = 0;
        this.end2 = 0;
        this.begin = 0;
        this.end = 0;
        this.state = Token.PLAIN;
    }

    public List<TokenPair> allTokens() {
        ArrayList<TokenPair> result = new ArrayList<TokenPair>();
        block3: while (true) {
            Token state = this.nextToken();
            switch (state) {
                case EOF: {
                    break block3;
                }
                default: {
                    String tokenstring = this.getToken();
                    result.add(new TokenPair(state, tokenstring));
                    continue block3;
                }
            }
            break;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Token {
        EOF,
        PLAIN,
        SCRIPT,
        SCRIPT_LINE,
        EXPR,
        EXPR_ESCAPED,
        START_TAG,
        END_TAG,
        MESSAGE,
        ACTION,
        ABS_ACTION,
        ACTION_CURLY,
        COMMENT,
        EXPR_WING,
        EXPR_NATURAL,
        EXPR_NATURAL_ESCAPED,
        EXPR_NATURAL_METHOD_CALL,
        EXPR_NATURAL_ARRAY_OP,
        EXPR_NATURAL_STRING_LITERAL,
        TEMPLATE_ARGS,
        CLOSING_BRACE,
        VERBATIM;

    }
}

