/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;

public class CachedItemStatus
implements Serializable {
    private static final int MIN_ALERT_ADVANCE = 1000;
    private long timein;
    private long ttl;
    private long safeBefore;
    private AtomicBoolean isRefreshing = new AtomicBoolean(false);
    private boolean expireSoon;

    public CachedItemStatus(long timein, long ttl) {
        this.timein = timein;
        this.ttl = ttl;
        long unsafeZone = (long)((double)ttl * 0.09999999999999998);
        this.safeBefore = unsafeZone < 1000L ? timein + ttl - 1000L : timein + ttl - unsafeZone;
    }

    public CachedItemStatus(long ttl) {
        this(System.currentTimeMillis(), ttl);
    }

    boolean expireSoon() {
        return this.expireSoon ? true : (this.expireSoon = System.currentTimeMillis() > this.safeBefore);
    }

    public boolean isRefreshing() {
        return this.isRefreshing.get();
    }

    public void setIsRefreshing() {
        this.isRefreshing.set(true);
    }

    public boolean shouldRefresh() {
        if (this.expireSoon()) {
            return this.isRefreshing.compareAndSet(false, true);
        }
        return false;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.timein + this.ttl;
    }
}

