/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import cn.bran.japid.classmeta.AbstractTemplateClassMetaData;
import cn.bran.japid.classmeta.TemplateClassMetaData;
import cn.bran.japid.compiler.JapidAbstractCompiler;
import cn.bran.japid.compiler.JapidCompilationException;
import cn.bran.japid.compiler.Tag;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JapidTemplateCompiler
extends JapidAbstractCompiler {
    private static final String DO_BODY = "doBody";
    TemplateClassMetaData tcmd = new TemplateClassMetaData();
    static Pattern setPattern = Pattern.compile("(\\w+)\\s+(.*)");

    protected void startTag(Tag tag) {
        if (tag.tagName.equals(DO_BODY)) {
            this.tcmd.doBody(tag.args);
            this.println("if (body != null)");
            this.println("\tbody.render(" + tag.args + ");");
        } else if ("set".equals(tag.tagName)) {
            if (tag.args.contains(":")) {
                if (tag.hasBody) {
                    throw new JapidCompilationException(this.template, this.currentLine, "set tag cannot have value in tag and in body");
                }
                int i = tag.args.indexOf(":");
                String key = tag.args.substring(0, i).trim().replace("\"", "").replace("'", "");
                String value = tag.args.substring(i + 1);
                this.tcmd.addSetTag(key, "p(" + value + ");", (Tag.TagSet)tag);
            } else {
                Matcher matcher = setPattern.matcher(tag.args);
                if (matcher.matches()) {
                    tag.hasBody = false;
                    String key = matcher.group(1);
                    String value = matcher.group(2);
                    this.tcmd.addSetTag(key, "p(" + value + ");", (Tag.TagSet)tag);
                }
            }
        } else if (tag.tagName.equals("def")) {
            this.def(tag);
        } else {
            this.regularTagInvoke(tag);
        }
        this.pushToStack(tag);
        this.markLine(this.parser.getLineNumber());
        this.println();
        this.skipLineBreak = true;
    }

    protected AbstractTemplateClassMetaData getTemplateClassMetaData() {
        return this.tcmd;
    }

    protected void scriptline(String token) {
        String line = token;
        if (JapidAbstractCompiler.startsWithIgnoreSpace(line.trim(), DO_BODY) || line.trim().equals(DO_BODY)) {
            String args = line.trim().substring(DO_BODY.length()).trim();
            this.tcmd.doBody(args);
            this.println("if (body != null)");
            this.println("\tbody.render(" + args + ");");
            this.skipLineBreak = true;
        } else {
            super.scriptline(token);
        }
    }

    void endSet(Tag.TagSet tag) {
        if (tag.hasBody) {
            String key = tag.args.replace("\"", "").replace("'", "");
            this.tcmd.addSetTag(key, tag.getBodyText(), tag);
        }
    }
}

