/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.template;

import cn.bran.japid.compiler.NamedArgRuntime;
import cn.bran.japid.template.RenderResult;
import cn.bran.japid.util.HTMLUtils;
import cn.bran.japid.util.WebUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JapidTemplateBaseWithoutPlay
implements Serializable {
    protected StringBuilder out;
    protected Map<String, String> headers = new TreeMap<String, String>();
    public Method renderMethodInstance;
    public String[] argNamesInstance;
    public String[] argTypesInstance;
    public Object[] argDefaultsInstance;

    public void setOut(StringBuilder out) {
        this.out = out;
    }

    protected StringBuilder getOut() {
        return this.out;
    }

    public JapidTemplateBaseWithoutPlay(StringBuilder out2) {
        this.headers.put("Content-Type", "text/html; charset=utf-8");
        this.argNamesInstance = null;
        this.argTypesInstance = null;
        this.argDefaultsInstance = null;
        this.out = out2 == null ? new StringBuilder(4000) : out2;
    }

    protected final void p(String s) {
        this.writeString(s);
    }

    protected final void pln(String s) {
        this.writeString(s);
        this.out.append('\n');
    }

    private final void writeString(String s) {
        if (s != null && !s.isEmpty()) {
            this.out.append(s);
        }
    }

    protected final void p(Object s) {
        if (s != null) {
            this.writeString(s.toString());
        }
    }

    protected final void pln(Object s) {
        if (s != null) {
            this.writeString(s.toString());
        }
        this.pln();
    }

    protected final void pln() {
        this.out.append('\n');
    }

    protected void layout() {
        this.doLayout();
    }

    protected abstract void doLayout();

    protected static byte[] getBytes(String src) {
        if (src == null || src.length() == 0) {
            return new byte[0];
        }
        try {
            return src.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.out.toString();
    }

    protected String get(String methodName, String defaultVal) {
        try {
            Method method = this.getClass().getMethod(methodName, null);
            String invoke = (String)method.invoke((Object)this, (Object[])null);
            return invoke;
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    protected String get(String methodName) {
        try {
            Method method = this.getClass().getMethod(methodName, null);
            String invoke = (String)method.invoke((Object)this, (Object[])null);
            return invoke;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean asBoolean(Object o) {
        return WebUtils.asBoolean(o);
    }

    public static String escape(Object o) {
        if (o == null) {
            return null;
        }
        return HTMLUtils.htmlEscape(o.toString());
    }

    public static Method getRenderMethod(Class<? extends JapidTemplateBaseWithoutPlay> currentClass) {
        Method[] methods;
        for (Method m : methods = currentClass.getDeclaredMethods()) {
            if (!m.getName().equals("render")) continue;
            Class<?>[] parameterTypes = m.getParameterTypes();
            if (parameterTypes.length == 1) {
                Class<?> t = parameterTypes[0];
                if (t == NamedArgRuntime[].class) continue;
                return m;
            }
            boolean hasNamedArg = false;
            for (Class<?> c : parameterTypes) {
                if (c != NamedArgRuntime.class && c != NamedArgRuntime[].class) continue;
                hasNamedArg = true;
                break;
            }
            if (hasNamedArg) continue;
            return m;
        }
        throw new RuntimeException("no render method found for the template: " + currentClass.getCanonicalName());
    }

    protected void setRenderMethod(Method renderMethod) {
        this.renderMethodInstance = renderMethod;
    }

    protected void setArgNames(String[] argNames) {
        this.argNamesInstance = argNames;
    }

    protected void setArgTypes(String[] argTypes) {
        this.argTypesInstance = argTypes;
    }

    protected void setArgDefaults(Object[] argDefaults) {
        this.argDefaultsInstance = argDefaults;
    }

    protected static NamedArgRuntime named(String name, Object val) {
        return new NamedArgRuntime(name, val);
    }

    public RenderResult render(NamedArgRuntime ... named) {
        Object[] args = this.buildArgs(named);
        return this.runRenderer(args);
    }

    protected RenderResult runRenderer(Object[] args) {
        try {
            return (RenderResult)this.renderMethodInstance.invoke((Object)this, args);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw new RuntimeException(t);
        }
    }

    public Object[] buildArgs(NamedArgRuntime[] namedArgs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (NamedArgRuntime na : namedArgs) {
            map.put(na.name, na.val);
        }
        Object[] ret = new Object[this.argNamesInstance.length];
        for (int i = 0; i < this.argNamesInstance.length; ++i) {
            Object defaultVal;
            String name = this.argNamesInstance[i];
            if (map.containsKey(name)) {
                ret[i] = map.remove(name);
                continue;
            }
            Object defa = this.argDefaultsInstance[i];
            if (defa != null) {
                ret[i] = defa;
                continue;
            }
            String type = this.argTypesInstance[i];
            ret[i] = defaultVal = this.getDefaultValForType(type);
        }
        if (map.size() > 0) {
            Set keys = map.keySet();
            String ks = "";
            for (String k : keys) {
                ks = ks + k + " ";
            }
            String vs = "[";
            for (String n : this.argNamesInstance) {
                vs = vs + n + " ";
            }
            vs = vs + "]";
            throw new RuntimeException("One or more argument names are not valid: " + ks + ". Valid argument names are: " + vs);
        }
        return ret;
    }

    protected Object[] buildArgs(NamedArgRuntime[] named, Object body) {
        Object[] obsNoBody = this.buildArgs(named);
        int len = obsNoBody.length;
        Object[] ret = new Object[len + 1];
        System.arraycopy(obsNoBody, 0, ret, 0, len);
        ret[len] = body;
        return ret;
    }

    private Object getDefaultValForType(String type) {
        if (type.equals("String")) {
            return "";
        }
        if (type.equals("boolean")) {
            return false;
        }
        if (type.equals("char")) {
            return Character.valueOf('\u0000');
        }
        if (type.equals("byte")) {
            return (byte)0;
        }
        if (type.equals("short")) {
            return (short)0;
        }
        if (type.equals("int")) {
            return 0;
        }
        if (type.equals("float")) {
            return Float.valueOf(0.0f);
        }
        if (type.equals("long")) {
            return 0L;
        }
        if (type.equals("double")) {
            return 0.0;
        }
        return null;
    }
}

