/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.template;

import cn.bran.japid.template.JapidRenderer;
import cn.bran.japid.template.JapidTemplateBaseWithoutPlay;
import cn.bran.japid.util.RenderInvokerUtils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JapidPlainController {
    private static final char DOT = '.';
    private static final String HTML = ".html";
    private static final String JAPIDVIEWS_ROOT = "japidviews";

    JapidPlainController() {
    }

    public static <T extends JapidTemplateBaseWithoutPlay> String renderWith(Class<T> c, Object ... args) {
        JapidPlainController.checkJapidInit();
        if (JapidRenderer.isDevMode()) {
            return JapidPlainController.renderJapidWith(c.getName(), args);
        }
        try {
            return JapidPlainController.invokeRender(c, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkJapidInit() {
        if (!JapidRenderer.isInited()) {
            throw new RuntimeException("The Japid is not initialized. Please use JapidRender.init(...) to set it up.");
        }
    }

    private static <T extends JapidTemplateBaseWithoutPlay> String invokeRender(Class<T> c, Object ... args) {
        int modifiers = c.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            throw new RuntimeException("Cannot init the template class since it's an abstract class: " + c.getName());
        }
        try {
            Constructor<T> ctor = c.getConstructor(StringBuilder.class);
            StringBuilder sb = new StringBuilder(8000);
            JapidTemplateBaseWithoutPlay t = (JapidTemplateBaseWithoutPlay)ctor.newInstance(sb);
            String rr = (String)RenderInvokerUtils.render(t, args);
            return rr;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not match the arguments with the template args.");
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instantiate the template object. Abstract?");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Could not invoke the template object: " + e);
        }
    }

    protected static String render(Object ... objects) {
        JapidPlainController.checkJapidInit();
        String action = JapidPlainController.template();
        return JapidPlainController.renderJapidWith(action, objects);
    }

    public static String renderJapidWith(String template, Object ... args) {
        JapidPlainController.checkJapidInit();
        return JapidPlainController.getRenderResultWith(template, args);
    }

    protected static String template() {
        StackTraceElement[] stes;
        for (StackTraceElement st : stes = new Throwable().getStackTrace()) {
            String controller = st.getClassName();
            String action = st.getMethodName();
            try {
                Class<?> superclass;
                Class<?> controllerClass = JapidPlainController.class.getClassLoader().loadClass(controller);
                if (controllerClass == null || !JapidPlainController.class.isAssignableFrom(superclass = controllerClass.getSuperclass())) continue;
                String expr = controller + "." + action;
                return expr;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static Method findActionMethod(String name, Class clazz) {
        while (!clazz.getName().equals("java.lang.Object")) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equalsIgnoreCase(name)) continue;
                return m;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static String getRenderResultWith(String template, Object ... args) {
        JapidPlainController.checkJapidInit();
        if (template == null || template.length() == 0) {
            template = JapidPlainController.template();
        }
        if (template.endsWith(HTML)) {
            template = template.substring(0, template.length() - HTML.length());
        }
        String templateClassName = template.startsWith(JAPIDVIEWS_ROOT) ? template : JAPIDVIEWS_ROOT + File.separator + template;
        templateClassName = templateClassName.replace('/', '.').replace('\\', '.');
        Class<JapidTemplateBaseWithoutPlay> tClass = null;
        if (JapidRenderer.isDevMode()) {
            tClass = JapidRenderer.getClass(templateClassName);
        } else {
            try {
                tClass = JapidPlainController.class.getClassLoader().loadClass(templateClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (tClass == null) {
            String templateFileName = templateClassName.replace('.', '/') + HTML;
            throw new RuntimeException("Could not find a Japid template with the name of: " + templateFileName);
        }
        String rr = JapidPlainController.invokeRender(tClass, args);
        return rr;
    }
}

