/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.template.RenderResult;
import cn.bran.play.CacheableRunner;
import cn.bran.play.JapidPlugin;
import cn.bran.play.JapidResult;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import play.cache.CacheFor;
import play.classloading.enhancers.ControllersEnhancer;
import play.mvc.After;
import play.mvc.Before;
import play.mvc.Controller;
import play.mvc.Finally;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheablePlayActionRunner
extends CacheableRunner {
    private Class<? extends Controller> controllerClass;
    private String actionName;

    private CacheablePlayActionRunner(String ttl, Object ... args) {
        super(ttl, args);
    }

    public CacheablePlayActionRunner(String ttl, Class<? extends Controller> controllerClass, String actionName, Object ... args) {
        this.controllerClass = controllerClass;
        this.actionName = actionName;
        Object[] fullArgs = CacheablePlayActionRunner.buildCacheKeyParts(controllerClass, actionName, args);
        super.init(ttl, fullArgs);
    }

    public CacheablePlayActionRunner(String ttl) {
        super(ttl);
    }

    protected abstract void runPlayAction() throws JapidResult;

    @Override
    protected RenderResult render() {
        try {
            ControllersEnhancer.ControllerInstrumentation.initActionCall();
            this.runPlayAction();
            throw new RuntimeException("No render result from running play action. Probably the action was not using Japid templates.");
        }
        catch (JapidResult jr) {
            RenderResult rr = jr.getRenderResult();
            return rr;
        }
    }

    @Override
    protected boolean shouldCache() {
        this.fillCacheFor(this.controllerClass, this.actionName);
        return super.shouldCache();
    }

    private void fillCacheFor(Class<?> class1, String actionName) {
        String className = class1.getName();
        String cacheForKey = className + "_" + actionName;
        String cacheForVal = (String)JapidPlugin.getCache().get(cacheForKey);
        if (cacheForVal == null) {
            Method[] mths;
            for (Method m : mths = class1.getDeclaredMethods()) {
                if (!m.getName().equalsIgnoreCase(actionName) || !Modifier.isPublic(m.getModifiers()) || m.isAnnotationPresent(Before.class) || m.isAnnotationPresent(After.class) || m.isAnnotationPresent(Finally.class)) continue;
                CacheFor cacheFor = m.getAnnotation(CacheFor.class);
                cacheForVal = cacheFor == null ? "" : cacheFor.value();
                JapidPlugin.getCache().put(cacheForKey, cacheForVal);
            }
        }
        if (cacheForVal.length() > 0) {
            this.noCache = false;
            if (this.ttlAbs == null || this.ttlAbs.length() == 0) {
                this.ttlAbs = cacheForVal;
            }
        }
    }
}

