/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.template.ActionRunner;
import cn.bran.japid.template.RenderResult;
import cn.bran.play.JapidResult;
import cn.bran.play.RenderResultCache;
import cn.bran.play.ShouldRefreshException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import play.mvc.Controller;
import play.mvc.Http;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheableRunner
extends ActionRunner {
    protected String ttlAbs = null;
    private String keyString;
    protected boolean noCache = true;
    private boolean readThru;

    public CacheableRunner(String ttl, Object ... args) {
        this.init(ttl, args);
    }

    public CacheableRunner() {
    }

    protected void init(String ttl, Object ... args) {
        if (args == null || args.length == 0) {
            this.noCache = true;
        }
        if (ttl == null || ttl.trim().length() == 0) {
            this.noCache = true;
        } else {
            this.noCache = false;
            if (ttl.startsWith("-")) {
                this.ttlAbs = ttl.substring(1);
                this.readThru = true;
            } else {
                this.ttlAbs = ttl;
            }
        }
        this.setKeyString(CacheableRunner.buildKey(args));
    }

    public CacheableRunner(String ttl) {
        this(ttl, CacheableRunner.genCacheKey());
    }

    public RenderResult run() {
        if (!this.shouldCache()) {
            return this.render();
        }
        RenderResult rr = null;
        if (!this.readThru) {
            try {
                rr = RenderResultCache.get(this.getKeyString());
                if (rr != null) {
                    return rr;
                }
            }
            catch (ShouldRefreshException e) {
                // empty catch block
            }
        }
        try {
            rr = this.render();
        }
        catch (JapidResult e) {
            rr = e.getRenderResult();
        }
        this.cacheResult(rr);
        return rr;
    }

    protected boolean shouldCache() {
        return !this.noCache;
    }

    protected void cacheResult(RenderResult rr1) {
        RenderResultCache.set(this.getKeyString(), rr1, this.ttlAbs);
    }

    public static String buildKey(Object[] keys) {
        String keyString = "";
        for (Object k : keys) {
            keyString = keyString + ":" + String.valueOf(k);
        }
        if (keyString.startsWith(":")) {
            keyString = keyString.length() > 1 ? keyString.substring(1) : "";
        }
        return keyString;
    }

    protected abstract RenderResult render();

    public static void deleteCache(Object ... objects) {
        RenderResultCache.delete(CacheableRunner.buildKey(objects));
    }

    public static <C extends Controller> void deleteCache(Class<C> controllerClass, String actionName, Object ... args) {
        Object[] fullArgs = CacheableRunner.buildCacheKeyParts(controllerClass, actionName, args);
        CacheableRunner.deleteCache(fullArgs);
    }

    public static Object[] buildCacheKeyParts(Class<? extends Controller> controllerClass, String actionName, Object ... args) {
        Object[] fullArgs = new Object[args.length + 2];
        System.arraycopy(args, 0, fullArgs, 0, args.length);
        fullArgs[args.length] = controllerClass.getName();
        fullArgs[args.length + 1] = actionName;
        return fullArgs;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.ttlAbs);
        out.writeUTF(this.getKeyString());
        out.writeBoolean(this.noCache);
        out.writeBoolean(this.readThru);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ttlAbs = in.readUTF();
        this.setKeyString(in.readUTF());
        this.noCache = in.readBoolean();
        this.readThru = in.readBoolean();
    }

    public String getKeyString() {
        return this.keyString;
    }

    public void setKeyString(String keyString) {
        this.keyString = keyString;
    }

    public static String genCacheKey() {
        return "japidcache:" + Http.Request.current().action + ":" + Http.Request.current().querystring;
    }
}

