/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.compiler.JapidTemplateTransformer;
import cn.bran.japid.compiler.TranslateTemplateTask;
import cn.bran.japid.util.DirUtil;
import cn.bran.japid.util.JapidFlags;
import cn.bran.play.JapidPlayAdapter;
import cn.bran.play.NoEnhance;
import cn.bran.play.util.PlayDirUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import play.Play;
import play.data.validation.Error;
import play.data.validation.Validation;
import play.i18n.Lang;
import play.i18n.Messages;
import play.mvc.Http;
import play.mvc.Scope;
import play.templates.JavaExtensions;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidCommands {
    private static final String APP = "app";

    public static void main(String[] args) throws IOException {
        String arg0 = args[0];
        String applicationPath = ".";
        if (args.length > 1) {
            applicationPath = args[1];
        }
        Play.applicationPath = new File(applicationPath);
        String appPath = Play.applicationPath.getAbsolutePath() + File.separator;
        if ("gen".equals(arg0)) {
            JapidCommands.gen(appPath + APP);
        } else if ("regen".equals(arg0)) {
            JapidCommands.regen(appPath + APP);
        } else if ("clean".equals(arg0)) {
            JapidCommands.delAllGeneratedJava(appPath + APP + File.separator + "japidviews");
        } else if ("mkdir".equals(arg0)) {
            PlayDirUtil.mkdir(appPath + APP);
        } else {
            JapidFlags.log((String)("not known: " + arg0));
        }
    }

    public static void regen() throws IOException {
        JapidCommands.regen(APP);
    }

    public static void regen(String root) throws IOException {
        String pathname = root + File.separatorChar + "japidviews";
        JapidCommands.delAllGeneratedJava(pathname);
        JapidCommands.gen(root);
    }

    public static void delAllGeneratedJava(String pathname) {
        String[] javas;
        for (String j : javas = DirUtil.getAllFileNames((File)new File(pathname), (String[])new String[]{"java"})) {
            if (j.contains("_javatags")) continue;
            String filePath = pathname + File.separatorChar + j;
            JapidFlags.log((String)("removed: " + filePath));
            boolean delete = new File(filePath).delete();
            if (delete) continue;
            throw new RuntimeException("file was not deleted: " + j);
        }
    }

    public static void gen(String packageRoot) throws IOException {
        List<File> changedFiles = JapidCommands.reloadChanged(packageRoot);
        if (changedFiles.size() > 0) {
            for (File f : changedFiles) {
                String relativePath = JapidTemplateTransformer.getRelativePath((File)f, (File)Play.applicationPath);
                JapidFlags.log((String)("updated: " + relativePath.replace("html", "java")));
            }
        } else {
            JapidFlags.log((String)"No java files need to be updated.");
        }
        JapidCommands.rmOrphanJava();
    }

    public static List<File> reloadChanged(String root) {
        try {
            DirUtil.mkdir((String)root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        TranslateTemplateTask t = new TranslateTemplateTask();
        File rootDir = new File(root);
        t.setPackageRoot(rootDir);
        t.setInclude(new File(rootDir, "japidviews"));
        t.clearImports();
        t.importStatic(JapidPlayAdapter.class);
        t.importStatic(Validation.class);
        t.importStatic(JavaExtensions.class);
        t.addAnnotation(NoEnhance.class);
        if (DirUtil.hasLayouts((String)root)) {
            t.addImport("japidviews._layouts.*");
        }
        if (DirUtil.hasJavaTags((String)root)) {
            t.addImport("japidviews._javatags.*");
        }
        if (DirUtil.hasTags((String)root)) {
            t.addImport("japidviews._tags.*");
        }
        t.addImport("models.*");
        t.addImport("controllers.*");
        t.addImport(Scope.class.getName() + ".*");
        t.addImport(Messages.class);
        t.addImport(Lang.class);
        t.addImport(Http.class.getName() + ".*");
        t.addImport(Validation.class.getName());
        t.addImport(Error.class.getName());
        List javatags = DirUtil.scanJavaTags((String)root);
        for (String f : javatags) {
            t.addImport("static " + f + ".*");
        }
        t.execute();
        List changedFiles = t.getChangedFiles();
        return changedFiles;
    }

    public static String[] getAllJavaFilesInDir(File root) {
        String[] allFiles = DirUtil.getAllFileNames((File)root, (String[])new String[]{".java"});
        for (int i = 0; i < allFiles.length; ++i) {
            allFiles[i] = allFiles[i].replace(".java", "");
        }
        return allFiles;
    }

    public static boolean rmOrphanJava() {
        boolean hasOrphan = false;
        String appAbs = Play.applicationPath.getAbsolutePath() + File.separator + APP;
        hasOrphan = JapidCommands.removeOrphanedJavaFrom(appAbs);
        Collection modules = Play.modules.values();
        for (VirtualFile module : modules) {
            try {
                String absoluteRootPath;
                VirtualFile root = module.child(APP);
                VirtualFile japidViewDir = root.child("japidviews");
                File japidFile = japidViewDir.getRealFile();
                if (!japidFile.exists() || !JapidCommands.removeOrphanedJavaFrom(absoluteRootPath = root.getRealFile().getAbsolutePath())) continue;
                hasOrphan = true;
            }
            catch (Throwable t) {}
        }
        return hasOrphan;
    }

    private static boolean removeOrphanedJavaFrom(String root) {
        boolean hasRealOrphan = false;
        try {
            String pathname = root + File.separator + "japidviews";
            File src = new File(pathname);
            if (!src.exists()) {
                JapidFlags.log((String)("Could not find required Japid package structure: " + pathname));
                JapidFlags.log((String)"Please use \"play japid:mkdir\" command to create the Japid view structure.");
                return hasRealOrphan;
            }
            Set oj = DirUtil.findOrphanJava((File)src, null);
            for (File j : oj) {
                String path = j.getPath();
                if (path.contains("_javatags")) continue;
                hasRealOrphan = true;
                String realfile = pathname + File.separator + path;
                File file = new File(realfile);
                boolean r = file.delete();
                if (r) {
                    JapidFlags.log((String)("deleted orphan " + realfile));
                    continue;
                }
                JapidFlags.log((String)("failed to delete: " + realfile));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasRealOrphan;
    }

    public static List<File> reloadChanged() {
        List<File> reloadChanged = JapidCommands.reloadChanged(new File(Play.applicationPath, APP).getAbsolutePath());
        Collection modules = Play.modules.values();
        for (VirtualFile module : modules) {
            try {
                VirtualFile root = module.child(APP);
                VirtualFile japidViewDir = root.child("japidviews");
                File japidFile = japidViewDir.getRealFile();
                if (!japidFile.exists()) continue;
                String absoluteRootPath = root.getRealFile().getAbsolutePath();
                reloadChanged.addAll(JapidCommands.reloadChanged(absoluteRootPath));
            }
            catch (Throwable t) {}
        }
        return reloadChanged;
    }
}

