/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.template.JapidTemplateBaseWithoutPlay;
import cn.bran.japid.template.RenderResult;
import cn.bran.japid.util.StackTraceUtils;
import cn.bran.japid.util.StringUtils;
import cn.bran.play.JapidController2;
import cn.bran.play.JapidMailer;
import cn.bran.play.JapidPlayRenderer;
import cn.bran.play.JapidResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import play.Logger;
import play.exceptions.MailException;
import play.libs.Mail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidMailer2
extends JapidMailer {
    public static Future<Boolean> send(Object ... args) {
        try {
            List bccsList;
            InternetAddress iAddress;
            HtmlEmail htmlEmail;
            HashMap<String, Object> infoMap = JapidMailer2.getInfoMap();
            String charset = (String)infoMap.get("charset");
            Map headers = (Map)infoMap.get("headers");
            String subject = (String)infoMap.get("subject");
            String templateNameBase = StackTraceUtils.getCaller();
            if (!templateNameBase.startsWith("notifiers")) {
                throw new RuntimeException("The emailers must be put in the \"notifiers\" package.");
            }
            String templateClassName = "japidviews._" + templateNameBase;
            String bodyHtml = null;
            Class<? extends JapidTemplateBaseWithoutPlay> tClass = JapidPlayRenderer.getTemplateClass(templateClassName);
            if (tClass == null) {
                String templateFileName = templateClassName.replace('.', '/') + ".html";
                throw new RuntimeException("Japid Emailer: could not find a Japid template with the name of: " + templateFileName);
            }
            try {
                JapidController2.render(tClass, args);
            }
            catch (JapidResult jr) {
                RenderResult rr = jr.getRenderResult();
                bodyHtml = rr.getContent().toString();
            }
            List recipientList = (List)infoMap.get("recipients");
            Object from = infoMap.get("from");
            Object replyTo = infoMap.get("replyTo");
            HtmlEmail email = null;
            if (infoMap.get("attachments") == null) {
                htmlEmail = new HtmlEmail();
                htmlEmail.setHtmlMsg(bodyHtml);
                email = htmlEmail;
            } else {
                htmlEmail = new HtmlEmail();
                htmlEmail.setHtmlMsg(bodyHtml);
                email = htmlEmail;
                MultiPartEmail multiPartEmail = (MultiPartEmail)email;
                List objectList = (List)infoMap.get("attachments");
                for (EmailAttachment object : objectList) {
                    multiPartEmail.attach(object);
                }
            }
            if (from != null) {
                try {
                    iAddress = new InternetAddress(from.toString());
                    email.setFrom(iAddress.getAddress(), iAddress.getPersonal());
                }
                catch (Exception e) {
                    email.setFrom(from.toString());
                }
            }
            if (replyTo != null) {
                try {
                    iAddress = new InternetAddress(replyTo.toString());
                    email.addReplyTo(iAddress.getAddress(), iAddress.getPersonal());
                }
                catch (Exception e) {
                    email.addReplyTo(replyTo.toString());
                }
            }
            if (recipientList != null) {
                for (Object recipient : recipientList) {
                    try {
                        InternetAddress iAddress2 = new InternetAddress(recipient.toString());
                        email.addTo(iAddress2.getAddress(), iAddress2.getPersonal());
                    }
                    catch (Exception e) {
                        email.addTo(recipient.toString());
                    }
                }
            } else {
                throw new MailException("You must specify at least one recipient.");
            }
            List ccsList = (List)infoMap.get("ccs");
            if (ccsList != null) {
                for (Object cc : ccsList) {
                    email.addCc(cc.toString());
                }
            }
            if ((bccsList = (List)infoMap.get("bccs")) != null) {
                for (Object bcc : bccsList) {
                    try {
                        InternetAddress iAddress3 = new InternetAddress(bcc.toString());
                        email.addBcc(iAddress3.getAddress(), iAddress3.getPersonal());
                    }
                    catch (Exception e) {
                        email.addBcc(bcc.toString());
                    }
                }
            }
            if (!StringUtils.isEmpty((String)charset)) {
                email.setCharset(charset);
            }
            email.setSubject(subject);
            email.updateContentType("text/html");
            if (headers != null) {
                for (String key : headers.keySet()) {
                    email.addHeader(key, (String)headers.get(key));
                }
            }
            infos.remove();
            return Mail.send((Email)email);
        }
        catch (EmailException ex) {
            throw new MailException("Cannot send email", (Throwable)ex);
        }
    }

    public static boolean sendAndWait(Object ... args) {
        try {
            Future<Boolean> result = JapidMailer2.send(args);
            return result.get();
        }
        catch (InterruptedException e) {
            Logger.error((Throwable)e, (String)"Error while waiting Mail.send result", (Object[])new Object[0]);
        }
        catch (ExecutionException e) {
            Logger.error((Throwable)e, (String)"Error while waiting Mail.send result", (Object[])new Object[0]);
        }
        return false;
    }
}

