/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.compiler.JapidCompilationException;
import cn.bran.japid.compiler.TranslateTemplateTask;
import cn.bran.japid.rendererloader.RendererClass;
import cn.bran.japid.rendererloader.RendererCompiler;
import cn.bran.japid.rendererloader.TemplateClassLoader;
import cn.bran.japid.template.JapidTemplateBaseWithoutPlay;
import cn.bran.japid.template.RenderResult;
import cn.bran.japid.util.DirUtil;
import cn.bran.japid.util.JapidFlags;
import cn.bran.japid.util.RenderInvokerUtils;
import cn.bran.japid.util.StackTraceUtils;
import cn.bran.play.JapidController2;
import cn.bran.play.JapidPlayAdapter;
import cn.bran.play.rendererloader.TemplateClassLoaderWithPlay;
import cn.bran.play.util.PlayDirUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import play.Play;
import play.classloading.ApplicationClassloader;
import play.data.validation.Error;
import play.data.validation.Validation;
import play.exceptions.CompilationException;
import play.i18n.Lang;
import play.i18n.Messages;
import play.mvc.Http;
import play.mvc.Scope;
import play.templates.JavaExtensions;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidPlayRenderer {
    private static ApplicationClassloader playClassloader;
    public static final Map<String, RendererClass> japidClasses;
    public static TemplateClassLoaderWithPlay crlr;
    public static RendererCompiler compiler;
    public static String templateRoot;
    public static final String JAPIDVIEWS = "japidviews";
    public static String sep;
    public static String japidviews;
    public static List<String> importlines;
    public static int refreshInterval;
    public static long lastRefreshed;
    private static boolean usePlay;
    private static Play.Mode mode;

    public static JapidTemplateBaseWithoutPlay getRenderer(String name) {
        Class<? extends JapidTemplateBaseWithoutPlay> c = JapidPlayRenderer.getTemplateClass(name);
        try {
            return c.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<? extends JapidTemplateBaseWithoutPlay> getTemplateClass(String name) {
        JapidPlayRenderer.refreshClasses();
        RendererClass rc = japidClasses.get(name);
        if (rc == null) {
            throw new RuntimeException("Japid template class not found: " + name);
        }
        if (!JapidPlayRenderer.playClassloaderChanged()) {
            try {
                Class cls = rc.getClz();
                if (cls != null) {
                    return cls;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        JapidPlayRenderer.resetAllRenderClassUpdatedTime();
        TemplateClassLoaderWithPlay classReloader = new TemplateClassLoaderWithPlay();
        try {
            Class loadClass = classReloader.loadClass(name);
            rc.setClz(loadClass);
            return loadClass;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void resetAllRenderClassUpdatedTime() {
        for (String c : japidClasses.keySet()) {
            RendererClass rendererClass = japidClasses.get(c);
            rendererClass.setLastUpdated(0L);
        }
    }

    private static boolean playClassloaderChanged() {
        if (Play.classloader != playClassloader) {
            playClassloader = Play.classloader;
            return true;
        }
        return false;
    }

    static boolean timeToRefresh() {
        long now = System.currentTimeMillis();
        if (now - lastRefreshed > (long)refreshInterval) {
            lastRefreshed = now;
            return true;
        }
        return false;
    }

    static synchronized void refreshClasses() {
        if (!JapidPlayRenderer.timeToRefresh()) {
            return;
        }
        try {
            String[] allTemps = DirUtil.getAllTemplateFiles((File)new File(templateRoot));
            Set<String> currentClassesOnDir = JapidPlayRenderer.createNameSet(allTemps);
            HashSet<String> allNames = new HashSet<String>(currentClassesOnDir);
            Set<String> keySet = japidClasses.keySet();
            allNames.removeAll(keySet);
            JapidPlayRenderer.removeRemoved(currentClassesOnDir, keySet);
            for (String c : allNames) {
                RendererClass rc = JapidPlayRenderer.newRendererClass(c);
                japidClasses.put(c, rc);
            }
            List<File> gen = JapidPlayRenderer.gen(templateRoot);
            HashSet<String> updatedClasses = new HashSet<String>();
            if (gen.size() > 0) {
                for (File f : gen) {
                    String className = JapidPlayRenderer.getClassName(f);
                    updatedClasses.add(className);
                    RendererClass rendererClass = japidClasses.get(className);
                    if (rendererClass == null) {
                        throw new RuntimeException("any new class names should have been in the classes container: " + className);
                    }
                    JapidPlayRenderer.setSources(rendererClass, f);
                    JapidPlayRenderer.removeInnerClasses(className);
                    JapidPlayRenderer.cleanClassHolder(rendererClass);
                }
            }
            for (String k : japidClasses.keySet()) {
                RendererClass rc = japidClasses.get(k);
                if (rc.getSourceCode() == null) {
                    if (!rc.getClassName().contains("$")) {
                        String pathname = templateRoot + sep + k;
                        pathname = pathname.replace(".", sep);
                        File f = new File(pathname + ".java");
                        JapidPlayRenderer.setSources(rc, f);
                        JapidPlayRenderer.cleanClassHolder(rc);
                        updatedClasses.add(k);
                        continue;
                    }
                    rc.setLastUpdated(0L);
                    continue;
                }
                if (rc.getBytecode() != null) continue;
                JapidPlayRenderer.cleanClassHolder(rc);
                updatedClasses.add(k);
            }
            if (updatedClasses.size() > 0) {
                String[] names = new String[updatedClasses.size()];
                int i = 0;
                for (String s : updatedClasses) {
                    names[i++] = s;
                }
                long t = System.currentTimeMillis();
                compiler.compile(names);
                JapidPlayRenderer.howlong("compile time for " + names.length + " classes", t);
                for (String k : japidClasses.keySet()) {
                    RendererClass rc = japidClasses.get(k);
                    rc.setClz(null);
                }
            }
        }
        catch (JapidCompilationException e) {
            String tempName = e.getTemplateName();
            if (!tempName.startsWith(templateRoot)) {
                tempName = templateRoot + File.separator + tempName;
            }
            VirtualFile vf = VirtualFile.fromRelativePath((String)tempName);
            CompilationException ce = new CompilationException(vf, "\"" + e.getMessage() + "\"", e.getLineNumber(), 0, 0);
            throw ce;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void setSources(RendererClass rc, File f) {
        rc.setSourceCode(JapidPlayRenderer.readSource(f));
        File srcFile = DirUtil.mapJavatoSrc((File)f);
        rc.setOriSourceCode(JapidPlayRenderer.readSource(srcFile));
        rc.setSrcFile(srcFile);
    }

    public static void removeInnerClasses(String className) {
        Iterator<String> i = japidClasses.keySet().iterator();
        while (i.hasNext()) {
            String k = i.next();
            if (!k.startsWith(className + "$")) continue;
            i.remove();
        }
    }

    public static void removeRemoved(Set<String> currentClassesOnDir, Set<String> keySet) {
        Iterator<String> i = keySet.iterator();
        while (i.hasNext()) {
            String k = i.next();
            int q = k.indexOf(36);
            if (q > 0) {
                k = k.substring(0, q);
            }
            if (currentClassesOnDir.contains(k)) continue;
            i.remove();
        }
    }

    public static TemplateClassLoaderWithPlay getCrlr() {
        return crlr;
    }

    public static Play.Mode getMode() {
        if (mode == null) {
            return Play.mode;
        }
        return mode;
    }

    static void howlong(String string, long t) {
        if (JapidFlags.verbose) {
            System.out.println(string + ":" + (System.currentTimeMillis() - t) + "ms");
        }
    }

    static void cleanClassHolder(RendererClass rendererClass) {
        rendererClass.setBytecode(null);
        rendererClass.setClz(null);
        rendererClass.setLastUpdated(0L);
    }

    static Set<String> createNameSet(String[] allHtml) {
        HashSet<String> names = new HashSet<String>();
        for (String f : allHtml) {
            names.add(JapidPlayRenderer.getClassName(new File(f)));
        }
        return names;
    }

    static String getSourceCode(String k) {
        String pathname = templateRoot + sep + k;
        pathname = pathname.replace(".", sep);
        File f = new File(pathname + ".java");
        return JapidPlayRenderer.readSource(f);
    }

    static RendererClass newRendererClass(String c) {
        RendererClass rc = new RendererClass();
        rc.setClassName(c);
        rc.setLastUpdated(0L);
        return rc;
    }

    static String readSource(File f) {
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedInputStream bis = new BufferedInputStream(fis);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)bis, "UTF-8"));
            StringBuilder b = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                b.append(line + "\n");
            }
            br.close();
            return b.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String getClassName(File f) {
        String path = f.getPath();
        String substring = path.substring(path.indexOf(JAPIDVIEWS));
        substring = substring.replace('/', '.').replace('\\', '.');
        substring = (substring = DirUtil.mapSrcToJava((String)substring)).endsWith(".java") ? substring.substring(0, substring.length() - 5) : DirUtil.mapSrcToJava((String)substring);
        return substring;
    }

    static void setRefreshInterval(int i) {
        refreshInterval = i * 1000;
    }

    static void setTemplateRoot(String root) {
        templateRoot = root;
        japidviews = templateRoot + sep + JAPIDVIEWS + sep;
    }

    public static void main(String[] args) throws IOException {
        if (args.length > 0) {
            String arg0 = args[0];
            JapidPlayRenderer.setTemplateRoot(".");
            if ("gen".equals(arg0)) {
                JapidPlayRenderer.gen(templateRoot);
            } else if ("regen".equals(arg0)) {
                JapidPlayRenderer.regen(templateRoot);
            } else if ("clean".equals(arg0)) {
                JapidPlayRenderer.delAllGeneratedJava(JapidPlayRenderer.getJapidviewsDir(templateRoot));
            } else if ("mkdir".equals(arg0)) {
                JapidPlayRenderer.mkdir(templateRoot);
            } else if ("changed".equals(arg0)) {
                JapidPlayRenderer.changed(japidviews);
            } else {
                System.err.println("help:  optionas are: gen, regen, mkdir and clean");
            }
        } else {
            System.err.println("help:  optionas are: gen, regen, mkdir and clean");
        }
    }

    private static void changed(String root) {
        List changedFiles = DirUtil.findChangedSrcFiles((File)new File(root));
        for (File f : changedFiles) {
            System.out.println("changed: " + f.getPath());
        }
    }

    static List<File> mkdir(String root) throws IOException {
        return PlayDirUtil.mkdir(root);
    }

    private static String getJapidviewsDir(String root) {
        return root + sep + JAPIDVIEWS + sep;
    }

    static void regen() throws IOException {
        JapidPlayRenderer.regen(templateRoot);
    }

    public static void regen(String root) throws IOException {
        JapidPlayRenderer.delAllGeneratedJava(JapidPlayRenderer.getJapidviewsDir(root));
        JapidPlayRenderer.gen(root);
    }

    static void delAllGeneratedJava(String pathname) {
        String[] javas;
        for (String j : javas = DirUtil.getAllFileNames((File)new File(pathname), (String[])new String[]{"java"})) {
            JapidPlayRenderer.log("removed: " + pathname + j);
            boolean delete = new File(pathname + File.separatorChar + j).delete();
            if (delete) continue;
            throw new RuntimeException("file was not deleted: " + j);
        }
    }

    static List<File> gen(String packageRoot) throws IOException {
        List<File> changedFiles = JapidPlayRenderer.reloadChanged(packageRoot);
        if (changedFiles.size() <= 0 && JapidFlags.verbose) {
            System.out.print(":");
        }
        JapidPlayRenderer.rmOrphanJava(packageRoot);
        return changedFiles;
    }

    static List<File> reloadChanged(String root) {
        try {
            JapidPlayRenderer.mkdir(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        TranslateTemplateTask t = new TranslateTemplateTask();
        t.setUsePlay(usePlay);
        File rootDir = new File(root);
        t.setPackageRoot(rootDir);
        t.setInclude(new File(japidviews));
        if (DirUtil.hasLayouts((String)root)) {
            t.addImport("japidviews._layouts.*");
        }
        if (DirUtil.hasJavaTags((String)root)) {
            t.addImport("japidviews._javatags.*");
        }
        if (DirUtil.hasTags((String)root)) {
            t.addImport("japidviews._tags.*");
        }
        for (String imp : importlines) {
            t.addImport(imp);
        }
        t.importStatic(JapidPlayAdapter.class);
        t.importStatic(Validation.class);
        t.importStatic(JavaExtensions.class);
        t.addImport("models.*");
        t.addImport("controllers.*");
        t.addImport(Scope.class.getName() + ".*");
        t.addImport(Messages.class);
        t.addImport(Lang.class);
        t.addImport(Http.class.getName() + ".*");
        t.addImport(Validation.class.getName());
        t.addImport(Error.class.getName());
        List javatags = DirUtil.scanJavaTags((String)root);
        for (String f : javatags) {
            t.addImport("static " + f + ".*");
        }
        t.execute();
        return t.getChangedTargetFiles();
    }

    static File[] getAllJavaFilesInDir(String root) {
        String[] allFiles = DirUtil.getAllFileNames((File)new File(root), (String[])new String[]{".java"});
        File[] fs = new File[allFiles.length];
        int i = 0;
        for (String f : allFiles) {
            String path = f.replace(".java", "");
            fs[i++] = new File(path);
        }
        return fs;
    }

    static boolean rmOrphanJava(String packageRoot) {
        boolean hasRealOrphan = false;
        try {
            String pathname = JapidPlayRenderer.getJapidviewsDir(packageRoot);
            File src = new File(pathname);
            if (!src.exists()) {
                JapidPlayRenderer.log("Could not find required Japid root directory: " + pathname);
                return hasRealOrphan;
            }
            Set oj = DirUtil.findOrphanJava((File)src, null);
            for (File j : oj) {
                String path = j.getPath();
                if (path.contains("_javatags")) {
                    JapidFlags.log((String)"using util classes in _javatags folder is deprecated and will not take effect in post-controller Japid mode. Please use Play app's standard app/utils folder and import the classes accordingly");
                    continue;
                }
                hasRealOrphan = true;
                String realfile = pathname + File.separator + path;
                File file = new File(realfile);
                boolean r = file.delete();
                if (r) {
                    JapidFlags.log((String)("deleted orphan " + realfile));
                    continue;
                }
                JapidFlags.log((String)("failed to delete: " + realfile));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasRealOrphan;
    }

    static List<File> reloadChanged() {
        return JapidPlayRenderer.reloadChanged(templateRoot);
    }

    static void log(String m) {
        if (JapidFlags.verbose) {
            System.out.println("[JapidPlayRenderer]: " + m);
        }
    }

    static void gen() {
        if (templateRoot == null) {
            throw new RuntimeException("the template root directory must be set");
        }
        try {
            JapidPlayRenderer.gen(templateRoot);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isDevMode() {
        return JapidPlayRenderer.getMode().isDev();
    }

    static String removeSemi(String imp) {
        if ((imp = imp.trim()).endsWith(";")) {
            imp = imp.substring(0, imp.length() - 1);
        }
        return imp;
    }

    public static void addStaticImportLine(String imp) {
        importlines.add(" static " + JapidPlayRenderer.removeSemi(imp));
    }

    public static void addImportLine(String imp) {
        importlines.add(JapidPlayRenderer.removeSemi(imp));
    }

    public static String render(Class<? extends JapidTemplateBaseWithoutPlay> cls, Object ... args) {
        RenderResult r = RenderInvokerUtils.invokeRender(cls, (Object[])args);
        return r.getText();
    }

    public static void init(Play.Mode opMode, String templateRoot, int refreshInterval) {
        mode = opMode;
        JapidPlayRenderer.setTemplateRoot(templateRoot);
        JapidPlayRenderer.setRefreshInterval(refreshInterval);
        crlr = new TemplateClassLoaderWithPlay();
        compiler = new RendererCompiler(japidClasses, (TemplateClassLoader)crlr);
    }

    public static String render(Object ... args) {
        String templateName = JapidPlayRenderer.findTemplate();
        RenderResult r = JapidController2.getRenderResultWith(templateName, args);
        return r.getText();
    }

    public static String renderWith(String templateName, Object ... args) {
        RenderResult r = JapidController2.getRenderResultWith(templateName, args);
        return r.getText();
    }

    private static String findTemplate() {
        String japidRenderInvoker = StackTraceUtils.getJapidRenderInvoker();
        return japidRenderInvoker;
    }

    static {
        japidClasses = new ConcurrentHashMap<String, RendererClass>();
        templateRoot = "japidroot";
        sep = File.separator;
        japidviews = templateRoot + sep + JAPIDVIEWS + sep;
        importlines = new ArrayList<String>();
        usePlay = true;
        JapidPlayRenderer.init(null, "japidroot", 2);
    }
}

