/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.compiler.JapidCompilationException;
import cn.bran.japid.template.JapidTemplateBaseWithoutPlay;
import cn.bran.play.JapidCommands;
import cn.bran.play.JapidPlayRenderer;
import cn.bran.play.JapidPlayTemplate;
import cn.bran.play.RenderResultCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.exceptions.CompilationException;
import play.mvc.Http;
import play.mvc.Scope;
import play.mvc.results.Result;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidPlugin
extends PlayPlugin {
    private static final String RENDER_JAPID_WITH = "/renderJapidWith";
    private static final String NO_CACHE = "no-cache";
    private static AtomicLong lastTimeChecked = new AtomicLong(0L);
    private static Map<String, Object> japidCache = new ConcurrentHashMap<String, Object>();
    String dumpRequest = null;
    private static Pattern renderJapidWithPattern = Pattern.compile(".*/renderJapidWith/(.+)");

    public void onLoad() {
        Logger.info((String)"JapidPlugin.onload().", (Object[])new Object[0]);
        if (Play.mode == Play.Mode.DEV) {
            Logger.info((String)"[Japid] play in DEV mode. Detecting changes...", (Object[])new Object[0]);
            this.beforeDetectingChanges();
        } else {
            String isPrecompiling = System.getProperty("precompile");
            if (isPrecompiling != null && (isPrecompiling.equals("yes") || isPrecompiling.equals("true"))) {
                Logger.info((String)"[Japid] Running in PROD mode with precompiling: detect japid template changes.", (Object[])new Object[0]);
                this.beforeDetectingChanges();
            } else {
                Logger.info((String)"[Japid] Running in PROD mode without pre-compiling. If the Japid templates have not been compiled to Java code, please run 'play japid:gen' before starting the application.", (Object[])new Object[0]);
            }
        }
        this.getDumpRequest();
        this.setupInjectTemplateBorder();
    }

    private void setupInjectTemplateBorder() {
        String property = Play.configuration.getProperty("japid.trace.file", "false");
        if ("on".equalsIgnoreCase(property) || "yes".equalsIgnoreCase(property)) {
            property = "true";
        }
        JapidTemplateBaseWithoutPlay.globalTraceFile = new Boolean(property);
        property = Play.configuration.getProperty("japid.trace.file.html", "false");
        if ("on".equalsIgnoreCase(property) || "yes".equalsIgnoreCase(property)) {
            property = "true";
        }
        JapidTemplateBaseWithoutPlay.globalTraceFileHtml = new Boolean(property);
        property = Play.configuration.getProperty("japid.trace.file.json", "false");
        if ("on".equalsIgnoreCase(property) || "yes".equalsIgnoreCase(property)) {
            property = "true";
        }
        JapidTemplateBaseWithoutPlay.globalTraceFileJson = new Boolean(property);
    }

    public void onConfigurationRead() {
    }

    public static Map<String, Object> getCache() {
        return japidCache;
    }

    private void getDumpRequest() {
        String property;
        this.dumpRequest = property = Play.configuration.getProperty("japid.dump.request");
    }

    public void beforeDetectingChanges() {
        if (System.currentTimeMillis() - lastTimeChecked.get() < 1000L) {
            return;
        }
        try {
            List<File> changed = JapidCommands.reloadChanged();
            if (changed.size() > 0) {
                for (File f : changed) {
                }
            }
        }
        catch (JapidCompilationException e) {
            JapidPlayTemplate jpt = new JapidPlayTemplate();
            jpt.name = e.getTemplateName();
            jpt.source = e.getTemplateSrc();
            VirtualFile vf = VirtualFile.fromRelativePath((String)("/app/" + e.getTemplateName()));
            throw new CompilationException(vf, "\"" + e.getMessage() + "\"", e.getLineNumber(), 0, 0);
        }
        catch (RuntimeException e) {
            throw e;
        }
        boolean hasRealOrphan = JapidCommands.rmOrphanJava();
        lastTimeChecked.set(System.currentTimeMillis());
        if (hasRealOrphan) {
            Play.classes.clear();
            throw new RuntimeException("found orphan template Java artifacts. reload to be safe.");
        }
    }

    public void onApplicationStop() {
    }

    public void beforeActionInvocation(Method actionMethod) {
        String string;
        String property = Play.configuration.getProperty("japid.dump.request");
        if (property != null && property.length() > 0 && !"false".equals(property) && !"no".equals(property)) {
            if ("yes".equals(property) || "true".equals(property)) {
                System.out.println("--- action ->: " + Http.Request.current().action);
            } else if (Http.Request.current().url.matches(property)) {
                System.out.println("--- action ->: " + Http.Request.current().action);
            }
        }
        if ((string = Scope.Flash.current().get("j.rtf")) != null) {
            RenderResultCache.setIgnoreCache(true);
        } else {
            Http.Header header = (Http.Header)Http.Request.current().headers.get("cache-control");
            if (header != null) {
                List list = header.values;
                if (list.contains(NO_CACHE)) {
                    RenderResultCache.setIgnoreCache(true);
                }
            } else {
                header = (Http.Header)Http.Request.current().headers.get("pragma");
                if (header != null) {
                    List list = header.values;
                    if (list.contains(NO_CACHE)) {
                        RenderResultCache.setIgnoreCache(true);
                    }
                } else {
                    RenderResultCache.setIgnoreCacheInCurrentAndNextReq(false);
                }
            }
        }
    }

    public boolean rawInvocation(Http.Request req, Http.Response response) throws Exception {
        Play.Mode mode = Play.mode;
        if (mode == Play.Mode.DEV) {
            String path = req.path;
            if (path.endsWith("_japidgen")) {
                try {
                    this.beforeDetectingChanges();
                    JapidPlayRenderer.gen();
                }
                catch (Exception e) {
                    // empty catch block
                }
                response.out.write("OK".getBytes());
                return true;
            }
            if (path.endsWith("_japidregen")) {
                try {
                    JapidCommands.regen();
                    JapidPlayRenderer.regen();
                }
                catch (Exception e) {
                    // empty catch block
                }
                response.out.write("OK".getBytes());
                return true;
            }
        }
        if (this.dumpRequest != null && this.dumpRequest.length() > 0) {
            if ("yes".equals(this.dumpRequest) || "true".equals(this.dumpRequest)) {
                System.out.println("---->>" + req.method + " : " + req.url + " [" + req.action + "]");
            } else if (!"false".equals(this.dumpRequest) && !"no".equals(this.dumpRequest) && req.url.matches(this.dumpRequest)) {
                String querystring = req.querystring;
                querystring = querystring != null && querystring.length() > 0 ? "?" + querystring : "";
                System.out.println("---->>" + req.method + " : " + req.url + querystring);
                String contentType = req.contentType;
                if (contentType == null || contentType.length() == 0) {
                    contentType = "";
                }
                for (String k : req.headers.keySet()) {
                    Http.Header h = (Http.Header)req.headers.get(k);
                    System.out.println("... " + h.name + ":" + URLDecoder.decode(h.value(), "utf-8"));
                }
                if ("POST".equals(req.method)) {
                    if (contentType.contains("application/x-www-form-urlencoded")) {
                        this.dumpReqBody(req, true);
                    } else if (contentType.startsWith("text")) {
                        this.dumpReqBody(req, false);
                    } else if (!contentType.contains("multipart/form-data")) {
                        if (contentType.contains("xml")) {
                            this.dumpReqBody(req, false);
                        } else if (contentType.contains("javascript")) {
                            this.dumpReqBody(req, false);
                        }
                    }
                }
            }
        }
        return false;
    }

    private void dumpReqBody(Http.Request req, boolean urlDecode) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        InputStream bodystream = req.body;
        int r = bodystream.read();
        while (r > -1) {
            bos.write(r);
            r = bodystream.read();
        }
        bodystream.close();
        String body = bos.toString("UTF-8");
        if (urlDecode) {
            body = URLDecoder.decode(body, "UTF-8");
        }
        System.out.println("... body -> " + body);
        req.body = new ByteArrayInputStream(bos.toByteArray());
    }

    public void onActionInvocationResult(Result result) {
        Scope.Flash fl = Scope.Flash.current();
        if (RenderResultCache.shouldIgnoreCacheInCurrentAndNextReq()) {
            fl.put("j.rtf", "yes");
        } else {
            fl.remove("j.rtf");
            fl.discard("j.rtf");
        }
        RenderResultCache.setIgnoreCacheInCurrentAndNextReq(false);
    }

    public void afterActionInvocation() {
    }

    public void detectChange() {
    }

    public void beforeInvocation() {
    }

    public void afterApplicationStart() {
        this.getDumpRequest();
        this.setupInjectTemplateBorder();
    }

    public void onApplicationStart() {
        System.out.println("JapidPlugin: clean japidCache");
        japidCache.clear();
    }

    public void onEvent(String message, Object context) {
    }

    public void routeRequest(Http.Request request) {
    }
}

