/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play.util;

import cn.bran.japid.util.JapidFlags;
import cn.bran.play.JapidCommands;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import play.Play;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayDirUtil {
    public static List<File> mkdir(String root) throws IOException {
        boolean mkdirs;
        File ff;
        String cp;
        String[] controllers;
        File notifiers;
        File tags;
        File layouts;
        String sep = File.separator;
        String japidViews = root + sep + "japidviews" + sep;
        File javatags = new File(japidViews + "_javatags");
        if (!javatags.exists()) {
            boolean mkdirs2 = javatags.mkdirs();
            assert (mkdirs2);
            JapidFlags.log((String)("created: " + japidViews + "_javatags"));
        }
        if (!(layouts = new File(japidViews + "_layouts")).exists()) {
            boolean mkdirs3 = layouts.mkdirs();
            assert (mkdirs3);
            JapidFlags.log((String)("created: " + japidViews + "_layouts"));
        }
        if (!(tags = new File(japidViews + "_tags")).exists()) {
            boolean mkdirs4 = tags.mkdirs();
            assert (mkdirs4);
            JapidFlags.log((String)("created: " + japidViews + "_tags"));
        }
        if (!(notifiers = new File(japidViews + "_notifiers")).exists()) {
            boolean mkdirs5 = notifiers.mkdirs();
            assert (mkdirs5);
            JapidFlags.log((String)("created: " + japidViews + "_notifiers"));
        }
        File[] dirs = new File[]{javatags, layouts, tags};
        ArrayList<File> res = new ArrayList<File>();
        res.addAll(Arrays.asList(dirs));
        try {
            String controllerPath = Play.applicationPath + sep + "app" + sep + "controllers";
            File controllerPathFile = new File(controllerPath);
            if (controllerPathFile.exists()) {
                for (String f : controllers = JapidCommands.getAllJavaFilesInDir(controllerPathFile)) {
                    cp = japidViews + f;
                    ff = new File(cp);
                    if (ff.exists()) continue;
                    mkdirs = ff.mkdirs();
                    assert (mkdirs);
                    res.add(ff);
                    JapidFlags.log((String)("created: " + cp));
                }
            }
        }
        catch (Exception e) {
            JapidFlags.log((String)e.toString());
        }
        try {
            String notifiersDir = Play.applicationPath + sep + "app" + sep + "notifiers";
            File notifiersDirFile = new File(notifiersDir);
            if (!notifiersDirFile.exists()) {
                if (notifiersDirFile.mkdir()) {
                    JapidFlags.log((String)"created the email notifiers directory. ");
                } else {
                    JapidFlags.log((String)"email notifiers directory did not exist and could not be created for unknow reason. ");
                }
            }
            for (String f : controllers = JapidCommands.getAllJavaFilesInDir(notifiersDirFile)) {
                cp = japidViews + "_notifiers" + sep + f;
                ff = new File(cp);
                if (ff.exists()) continue;
                mkdirs = ff.mkdirs();
                assert (mkdirs);
                res.add(ff);
                JapidFlags.log((String)("created: " + cp));
            }
        }
        catch (Exception e) {
            JapidFlags.log((String)e.toString());
        }
        return res;
    }
}

