/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.template;

import cn.bran.japid.classmeta.MimeTypeEnum;
import cn.bran.japid.compiler.NamedArgRuntime;
import cn.bran.japid.tags.Each;
import cn.bran.japid.template.RenderResult;
import cn.bran.japid.util.HTMLUtils;
import cn.bran.japid.util.StringUtils;
import cn.bran.japid.util.WebUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JapidTemplateBaseWithoutPlay
implements Serializable {
    protected String sourceTemplate = "";
    private StringBuilder out;
    private Map<String, String> headers = new TreeMap<String, String>();
    private Boolean traceFile;
    private String contentType;
    public Method renderMethodInstance;
    public boolean hasDoBody;
    public String[] argNamesInstance;
    public String[] argTypesInstance;
    public Object[] argDefaultsInstance;
    private MimeTypeEnum mimeType;
    private Boolean traceFileExit;
    public static boolean globalTraceFile = false;
    public static Boolean globalTraceFileHtml = null;
    public static Boolean globalTraceFileJson = null;

    public void setOut(StringBuilder out) {
        this.out = out;
    }

    protected StringBuilder getOut() {
        return this.out;
    }

    protected void putHeader(String k, String v) {
        this.headers.put(k, v);
    }

    protected Map<String, String> getHeaders() {
        return this.headers;
    }

    public JapidTemplateBaseWithoutPlay(StringBuilder out2) {
        this.headers.put("Content-Type", "text/html; charset=utf-8");
        this.traceFile = null;
        this.contentType = "";
        this.hasDoBody = false;
        this.argNamesInstance = null;
        this.argTypesInstance = null;
        this.argDefaultsInstance = null;
        this.traceFileExit = null;
        this.out = out2 == null ? new StringBuilder(4000) : out2;
    }

    protected final void p(String s) {
        this.writeString(s);
    }

    protected final void pln(String s) {
        this.writeString(s);
        this.out.append('\n');
    }

    private final void writeString(String s) {
        if (s != null && !s.isEmpty()) {
            this.out.append(s);
        }
    }

    protected final void p(Object s) {
        if (s != null) {
            this.writeString(s.toString());
        }
    }

    protected final void pln(Object s) {
        if (s != null) {
            this.writeString(s.toString());
        }
        this.pln();
    }

    protected final void pln() {
        this.out.append('\n');
    }

    protected void layout() {
        this.doLayout();
    }

    protected abstract void doLayout();

    protected static byte[] getBytes(String src) {
        if (src == null || src.length() == 0) {
            return new byte[0];
        }
        try {
            return src.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.out.toString();
    }

    protected String get(String methodName, String defaultVal) {
        try {
            Method method = this.getClass().getMethod(methodName, null);
            String invoke = (String)method.invoke((Object)this, (Object[])null);
            return invoke;
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    protected String get(String methodName) {
        try {
            Method method = this.getClass().getMethod(methodName, null);
            String invoke = (String)method.invoke((Object)this, (Object[])null);
            return invoke;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean asBoolean(Object o) {
        return WebUtils.asBoolean(o);
    }

    public static String escape(Object o) {
        if (o == null) {
            return null;
        }
        return HTMLUtils.htmlEscape(o.toString());
    }

    public static Method getRenderMethod(Class<? extends JapidTemplateBaseWithoutPlay> currentClass) {
        Method[] methods = currentClass.getDeclaredMethods();
        Method r = null;
        for (Method m : methods) {
            if (!m.getName().equals("render")) continue;
            Class<?>[] parameterTypes = m.getParameterTypes();
            int paramLength = parameterTypes.length;
            if (paramLength == 1) {
                Class<?> t = parameterTypes[0];
                if (t == NamedArgRuntime[].class || r != null) continue;
                r = m;
                continue;
            }
            boolean hasNamedArg = false;
            for (Class<?> c : parameterTypes) {
                if (c != NamedArgRuntime.class && c != NamedArgRuntime[].class) continue;
                hasNamedArg = true;
                break;
            }
            if (hasNamedArg) continue;
            if (r == null) {
                r = m;
                continue;
            }
            if (paramLength <= r.getParameterTypes().length) continue;
            r = m;
        }
        if (r != null) {
            return r;
        }
        throw new RuntimeException("no render method found for the template: " + currentClass.getCanonicalName());
    }

    protected void setHasDoBody() {
        this.hasDoBody = true;
    }

    protected void setRenderMethod(Method renderMethod) {
        this.renderMethodInstance = renderMethod;
    }

    protected void setArgNames(String[] argNames) {
        this.argNamesInstance = argNames;
    }

    protected void setArgTypes(String[] argTypes) {
        this.argTypesInstance = argTypes;
    }

    protected void setArgDefaults(Object[] argDefaults) {
        this.argDefaultsInstance = argDefaults;
    }

    protected static NamedArgRuntime named(String name, Object val) {
        return new NamedArgRuntime(name, val);
    }

    public RenderResult render(NamedArgRuntime ... named) {
        Object[] args = null;
        args = this.hasDoBody ? this.buildArgs(named, null) : this.buildArgs(named);
        return this.runRenderer(args);
    }

    protected RenderResult runRenderer(Object[] args) {
        try {
            return (RenderResult)this.renderMethodInstance.invoke((Object)this, args);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw new RuntimeException(t);
        }
    }

    public Object[] buildArgs(NamedArgRuntime[] namedArgs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (NamedArgRuntime na : namedArgs) {
            map.put(na.name, na.val);
        }
        Object[] ret = new Object[this.argNamesInstance.length];
        for (int i = 0; i < this.argNamesInstance.length; ++i) {
            Object defaultVal;
            String name = this.argNamesInstance[i];
            if (map.containsKey(name)) {
                ret[i] = map.remove(name);
                continue;
            }
            Object defa = this.argDefaultsInstance[i];
            if (defa != null) {
                ret[i] = defa;
                continue;
            }
            String type = this.argTypesInstance[i];
            ret[i] = defaultVal = this.getDefaultValForType(type);
        }
        if (map.size() > 0) {
            Set keys = map.keySet();
            String sep = ", ";
            String ks = "[" + StringUtils.join(keys, sep) + "]";
            String vs = "[" + StringUtils.join(this.argNamesInstance, sep) + "]";
            throw new RuntimeException("One or more argument names are not valid: " + ks + ". Valid argument names are: " + vs);
        }
        return ret;
    }

    protected Object[] buildArgs(NamedArgRuntime[] named, Object body) {
        Object[] obsNoBody = this.buildArgs(named);
        int len = obsNoBody.length;
        Object[] ret = new Object[len + 1];
        System.arraycopy(obsNoBody, 0, ret, 0, len);
        ret[len] = body;
        return ret;
    }

    private Object getDefaultValForType(String type) {
        if (type.equals("String")) {
            return "";
        }
        if (type.equals("boolean")) {
            return false;
        }
        if (type.equals("char")) {
            return Character.valueOf('\u0000');
        }
        if (type.equals("byte")) {
            return (byte)0;
        }
        if (type.equals("short")) {
            return (short)0;
        }
        if (type.equals("int")) {
            return 0;
        }
        if (type.equals("float")) {
            return Float.valueOf(0.0f);
        }
        if (type.equals("long")) {
            return 0L;
        }
        if (type.equals("double")) {
            return 0.0;
        }
        return null;
    }

    protected void handleException(RuntimeException e) {
        throw e;
    }

    protected void setSourceTemplate(String st) {
        this.sourceTemplate = st;
    }

    protected void traceFile() {
        this.traceFileExit = true;
        this.p(this.makeBeginBorder(this.sourceTemplate));
    }

    protected String makeBeginBorder(String viewSource) {
        if (StringUtils.isEmpty(this.contentType)) {
            return null;
        }
        String formatter = JapidTemplateBaseWithoutPlay.getContentCommentFormatter(this.contentType);
        if (formatter == null) {
            return "";
        }
        return String.format(formatter, "enter: \"" + viewSource + "\"");
    }

    protected String makeEndBorder(String viewSource) {
        if (StringUtils.isEmpty(this.contentType)) {
            return null;
        }
        String formatter = JapidTemplateBaseWithoutPlay.getContentCommentFormatter(this.contentType);
        if (formatter == null) {
            return "";
        }
        return String.format(formatter, "exit: \"" + viewSource + "\"");
    }

    private boolean shouldTraceFile() {
        if (this.traceFile != null) {
            return this.traceFile;
        }
        if (this.mimeType == MimeTypeEnum.xml || this.mimeType == MimeTypeEnum.html) {
            if (globalTraceFileHtml != null) {
                return globalTraceFileHtml;
            }
            return globalTraceFile;
        }
        if (this.mimeType == MimeTypeEnum.js || this.mimeType == MimeTypeEnum.json) {
            if (globalTraceFileJson != null) {
                return globalTraceFileJson;
            }
            return globalTraceFile;
        }
        return false;
    }

    protected void beginDoLayout(String viewSource) {
        if (this.shouldTraceFile()) {
            this.p(this.makeBeginBorder(viewSource));
        }
    }

    protected void endDoLayout(String viewSource) {
        if (this.shouldTraceFile()) {
            this.p(this.makeEndBorder(viewSource));
        } else if (this.traceFileExit != null && this.traceFileExit.booleanValue()) {
            this.p(this.makeEndBorder(viewSource));
        }
    }

    public static String getContentCommentFormatter(String contentTypeString) {
        if (contentTypeString.contains("xml") || contentTypeString.contains("html")) {
            return "<!-- %s -->";
        }
        if (contentTypeString.contains("json") || contentTypeString.contains("javascript") || contentTypeString.contains("css")) {
            return "/* %s */";
        }
        return null;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        if (contentType.contains("xml")) {
            this.mimeType = MimeTypeEnum.xml;
        } else if (contentType.contains("html")) {
            this.mimeType = MimeTypeEnum.html;
        } else if (contentType.contains("javascript")) {
            this.mimeType = MimeTypeEnum.js;
        } else if (contentType.contains("json")) {
            this.mimeType = MimeTypeEnum.json;
        } else if (contentType.contains("css")) {
            this.mimeType = MimeTypeEnum.css;
        }
    }

    public Boolean getTraceFile() {
        return this.traceFile;
    }

    public void setTraceFile(Boolean traceFile) {
        this.traceFile = traceFile;
    }

    protected void breakLoop() {
        throw new Each.BreakLoop();
    }

    protected void continueLoop() {
        throw new Each.ContinueLoop();
    }
}

