/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.util;

import cn.bran.japid.util.JapidFlags;
import cn.bran.play.JapidCommands;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirUtil {
    private static final String[] ALL_EXTS = new String[]{".java", ".html", ".js", ".txt", ".css", ".json", ".xml"};
    private static final String[] TEMPLATE_EXTS = new String[]{".html", ".js", ".txt", ".css", ".xml", ".json"};
    public static final String JAVATAGS = "_javatags";
    public static final String LAYOUTDIR = "_layouts";
    public static final String TAGSDIR = "_tags";
    public static final String JAPIDVIEWS_ROOT = "japidviews";

    public static Set<File> findOrphanJava(File src, File target) {
        if (target == null) {
            target = src;
        }
        String[] allSrc = DirUtil.getAllFileNames(src, ALL_EXTS);
        HashSet<String> javas = new HashSet<String>();
        HashSet<String> srcFiles = new HashSet<String>();
        for (String s : allSrc) {
            if (s.endsWith(".java")) {
                javas.add(s);
                continue;
            }
            srcFiles.add(DirUtil.mapSrcToJava(s));
        }
        javas.removeAll(srcFiles);
        HashSet<File> re = new HashSet<File>();
        for (String j : javas) {
            re.add(new File(j));
        }
        return re;
    }

    public static String[] getAllFileNames(File dir, String[] exts) {
        ArrayList<String> files = new ArrayList<String>();
        DirUtil.getAllFileNames("", dir, files, exts);
        String[] ret = new String[files.size()];
        return files.toArray(ret);
    }

    public static String[] getAllTemplateHtmlFiles(File dir) {
        ArrayList<String> files = new ArrayList<String>();
        DirUtil.getAllFileNames("", dir, files, new String[]{".html"});
        String[] ret = new String[files.size()];
        return files.toArray(ret);
    }

    public static String[] getAllTemplateFiles(File dir) {
        ArrayList<String> files = new ArrayList<String>();
        DirUtil.getAllFileNames("", dir, files, TEMPLATE_EXTS);
        String[] ret = new String[files.size()];
        return files.toArray(ret);
    }

    public static Set<File> getAllFiles(File dir, String[] exts, Set<File> fs) {
        Set<File> scanFiles = DirUtil.scanFiles(dir, exts, fs);
        return scanFiles;
    }

    private static Set<File> scanFiles(File dir, String[] exts, Set<File> fs) {
        File[] flist;
        for (File f : flist = dir.listFiles()) {
            if (f.isDirectory()) {
                DirUtil.getAllFiles(f, exts, fs);
                continue;
            }
            if (!DirUtil.match(f, exts)) continue;
            fs.add(f);
        }
        return fs;
    }

    private static void getAllFileNames(String leadingPath, File dir, List<String> files, String[] exts) {
        File[] flist;
        if (!dir.exists()) {
            return;
        }
        for (File f : flist = dir.listFiles()) {
            if (f.isDirectory()) {
                DirUtil.getAllFileNames(leadingPath + f.getName() + File.separatorChar, f, files, exts);
                continue;
            }
            if (!DirUtil.match(f, exts)) continue;
            files.add(leadingPath + f.getName());
        }
    }

    static boolean match(File f, String[] exts) {
        for (String ext : exts) {
            if (!f.getName().endsWith(ext) || !DirUtil.fileNameIsValidClassName(f)) continue;
            return true;
        }
        return false;
    }

    public static List<File> findChangedSrcFiles(File srcDir) {
        Set<File> allSrc = new HashSet<File>();
        allSrc = DirUtil.getAllFiles(srcDir, ALL_EXTS, allSrc);
        HashMap<String, Long> javas = new HashMap<String, Long>();
        HashMap<String, Long> srcFiles = new HashMap<String, Long>();
        for (File f : allSrc) {
            String path = f.getPath();
            long modi = f.lastModified();
            if (path.endsWith(".java")) {
                javas.put(path, modi);
                continue;
            }
            if (!DirUtil.fileNameIsValidClassName(f)) continue;
            srcFiles.put(path, modi);
        }
        ArrayList<File> rs = new ArrayList<File>();
        for (String src : srcFiles.keySet()) {
            String javak = DirUtil.mapSrcToJava(src);
            Long t = (Long)javas.get(javak);
            if (t == null) {
                rs.add(new File(src));
                continue;
            }
            Long srcStamp = (Long)srcFiles.get(src);
            if (srcStamp.compareTo(t) <= 0) continue;
            rs.add(new File(src));
        }
        return rs;
    }

    private static boolean fileNameIsValidClassName(File f) {
        String fname = f.getName();
        if (fname.startsWith(".")) {
            return false;
        }
        fname = fname.substring(0, fname.lastIndexOf(".")).replace('.', '_');
        return DirUtil.isClassname(fname);
    }

    public static String mapSrcToJava(String k) {
        if (k.endsWith(".txt")) {
            return DirUtil.getRoot(k) + "_txt" + ".java";
        }
        if (k.endsWith(".xml")) {
            return DirUtil.getRoot(k) + "_xml" + ".java";
        }
        if (k.endsWith(".json")) {
            return DirUtil.getRoot(k) + "_json" + ".java";
        }
        if (k.endsWith(".css")) {
            return DirUtil.getRoot(k) + "_css" + ".java";
        }
        if (k.endsWith(".js")) {
            return DirUtil.getRoot(k) + "_js" + ".java";
        }
        return DirUtil.getRoot(k) + ".java";
    }

    public static String mapJavaToSrc(String k) {
        if (k.endsWith(".java")) {
            k = k.substring(0, k.lastIndexOf(".java"));
        }
        if (k.endsWith("_txt")) {
            return k.substring(0, k.lastIndexOf("_txt")) + ".txt";
        }
        if (k.endsWith("_xml")) {
            return k.substring(0, k.lastIndexOf("_xml")) + ".xml";
        }
        if (k.endsWith("_json")) {
            return k.substring(0, k.lastIndexOf("_json")) + ".json";
        }
        if (k.endsWith("_css")) {
            return k.substring(0, k.lastIndexOf("_css")) + ".css";
        }
        if (k.endsWith("_js")) {
            return k.substring(0, k.lastIndexOf("_js")) + ".js";
        }
        return k + ".html";
    }

    private static String getRoot(String k) {
        int indexOf = k.lastIndexOf(".");
        if (indexOf > 0) {
            return k.substring(0, indexOf);
        }
        return k;
    }

    public static void writeStringToFile(File file, String content) throws IOException {
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        BufferedWriter bw = new BufferedWriter(fw);
        bw.append(content);
        bw.close();
    }

    public static void touch(File newer) throws IOException {
        DirUtil.writeStringToFile(newer, "");
    }

    public static boolean containsTemplateFiles(String root, String dirName) {
        String sep = File.separator;
        String japidViews = root + sep + JAPIDVIEWS_ROOT + sep;
        String dir = japidViews + dirName;
        return DirUtil.containsTemplatesInDir(dir);
    }

    public static boolean containsTemplatesInDir(String dirName) {
        File dir = new File(dirName);
        if (dir.exists()) {
            String[] temps = DirUtil.getAllFileNames(dir, TEMPLATE_EXTS);
            return temps.length > 0;
        }
        return false;
    }

    public static boolean hasTags(String root) {
        String dirName = TAGSDIR;
        return DirUtil.containsTemplateFiles(root, dirName);
    }

    public static boolean hasJavaTags(String root) {
        String dirName = JAVATAGS;
        return DirUtil.containsTemplateFiles(root, dirName);
    }

    public static boolean hasLayouts(String root) {
        String dirName = LAYOUTDIR;
        return DirUtil.containsTemplateFiles(root, dirName);
    }

    public static boolean isClassname(String classname) {
        if (classname == null || classname.length() == 0) {
            return false;
        }
        StringCharacterIterator iter = new StringCharacterIterator(classname);
        char c = iter.first();
        if (c == '\uffff') {
            return false;
        }
        if (!Character.isJavaIdentifierStart(c) && !Character.isIdentifierIgnorable(c)) {
            return false;
        }
        c = iter.next();
        while (c != '\uffff') {
            if (!Character.isJavaIdentifierPart(c) && !Character.isIdentifierIgnorable(c)) {
                return false;
            }
            c = iter.next();
        }
        return true;
    }

    public static List<String> scanJavaTags(String root) {
        String sep = File.separator;
        String japidViews = root + sep + JAPIDVIEWS_ROOT + sep;
        File javatags = new File(japidViews + JAVATAGS);
        if (!javatags.exists()) {
            boolean mkdirs = javatags.mkdirs();
            assert (mkdirs);
            JapidFlags.log("created: " + japidViews + JAVATAGS);
        }
        File[] javafiles = javatags.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        });
        ArrayList<String> files = new ArrayList<String>();
        for (File f : javafiles) {
            String fname = f.getName();
            files.add("japidviews._javatags." + fname.substring(0, fname.lastIndexOf(".java")));
        }
        return files;
    }

    public static File mapJavatoSrc(File f) {
        File parent = f.getParentFile();
        String fname = DirUtil.mapJavaToSrc(f.getName());
        return new File(parent, fname);
    }

    public static int mapJavaLineToSrcLine(String sourceCode, int lineNum) {
        String[] codeLines = sourceCode.split("\n");
        String line = codeLines[lineNum - 1];
        int lineMarker = line.lastIndexOf("// line ");
        if (lineMarker < 1) {
            return 0;
        }
        int oriLineNumber = Integer.parseInt(line.substring(lineMarker + 8).trim());
        return oriLineNumber;
    }

    public static List<File> mkdir(String root) throws IOException {
        boolean mkdirs;
        File ff;
        String cp;
        String[] controllers;
        File notifiers;
        File tags;
        File layouts;
        String sep = File.separator;
        String japidViews = root + sep + JAPIDVIEWS_ROOT + sep;
        File javatags = new File(japidViews + JAVATAGS);
        if (!javatags.exists()) {
            boolean mkdirs2 = javatags.mkdirs();
            assert (mkdirs2);
            JapidFlags.log("created: " + japidViews + JAVATAGS);
        }
        if (!(layouts = new File(japidViews + LAYOUTDIR)).exists()) {
            boolean mkdirs3 = layouts.mkdirs();
            assert (mkdirs3);
            JapidFlags.log("created: " + japidViews + LAYOUTDIR);
        }
        if (!(tags = new File(japidViews + TAGSDIR)).exists()) {
            boolean mkdirs4 = tags.mkdirs();
            assert (mkdirs4);
            JapidFlags.log("created: " + japidViews + TAGSDIR);
        }
        if (!(notifiers = new File(japidViews + "_notifiers")).exists()) {
            boolean mkdirs5 = notifiers.mkdirs();
            assert (mkdirs5);
            JapidFlags.log("created: " + japidViews + "_notifiers");
        }
        File[] dirs = new File[]{javatags, layouts, tags};
        ArrayList<File> res = new ArrayList<File>();
        res.addAll(Arrays.asList(dirs));
        try {
            String controllerPath = root + sep + "controllers";
            File controllerPathFile = new File(controllerPath);
            if (controllerPathFile.exists()) {
                for (String f : controllers = JapidCommands.getAllJavaFilesInDir((File)controllerPathFile)) {
                    cp = japidViews + f;
                    ff = new File(cp);
                    if (ff.exists()) continue;
                    mkdirs = ff.mkdirs();
                    assert (mkdirs);
                    res.add(ff);
                    JapidFlags.log("created: " + cp);
                }
            }
        }
        catch (Exception e) {
            JapidFlags.log(e.toString());
        }
        try {
            String notifiersDir = root + sep + "notifiers";
            File notifiersDirFile = new File(notifiersDir);
            if (!notifiersDirFile.exists()) {
                if (notifiersDirFile.mkdir()) {
                    JapidFlags.log("created the email notifiers directory. ");
                } else {
                    JapidFlags.log("email notifiers directory did not exist and could not be created for unknow reason. ");
                }
            }
            for (String f : controllers = JapidCommands.getAllJavaFilesInDir((File)notifiersDirFile)) {
                cp = japidViews + "_notifiers" + sep + f;
                ff = new File(cp);
                if (ff.exists()) continue;
                mkdirs = ff.mkdirs();
                assert (mkdirs);
                res.add(ff);
                JapidFlags.log("created: " + cp);
            }
        }
        catch (Exception e) {
            JapidFlags.log(e.toString());
        }
        return res;
    }
}

