/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.template.RenderResult;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import play.mvc.Http;
import play.mvc.results.Result;

public class JapidResult
extends Result
implements Externalizable {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CACHE_CONTROL = "Cache-Control";
    private RenderResult renderResult;
    private Map<String, String> headers = new HashMap<String, String>();
    private boolean eager = false;
    String resultContent = "";

    public JapidResult(RenderResult r) {
        this.renderResult = r;
        this.headers = r.getHeaders();
    }

    public JapidResult() {
    }

    public JapidResult(String description) {
        super(description);
    }

    public JapidResult eval() {
        this.eager = true;
        this.resultContent = this.extractContent();
        return this;
    }

    public String extractContent() {
        String content = "";
        StringBuilder sb = this.renderResult.getContent();
        if (sb != null) {
            content = sb.toString();
        }
        return content;
    }

    public void apply(Http.Request request, Http.Response response) {
        String content = this.resultContent;
        if (!this.eager) {
            content = this.extractContent();
        }
        if (content != null) {
            try {
                Http.Response.current().out.write(content.getBytes("UTF-8"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Map resHeaders = response.headers;
        if (this.headers != null) {
            for (String h : this.headers.keySet()) {
                String value = this.headers.get(h);
                if (CONTENT_TYPE.equals(h)) {
                    this.setContentTypeIfNotSet(response, value);
                    continue;
                }
                if (resHeaders.containsKey(h)) {
                    response.setHeader(h, value);
                    continue;
                }
                response.setHeader(h, value);
            }
        }
    }

    public RenderResult getRenderResult() {
        return this.renderResult;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.renderResult);
        out.writeObject(this.headers);
        out.writeBoolean(this.eager);
        out.writeUTF(this.resultContent);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.renderResult = (RenderResult)in.readObject();
        this.headers = (Map)in.readObject();
        this.eager = in.readBoolean();
        this.resultContent = in.readUTF();
    }

    public synchronized Throwable fillInStackTrace() {
        return this;
    }
}

