/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.template.RenderResult;
import cn.bran.japid.util.StackTraceUtils;
import cn.bran.japid.util.StringUtils;
import cn.bran.play.JapidController;
import cn.bran.play.JapidResult;
import cn.bran.play.JapidTemplateBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import play.Logger;
import play.Play;
import play.exceptions.MailException;
import play.exceptions.UnexpectedException;
import play.libs.Mail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidMailer {
    private static final String TEXT_HTML = "text/html";
    private static final String HEADERS = "headers";
    private static final String SUBJECT = "subject";
    private static final String CHARSET = "charset";
    private static final String REPLY_TO = "replyTo";
    private static final String FROM = "from";
    private static final String CONTENT_TYPE = "contentType";
    private static final String ATTACHMENTS = "attachments";
    private static final String CCS = "ccs";
    private static final String BCCS = "bccs";
    private static final String RECIPIENTS = "recipients";
    protected static ThreadLocal<HashMap<String, Object>> infos = new ThreadLocal<HashMap<String, Object>>(){

        @Override
        protected HashMap<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    public static void setSubject(String subject, Object ... args) {
        HashMap<String, Object> map = JapidMailer.getInfoMap();
        map.put(SUBJECT, String.format(subject, args));
        infos.set(map);
    }

    private static HashMap<String, Object> getInfoMap() {
        HashMap<String, Object> map = infos.get();
        if (map == null) {
            throw new UnexpectedException("Mailer not instrumented ?");
        }
        return map;
    }

    public static void addRecipient(Object ... recipients) {
        HashMap<String, Object> map = JapidMailer.getInfoMap();
        ArrayList<Object> recipientsList = (ArrayList<Object>)map.get(RECIPIENTS);
        if (recipientsList == null) {
            recipientsList = new ArrayList<Object>();
            map.put(RECIPIENTS, recipientsList);
        }
        recipientsList.addAll(Arrays.asList(recipients));
        infos.set(map);
    }

    public static void addBcc(Object ... bccs) {
        HashMap<String, Object> map = JapidMailer.getInfoMap();
        ArrayList<Object> bccsList = (ArrayList<Object>)map.get(BCCS);
        if (bccsList == null) {
            bccsList = new ArrayList<Object>();
            map.put(BCCS, bccsList);
        }
        bccsList.addAll(Arrays.asList(bccs));
        infos.set(map);
    }

    public static void addCc(Object ... ccs) {
        HashMap<String, Object> map = JapidMailer.getInfoMap();
        ArrayList<Object> ccsList = (ArrayList<Object>)map.get(CCS);
        if (ccsList == null) {
            ccsList = new ArrayList<Object>();
            map.put(CCS, ccsList);
        }
        ccsList.addAll(Arrays.asList(ccs));
        infos.set(map);
    }

    public static void addAttachment(EmailAttachment ... attachments) {
        HashMap<String, Object> map = JapidMailer.getInfoMap();
        ArrayList<EmailAttachment> attachmentsList = (ArrayList<EmailAttachment>)map.get(ATTACHMENTS);
        if (attachmentsList == null) {
            attachmentsList = new ArrayList<EmailAttachment>();
            map.put(ATTACHMENTS, attachmentsList);
        }
        attachmentsList.addAll(Arrays.asList(attachments));
        infos.set(map);
    }

    public static void setContentType(String contentType) {
        HashMap<String, Object> map = JapidMailer.getInfoMap();
        map.put(CONTENT_TYPE, contentType);
        infos.set(map);
    }

    public static void setFrom(Object from) {
        HashMap<String, Object> map = JapidMailer.getInfoMap();
        map.put(FROM, from);
        infos.set(map);
    }

    public static void setReplyTo(Object replyTo) {
        HashMap<String, Object> map = JapidMailer.getInfoMap();
        map.put(REPLY_TO, replyTo);
        infos.set(map);
    }

    public static void setCharset(String bodyCharset) {
        HashMap<String, Object> map = JapidMailer.getInfoMap();
        map.put(CHARSET, bodyCharset);
        infos.set(map);
    }

    public static void addHeader(String key, String value) {
        HashMap<String, Object> map = JapidMailer.getInfoMap();
        HashMap<String, String> headers = (HashMap<String, String>)map.get(HEADERS);
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put(key, value);
        map.put(HEADERS, headers);
        infos.set(map);
    }

    public static Future<Boolean> send(Object ... args) {
        try {
            List bccsList;
            InternetAddress iAddress;
            HtmlEmail htmlEmail;
            HashMap<String, Object> infoMap = JapidMailer.getInfoMap();
            String charset = (String)infoMap.get(CHARSET);
            Map headers = (Map)infoMap.get(HEADERS);
            String subject = (String)infoMap.get(SUBJECT);
            String templateNameBase = StackTraceUtils.getCaller();
            if (!templateNameBase.startsWith("notifiers")) {
                throw new RuntimeException("The emailers must be put in the \"notifiers\" package.");
            }
            String templateClassName = "japidviews._" + templateNameBase;
            String bodyHtml = null;
            Class tClass = Play.classloader.getClassIgnoreCase(templateClassName);
            if (tClass == null) {
                String templateFileName = templateClassName.replace('.', '/') + ".html";
                throw new RuntimeException("Japid Emailer: could not find a Japid template with the name of: " + templateFileName);
            }
            if (JapidTemplateBase.class.isAssignableFrom(tClass)) {
                try {
                    JapidController.render(tClass, args);
                }
                catch (JapidResult jr) {
                    RenderResult rr = jr.getRenderResult();
                    bodyHtml = rr.getContent().toString();
                }
            } else {
                throw new RuntimeException("The found class is not a Japid template class: " + templateClassName);
            }
            List recipientList = (List)infoMap.get(RECIPIENTS);
            Object from = infoMap.get(FROM);
            Object replyTo = infoMap.get(REPLY_TO);
            HtmlEmail email = null;
            if (infoMap.get(ATTACHMENTS) == null) {
                htmlEmail = new HtmlEmail();
                htmlEmail.setHtmlMsg(bodyHtml);
                email = htmlEmail;
            } else {
                htmlEmail = new HtmlEmail();
                htmlEmail.setHtmlMsg(bodyHtml);
                email = htmlEmail;
                MultiPartEmail multiPartEmail = (MultiPartEmail)email;
                List objectList = (List)infoMap.get(ATTACHMENTS);
                for (EmailAttachment object : objectList) {
                    multiPartEmail.attach(object);
                }
            }
            if (from != null) {
                try {
                    iAddress = new InternetAddress(from.toString());
                    email.setFrom(iAddress.getAddress(), iAddress.getPersonal());
                }
                catch (Exception e) {
                    email.setFrom(from.toString());
                }
            }
            if (replyTo != null) {
                try {
                    iAddress = new InternetAddress(replyTo.toString());
                    email.addReplyTo(iAddress.getAddress(), iAddress.getPersonal());
                }
                catch (Exception e) {
                    email.addReplyTo(replyTo.toString());
                }
            }
            if (recipientList != null) {
                for (Object recipient : recipientList) {
                    try {
                        InternetAddress iAddress2 = new InternetAddress(recipient.toString());
                        email.addTo(iAddress2.getAddress(), iAddress2.getPersonal());
                    }
                    catch (Exception e) {
                        email.addTo(recipient.toString());
                    }
                }
            } else {
                throw new MailException("You must specify at least one recipient.");
            }
            List ccsList = (List)infoMap.get(CCS);
            if (ccsList != null) {
                for (Object cc : ccsList) {
                    email.addCc(cc.toString());
                }
            }
            if ((bccsList = (List)infoMap.get(BCCS)) != null) {
                for (Object bcc : bccsList) {
                    try {
                        InternetAddress iAddress3 = new InternetAddress(bcc.toString());
                        email.addBcc(iAddress3.getAddress(), iAddress3.getPersonal());
                    }
                    catch (Exception e) {
                        email.addBcc(bcc.toString());
                    }
                }
            }
            if (!StringUtils.isEmpty((String)charset)) {
                email.setCharset(charset);
            }
            email.setSubject(subject);
            email.updateContentType(TEXT_HTML);
            if (headers != null) {
                for (String key : headers.keySet()) {
                    email.addHeader(key, (String)headers.get(key));
                }
            }
            infos.remove();
            return Mail.send((Email)email);
        }
        catch (EmailException ex) {
            throw new MailException("Cannot send email", (Throwable)ex);
        }
    }

    public static boolean sendAndWait(Object ... args) {
        try {
            Future<Boolean> result = JapidMailer.send(args);
            return result.get();
        }
        catch (InterruptedException e) {
            Logger.error((Throwable)e, (String)"Error while waiting Mail.send result", (Object[])new Object[0]);
        }
        catch (ExecutionException e) {
            Logger.error((Throwable)e, (String)"Error while waiting Mail.send result", (Object[])new Object[0]);
        }
        return false;
    }
}

