/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.classmeta;

import cn.bran.japid.classmeta.InnerClassMeta;
import cn.bran.japid.compiler.Tag;
import cn.bran.japid.tags.Each;
import cn.bran.japid.template.ActionRunner;
import cn.bran.japid.template.JapidTemplateBaseStreaming;
import cn.bran.japid.template.JapidTemplateBaseWithoutPlay;
import cn.bran.japid.template.RenderResult;
import cn.bran.japid.template.RenderResultPartial;
import japa.parser.ast.body.Parameter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTemplateClassMetaData {
    private static final String PUBLIC = "public ";
    private static final String COMMA = ";";
    private static final String SPACE = " ";
    private static final String STATIC = "static";
    private static final String IMPORT = "import";
    private static Set<String> globalStaticImports = new HashSet<String>();
    private Set<String> staticImports = new HashSet<String>();
    private String originalTemplate;
    private static Pattern partialImport = Pattern.compile("import\\s+\\.(.+)");
    public static boolean streaming = false;
    boolean stopWatch = false;
    public boolean suppressNull = false;
    public boolean useWithPlay = true;
    public StringBuilder sb = new StringBuilder();
    protected static final String SEMI = ";";
    protected static final String TAB = "\t";
    protected static final String RENDER_RESULT = RenderResult.class.getName();
    protected static final String RENDER_RESULT_PARTIAL = RenderResultPartial.class.getName();
    public static final String ACTION_RUNNERS = "actionRunners";
    private static final String IMPORT_SPACE = "import ";
    private static final String CONTENT_TYPE = "Content-Type";
    public String packageName;
    protected String className;
    List<String> statics = new ArrayList<String>();
    List<String> staticsSrc = new ArrayList<String>();
    int staticCounter = 0;
    public String body;
    protected List<InnerClassMeta> innersforTagCalls = new ArrayList<InnerClassMeta>();
    protected List<InnerClassMeta> innersInvokeCalls = new ArrayList<InnerClassMeta>();
    private boolean isAbstract;
    private static Set<String> specialTags = new HashSet<String>();
    public String superClass;
    private static Set<String> globalImports;
    private Set<String> imports = new HashSet<String>();
    static Set<Class<? extends Annotation>> typeAnnotations;
    private boolean trimStaticContent = false;
    protected boolean hasActionInvocation;
    private Map<String, String> headers = new HashMap<String, String>();
    private List<Tag.TagDef> defTags = new ArrayList<Tag.TagDef>();
    public String renderArgs;
    public String superClassRenderArgs = "";

    public String getOriginalTemplate() {
        return this.originalTemplate;
    }

    public void setOriginalTemplate(String originalTemplate) {
        this.originalTemplate = originalTemplate.replace('\\', '/');
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    protected void pln(Object ... ss) {
        for (Object o : ss) {
            this.sb.append(o);
        }
        this.sb.append("\n");
    }

    void p(String s) {
        this.sb.append(s);
    }

    public InnerClassMeta addCallTagBodyInnerClass(String className, int count, String callbackArgs, String body) {
        if (specialTags.contains(className)) {
            return null;
        }
        InnerClassMeta inner = new InnerClassMeta(className, count, callbackArgs, body);
        this.innersforTagCalls.add(inner);
        return inner;
    }

    public void removeLastCallTagBodyInnerClass() {
        this.innersforTagCalls.remove(this.innersforTagCalls.size() - 1);
    }

    public void printHeaders() {
        if (this.packageName != null) {
            this.pln("package " + this.packageName + ";");
        }
        this.pln("import java.util.*;");
        this.pln("import java.io.*;");
        if (streaming) {
            this.pln(IMPORT_SPACE + cn.bran.japid.tags.streaming.Each.class.getName() + ";");
        } else {
            this.pln(IMPORT_SPACE + Each.class.getName() + ";");
        }
        if (this.hasActionInvocation && this.useWithPlay) {
            this.pln(IMPORT_SPACE + ActionRunner.class.getName() + ";");
        }
        for (String l : this.imports) {
            if (!(l = l.trim()).endsWith(";")) {
                l = l + ";";
            }
            if (!l.startsWith(IMPORT)) {
                l = IMPORT_SPACE + l;
            }
            if (!this.considerPlayDependency(l = this.expandPartialImport(l))) continue;
            this.pln(l);
        }
        for (String l : globalStaticImports) {
            if (!(l = l.trim()).startsWith(IMPORT)) {
                l = "import static " + l;
            }
            if (!l.endsWith(".*;")) {
                l = l + ".*;";
            }
            if (!this.considerPlayDependency(l = this.expandPartialImport(l))) continue;
            this.pln(l);
        }
        for (String l : this.staticImports) {
            if (!(l = l.trim()).startsWith(IMPORT)) {
                l = "import static " + l;
            }
            if (!l.endsWith(".*;")) {
                l = l + ".*;";
            }
            if (!this.considerPlayDependency(l = this.expandPartialImport(l))) continue;
            this.pln(l);
        }
        for (String l : globalImports) {
            if (!(l = l.trim()).endsWith(";")) {
                l = l + ";";
            }
            if (!l.startsWith(IMPORT)) {
                l = IMPORT_SPACE + l;
            }
            if (!this.considerPlayDependency(l = this.expandPartialImport(l))) continue;
            this.pln(l);
        }
        this.pln("//");
        this.pln("// NOTE: This file was generated from: " + this.originalTemplate);
        this.pln("// Change to this file will be lost next time the template file is compiled.");
        this.pln("//");
    }

    private boolean considerPlayDependency(String l) {
        if (this.useWithPlay) {
            return true;
        }
        if (l.startsWith(IMPORT)) {
            l = l.substring(IMPORT.length()).trim();
        }
        if (l.startsWith(STATIC)) {
            l = l.substring(STATIC.length()).trim();
        }
        if (l.startsWith("play")) {
            return false;
        }
        return !l.startsWith("cn.bran.play");
    }

    public String expandPartialImport(String l) {
        Matcher matcher = partialImport.matcher(l);
        if (matcher.matches()) {
            l = IMPORT_SPACE + this.packageName + "." + matcher.group(1);
        }
        return l;
    }

    protected void embedSourceTemplateName() {
        this.pln("\tpublic static final String sourceTemplate = \"" + this.originalTemplate + "\";");
    }

    protected void setupTagObjectsAsFields() {
        boolean hasTags;
        boolean bl = hasTags = this.innersforTagCalls.size() > 0;
        if (hasTags) {
            this.pln("\n// -- set up the tag objects");
        }
        for (InnerClassMeta inner : this.innersforTagCalls) {
            String tagClassName = inner.tagName;
            String var = "_" + inner.getVarRoot() + inner.counter;
            if (tagClassName.equals("this")) {
                tagClassName = this.className;
            }
            String decl = "final " + tagClassName + SPACE + var + " = new " + tagClassName + "(getOut());";
            this.pln(decl);
            this.pln(new Object[0]);
        }
        if (hasTags) {
            this.pln("// -- end of the tag objects\n");
        }
    }

    protected void printAnnotations() {
        for (Class<? extends Annotation> anno : typeAnnotations) {
            this.pln("@" + anno.getName());
        }
    }

    public static void addImportLineGlobal(String imp) {
        if ((imp = imp.trim()).startsWith(IMPORT)) {
            imp = imp.substring(IMPORT.length()).trim();
        }
        globalImports.add(imp);
    }

    protected void buildStatics() {
        for (int i = 0; i < this.statics.size(); ++i) {
            if (streaming) {
                this.pln("static private final byte[] static_" + i + " = getBytes(" + this.statics.get(i) + ");");
                continue;
            }
            this.pln("static private final String static_" + i + " = " + this.statics.get(i) + ";");
        }
    }

    protected void addConstructors() {
        if (!streaming) {
            this.pln("\tpublic " + this.className + "() {\n" + "\t\tsuper(null);\n" + "\t}");
        }
        if (streaming) {
            this.pln("\tpublic " + this.className + "(OutputStream out) {");
        } else {
            this.pln("\tpublic " + this.className + "(StringBuilder out) {");
        }
        this.pln("\t\tsuper(out);");
        this.pln("\t}");
    }

    private void classDeclare() {
        if (this.superClass == null) {
            if (this.useWithPlay) {
                this.superClass = "cn.bran.play.JapidTemplateBase";
                if (streaming) {
                    this.superClass = JapidTemplateBaseStreaming.class.getName();
                }
            } else {
                this.superClass = JapidTemplateBaseWithoutPlay.class.getName();
            }
        }
        String abs = this.isAbstract ? "abstract " : "";
        this.pln(PUBLIC + abs + "class " + this.className + " extends " + this.superClass);
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public static void addImportStatic(Class<?> class1) {
        String className = class1.getName();
        globalStaticImports.add(className);
    }

    public static void addImportStaticGlobal(String imp) {
        if (imp.startsWith(IMPORT)) {
            imp = imp.substring(IMPORT.length()).trim();
        }
        if (imp.startsWith(STATIC)) {
            imp = imp.substring(IMPORT.length()).trim();
        }
        globalStaticImports.add(imp);
    }

    public void addImport(Class<?> class1) {
        String className = class1.getName();
        this.addImportLine(className);
    }

    public String addStaticText(String text, String src) {
        if (text != null && !text.isEmpty()) {
            if (this.trimStaticContent && text.trim().length() == 0) {
                return null;
            }
            this.statics.add(text);
            this.staticsSrc.add(src);
            return "static_" + (this.statics.size() - 1);
        }
        return null;
    }

    public static void addAnnotation(Class<? extends Annotation> anno) {
        typeAnnotations.add(anno);
    }

    public void setContentType(String contentType) {
        if (contentType != null) {
            this.headers.put(CONTENT_TYPE, contentType);
        }
    }

    public void turnOnStopwatch() {
        this.stopWatch = true;
    }

    public void suppressNull() {
        this.suppressNull = true;
    }

    public void addStaticImports(String im) {
        this.staticImports.add(im);
    }

    public void addImportLine(String line) {
        this.imports.add(line);
    }

    public void trimStaticContent() {
        this.trimStaticContent = true;
    }

    public boolean getTrimStaticContent() {
        return this.trimStaticContent;
    }

    public void setHasActionInvocation() {
        this.hasActionInvocation = true;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void printHttpHeaderMap() {
        if (this.useWithPlay && this.headers.size() > 0) {
            this.pln("{");
            for (String k : this.headers.keySet()) {
                String v = this.headers.get(k);
                this.pln("putHeader(\"" + k + "\", \"" + v + "\");");
            }
            this.pln("}");
        }
    }

    public void addDefTag(Tag.TagDef tag) {
        this.defTags.add(tag);
    }

    protected void processDefTags() {
        for (Tag.TagDef tag : this.defTags) {
            String meth = tag.args.trim();
            if (meth.endsWith(")")) {
                this.pln("public String " + meth + " {");
            } else {
                this.pln("public String " + meth + "() {");
            }
            this.pln("StringBuilder sb = new StringBuilder();");
            this.pln("StringBuilder ori = getOut();");
            this.pln("this.setOut(sb);");
            if (this.useWithPlay) {
                this.pln("TreeMap<Integer, cn.bran.japid.template.ActionRunner> parentActionRunners = actionRunners;\nactionRunners = new TreeMap<Integer, cn.bran.japid.template.ActionRunner>();");
            }
            for (Tag t : tag.tags) {
                this.declareTagInstance(t);
            }
            this.pln(tag.getBodyText());
            this.pln("this.setOut(ori);");
            if (this.useWithPlay) {
                this.pln("if (actionRunners.size() > 0) {\n\tStringBuilder sb2 = new StringBuilder();\n\tint segStart = 0;\n\tfor (Map.Entry<Integer, cn.bran.japid.template.ActionRunner> arEntry : actionRunners.entrySet()) {\n\t\tint pos = arEntry.getKey();\n\t\tsb2.append(sb.substring(segStart, pos));\n\t\tsegStart = pos;\n\t\tcn.bran.japid.template.ActionRunner a = arEntry.getValue();\n\t\tsb2.append(a.run().getContent().toString());\n\t}\n\tsb2.append(sb.substring(segStart));\n\tactionRunners = parentActionRunners;\n\treturn sb2.toString();\n} else {\n\tactionRunners = parentActionRunners;\n\treturn sb.toString();\n}");
            } else {
                this.pln("\treturn sb.toString();");
            }
            this.pln("}");
        }
    }

    protected void declareTagInstance(Tag t) {
        String tagClassName = t.tagName;
        String var = t.getTagVarName();
        if (tagClassName.equals("this")) {
            tagClassName = this.getClassName();
        }
        String decl = "final " + tagClassName + SPACE + var + " = new " + tagClassName + "(getOut());";
        this.pln(decl);
        this.pln(new Object[0]);
    }

    protected void addImplicitFields() {
        if (this.useWithPlay) {
            this.pln("\n// - add implicit fields with Play\n");
            this.pln("\tfinal Request request = Request.current(); \n\tfinal Response response = Response.current(); \n\tfinal Session session = Session.current();\n\tfinal RenderArgs renderArgs = RenderArgs.current();\n\tfinal Params params = Params.current();\n\tfinal Validation validation = Validation.current();\n\tfinal cn.bran.play.FieldErrors errors = new cn.bran.play.FieldErrors(validation);\n\tfinal play.Play _play = new play.Play(); \n");
            this.pln("// - end of implicit fields with Play \n\n");
        }
    }

    public String removeLastSingleEmptyLine() {
        char[] charArray;
        int last = this.staticsSrc.size() - 1;
        String s = this.staticsSrc.get(last);
        for (char c : charArray = s.toCharArray()) {
            if (Character.isSpaceChar(c)) continue;
            return null;
        }
        if (s.contains("\n")) {
            if (s.indexOf(10) == s.lastIndexOf(10)) {
                this.statics.remove(last);
                this.staticsSrc.remove(last);
                return s;
            }
            return null;
        }
        this.statics.remove(last);
        this.staticsSrc.remove(last);
        return s;
    }

    public String generateCode() {
        this.printHeaders();
        this.printAnnotations();
        this.classDeclare();
        this.p("{");
        this.embedSourceTemplateName();
        this.printHttpHeaderMap();
        if (this.useWithPlay) {
            this.addImplicitFields();
        }
        this.addConstructors();
        this.renderMethod();
        this.layoutMethod();
        this.getterSetter();
        this.childLayout();
        this.processDefTags();
        this.p("}");
        return this.sb.toString();
    }

    abstract void renderMethod();

    abstract void layoutMethod();

    abstract void getterSetter();

    abstract void childLayout();

    public String toString() {
        return this.generateCode();
    }

    protected void addField(Parameter p) {
        String defaultVal = "=";
        this.pln("\tprivate " + p.getType() + SPACE + p.getId() + (defaultVal.equals("=") ? "" : defaultVal) + ";");
    }

    public static void clearImports() {
        globalImports.clear();
        globalStaticImports.clear();
    }

    static {
        specialTags.add("set");
        specialTags.add("get");
        specialTags.add("invoke");
        specialTags.add("doBody");
        specialTags.add("doLayout");
        specialTags.add("extends");
        globalImports = new HashSet<String>();
        typeAnnotations = new HashSet<Class<? extends Annotation>>();
    }
}

