/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import cn.bran.japid.classmeta.AbstractTemplateClassMetaData;
import cn.bran.japid.classmeta.TemplateClassMetaData;
import cn.bran.japid.compiler.JapidAbstractCompiler;
import cn.bran.japid.compiler.JapidCompilationException;
import cn.bran.japid.compiler.JavaSyntaxTool;
import cn.bran.japid.compiler.Tag;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JapidTemplateCompiler
extends JapidAbstractCompiler {
    private static final String DO_BODY = "doBody";
    TemplateClassMetaData tcmd = new TemplateClassMetaData();
    static Pattern setPattern = Pattern.compile("(\\w+)\\s+(.*)");
    static Pattern SET_ARG_PATTERN_ONELINER_COLON = Pattern.compile("\\w+\\s*:.*");
    static Pattern SET_ARG_PATTERN_ONELINER_EQUAL = Pattern.compile("\\w+\\s*=.*");
    static Pattern SET_ARG_PATTERN_ONELINER = Pattern.compile("\\w+\\s*[:=].*");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void startTag(Tag tag) {
        if (tag.tagName.equals(DO_BODY)) {
            String[] argPartsAndVar = JavaSyntaxTool.breakArgParts(tag.args);
            if (argPartsAndVar.length == 1) {
                this.tcmd.doBody(tag.args);
                this.print("if (body != null){ body.setBuffer(getOut()); body.render(" + tag.args + "); body.resetBuffer();}");
            } else {
                String args = argPartsAndVar[0];
                this.tcmd.doBody(args);
                String localVar = argPartsAndVar[1];
                this.print("String " + localVar + " = renderBody(" + args + ");");
            }
        } else if ("set".equals(tag.tagName)) {
            if (SET_ARG_PATTERN_ONELINER.matcher(tag.args).matches()) {
                if (tag.hasBody) {
                    throw new JapidCompilationException(this.template, this.parser.getLineNumber(), "set tag cannot have value both in tag and in body: " + tag + " " + tag.args);
                }
                int i = 0;
                i = SET_ARG_PATTERN_ONELINER_COLON.matcher(tag.args).matches() ? tag.args.indexOf(":") : tag.args.indexOf("=");
                String key = tag.args.substring(0, i).trim().replace("\"", "").replace("'", "");
                String value = tag.args.substring(i + 1);
                if (!JavaSyntaxTool.isValidExpr(value)) throw new JapidCompilationException(this.template, this.parser.getLineNumber(), "The value part in the set tag is not a valid expression: " + value + ". " + "The grammar is: set var_name = java_expression.");
                this.tcmd.addSetTag(key, "p(" + value + ");", (Tag.TagSet)tag);
            } else {
                Matcher matcher = setPattern.matcher(tag.args);
                if (matcher.matches()) {
                    tag.hasBody = false;
                    String key = matcher.group(1);
                    String value = matcher.group(2);
                    this.tcmd.addSetTag(key, "p(" + value + ");", (Tag.TagSet)tag);
                }
            }
        } else if (tag.tagName.equals("def")) {
            this.def(tag);
        } else {
            this.regularTagInvoke(tag);
        }
        this.pushToStack(tag);
        this.markLine();
        this.println();
        this.skipLineBreak = true;
    }

    protected AbstractTemplateClassMetaData getTemplateClassMetaData() {
        return this.tcmd;
    }

    protected void scriptline(String token) {
        String line = token;
        if (JapidAbstractCompiler.startsWithIgnoreSpace(line.trim(), DO_BODY) || line.trim().equals(DO_BODY)) {
            String args = line.trim().substring(DO_BODY.length()).trim();
            String[] argPartsAndVar = JavaSyntaxTool.breakArgParts(args);
            if (argPartsAndVar.length == 1) {
                this.tcmd.doBody(args);
                this.printLine("if (body != null){ body.setBuffer(getOut()); body.render(" + args + "); body.resetBuffer();}");
            } else {
                args = argPartsAndVar[0];
                this.tcmd.doBody(args);
                String localVar = argPartsAndVar[1];
                this.printLine("String " + localVar + " = renderBody(" + args + ");");
            }
            this.skipLineBreak = true;
        } else {
            super.scriptline(token);
        }
    }

    void endSet(Tag.TagSet tag) {
        if (tag.hasBody) {
            String key = tag.args.replace("\"", "").replace("'", "");
            this.tcmd.addSetTag(key, tag.getBodyText(), tag);
        }
    }
}

