/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import cn.bran.japid.classmeta.AbstractTemplateClassMetaData;
import cn.bran.japid.compiler.JapidCompilationException;
import cn.bran.japid.compiler.JapidTemplateTransformer;
import cn.bran.japid.util.DirUtil;
import cn.bran.japid.util.JapidFlags;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslateTemplateTask {
    private List<Class<?>> staticImports = new ArrayList();
    private List<String> imports = new ArrayList<String>();
    private List<File> changedFiles;
    private List<File> changedTargetFiles = new LinkedList<File>();
    private boolean usePlay = true;
    private File destDir = null;
    private File packageRoot = null;
    private boolean listFiles = false;
    List<Class<? extends Annotation>> typeAnnotations = new ArrayList<Class<? extends Annotation>>();
    private File include;

    public List<File> getChangedTargetFiles() {
        return this.changedTargetFiles;
    }

    public boolean isUsePlay() {
        return this.usePlay;
    }

    public void setUsePlay(boolean usePlay) {
        this.usePlay = usePlay;
    }

    public List<File> getChangedFiles() {
        return this.changedFiles;
    }

    public void setDestdir(File p_destDir) {
        this.destDir = p_destDir;
    }

    public void setPackageRoot(File p_srcDir) {
        this.packageRoot = p_srcDir;
    }

    public void setListFiles(boolean p_listFiles) {
        this.listFiles = p_listFiles;
    }

    public void execute() {
        if (this.packageRoot == null) {
            throw new RuntimeException("srcdir attribute must be set!");
        }
        if (this.destDir == null) {
            this.destDir = this.packageRoot;
        }
        if (!this.packageRoot.exists() && !this.packageRoot.isDirectory()) {
            throw new RuntimeException("source directory \"" + this.packageRoot + "\" does not exist or is not a directory");
        }
        this.destDir.mkdirs();
        if (!this.destDir.exists() || !this.destDir.isDirectory()) {
            throw new RuntimeException("destination directory \"" + this.destDir + "\" does not exist or is not a directory");
        }
        if (!this.packageRoot.exists()) {
            throw new RuntimeException("srcdir \"" + this.packageRoot + "\" does not exist!");
        }
        this.changedFiles = DirUtil.findChangedSrcFiles(this.include);
        if (this.changedFiles.size() > 0) {
            if (JapidFlags.verbose) {
                System.out.println("[Japid] Processing " + this.changedFiles.size() + " template" + (this.changedFiles.size() == 1 ? "" : "s") + " in directory tree: " + this.destDir);
            }
            JapidTemplateTransformer tran = new JapidTemplateTransformer(this.packageRoot.getPath(), null);
            tran.usePlay(this.usePlay);
            for (Class<?> clazz : this.staticImports) {
                tran.addImportStatic(clazz);
            }
            for (String string : this.imports) {
                tran.addImportLine(string);
            }
            for (Class clazz : this.typeAnnotations) {
                tran.addAnnotation(clazz);
            }
            for (int i = 0; i < this.changedFiles.size(); ++i) {
                File file = this.changedFiles.get(i);
                if (JapidFlags.verbose) {
                    System.out.println("[Japid] Transforming template: " + file.getPath() + " to: " + DirUtil.mapSrcToJava(file.getName()));
                }
                if (JapidFlags.verbose && this.listFiles) {
                    System.out.println(file.getAbsolutePath());
                }
                try {
                    String relativePath = JapidTemplateTransformer.getRelativePath(file, this.packageRoot);
                    File generate = tran.generate(relativePath);
                    this.changedTargetFiles.add(generate);
                    continue;
                }
                catch (JapidCompilationException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getClass().getName() + ":" + e.getMessage());
                }
            }
        }
    }

    public void importStatic(Class<?> clz) {
        this.staticImports.add(clz);
    }

    public void addImport(String imp) {
        this.imports.add(imp);
    }

    public void addImport(Class<?> clz) {
        this.imports.add(clz.getName());
    }

    public void addAnnotation(Class<? extends Annotation> anno) {
        this.typeAnnotations.add(anno);
    }

    public void setUseStreaming(boolean streaming) {
        AbstractTemplateClassMetaData.streaming = streaming;
    }

    public void setInclude(File file) {
        this.include = file;
    }

    public void clearImports() {
        this.staticImports.clear();
        this.imports.clear();
        AbstractTemplateClassMetaData.clearImports();
    }
}

