/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.util.UrlMapper;
import cn.bran.play.ActionBridge;
import java.util.HashMap;
import play.Play;
import play.mvc.Http;
import play.mvc.Router;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteAdapter
implements UrlMapper {
    static ThreadLocal<HashMap<String, String>> staticCache = new ThreadLocal();
    static ThreadLocal<HashMap<String, String>> actionReverseCache = new ThreadLocal();
    static ThreadLocal<HashMap<String, String[]>> actionParamNamesCache = new ThreadLocal();

    public String lookup(String actionString, Object[] params) {
        Router.ActionDefinition ad = this.lookupActionDefinition(actionString, params);
        return ad.toString();
    }

    public Router.ActionDefinition lookupActionDefinition(String actionString, Object[] params) {
        Router.ActionDefinition ad = new ActionBridge(false).invokeMethod(actionString, params);
        return ad;
    }

    public String lookupAbs(String action, Object[] args) {
        return Http.Request.current().getBase() + this.lookup(action, args);
    }

    public String lookupStatic(String resource, boolean isAbs) {
        return RouteAdapter.reverseStaticLookup(resource, isAbs);
    }

    public String lookupStaticAbs(String resource) {
        return this.lookupStatic(resource, true);
    }

    private static HashMap<String, String> getActionCache() {
        HashMap hash = (HashMap)Http.Request.current().args.get("actionReverseCache");
        if (hash == null) {
            hash = new HashMap();
            Http.Request.current().args.put("actionReverseCache", hash);
        }
        return hash;
    }

    private static HashMap<String, String[]> getActionParamCache() {
        HashMap hash = (HashMap)Http.Request.current().args.get("actionParamNamesCache");
        if (hash == null) {
            hash = new HashMap();
            Http.Request.current().args.put("actionParamNamesCache", hash);
        }
        return hash;
    }

    public static String reverseStaticLookup(String resource, boolean isAbs) {
        try {
            HashMap<String, String> hash = RouteAdapter.getStaticCache();
            String url = hash.get(resource);
            if (url == null) {
                url = Router.reverseWithCheck((String)resource, (VirtualFile)Play.getVirtualFile((String)resource), (boolean)isAbs);
                hash.put(resource, url);
            }
            return url;
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e + ". No matching route in reverse lookup: " + resource);
        }
    }

    private static HashMap<String, String> getStaticCache() {
        HashMap<String, String> hash = staticCache.get();
        if (hash == null) {
            hash = new HashMap();
            staticCache.set(hash);
        }
        return hash;
    }

    public String lookupStatic(String resource) {
        return this.lookupStatic(resource, false);
    }
}

