/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.util;

import cn.bran.japid.util.WebUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    static CharsetEncoder ce;

    public static ByteBuffer encodeUTF8(String src) {
        int len = src.length();
        int off = 0;
        int en = (int)((float)len * ce.maxBytesPerChar());
        byte[] ba = new byte[en];
        if (len == 0) {
            return null;
        }
        ce.reset();
        ByteBuffer bb = ByteBuffer.wrap(ba);
        CharBuffer cb = CharBuffer.wrap(src, off, len);
        try {
            CoderResult cr = ce.encode(cb, bb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = ce.flush(bb)).isUnderflow()) {
                cr.throwException();
            }
            return bb;
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
    }

    public static String buildQuery(Map<String, Object> paramMap) {
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (List.class.isAssignableFrom(value.getClass())) {
                List vals = (List)value;
                for (Object e : vals) {
                    try {
                        queryString.append(URLEncoder.encode(key, "utf-8"));
                        queryString.append("=");
                        if (e.toString().startsWith(":")) {
                            queryString.append(e.toString() + "");
                        } else {
                            queryString.append(URLEncoder.encode(e.toString() + "", "utf-8"));
                        }
                        queryString.append("&");
                    }
                    catch (UnsupportedEncodingException ex) {}
                }
                continue;
            }
            try {
                queryString.append(URLEncoder.encode(key, "utf-8"));
                queryString.append("=");
                if (value.toString().startsWith(":")) {
                    queryString.append(value.toString() + "");
                } else {
                    queryString.append(URLEncoder.encode(value.toString() + "", "utf-8"));
                }
                queryString.append("&");
            }
            catch (UnsupportedEncodingException ex) {
            }
        }
        String qs = queryString.toString();
        if (qs.endsWith("&")) {
            qs = qs.substring(0, qs.length() - 1);
        }
        return qs;
    }

    public static boolean isEmpty(String charset) {
        return !WebUtils.asBoolean(charset);
    }

    public static <T> String join(Iterable<T> values, String separator) {
        if (values == null) {
            return "";
        }
        Iterator<T> iter = values.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuffer toReturn = new StringBuffer(String.valueOf(iter.next()));
        while (iter.hasNext()) {
            toReturn.append(separator + String.valueOf(iter.next()));
        }
        return toReturn.toString();
    }

    public static String join(String[] values, String separator) {
        return values == null ? "" : StringUtils.join(Arrays.asList(values), separator);
    }

    static {
        Charset cs = Charset.forName("UTF-8");
        ce = cs.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }
}

