/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import cn.bran.japid.compiler.JavaSyntaxTool;
import cn.bran.japid.compiler.NamedArg;
import cn.bran.japid.compiler.Tag;
import cn.bran.japid.util.StringUtils;
import java.util.List;

public class TagInvocationLineParser {
    public Tag parse(String line) {
        Tag tag = new Tag();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '/') continue;
            if (Character.isWhitespace(c) || c == '(' || c == '|') {
                tag.tagName = line.substring(0, i).replace('/', '.');
                if (tag.tagName.startsWith("..")) {
                    tag.tagName = tag.tagName.substring(1);
                }
                line = line.substring(i).trim();
                break;
            }
            throw new RuntimeException("invalid character in the tag invocation line " + line + ": [" + c + "]");
        }
        if (tag.tagName == null) {
            tag.tagName = line.replace('/', '.');
            return tag;
        }
        if (tag.tagName.equals("def")) {
            tag = new Tag.TagDef();
            if (!line.endsWith(")")) {
                line = line + "()";
            }
            JavaSyntaxTool.isValidMethDecl(line);
            tag.args = line;
            return tag;
        }
        if (tag.tagName.equals("set")) {
            tag = new Tag.TagSet();
            tag.args = line;
            return tag;
        }
        if (tag.tagName.equals("get")) {
            tag.args = line;
            return tag;
        }
        try {
            List<String> args = JavaSyntaxTool.parseArgs(line);
            tag.args = StringUtils.join(args, ",");
            this.parseNamedArgs(tag);
        }
        catch (RuntimeException e) {
            int vertline = line.lastIndexOf(124);
            if (vertline >= 0) {
                String closureArgs = line.substring(vertline + 1).trim();
                JavaSyntaxTool.parseParams(closureArgs);
                tag.callbackArgs = closureArgs;
                tag.hasBody = true;
                line = line.substring(0, vertline).trim();
                if (line.length() == 0) {
                    return tag;
                }
                char firstC = line.charAt(0);
                char lastC = line.charAt(line.length() - 1);
                if ('(' == firstC) {
                    if (')' != lastC) {
                        throw new RuntimeException("The tag argument part is not valid: parenthesis is not paired.");
                    }
                    tag.args = line.substring(1, line.length() - 1);
                } else {
                    tag.args = line;
                }
                this.parseNamedArgs(tag);
            }
            throw new RuntimeException("tag args not valid: " + line);
        }
        if (("Each".equals(tag.tagName) || "each".equals(tag.tagName)) && !tag.hasBody) {
            throw new RuntimeException("The Each tag must have a body. Invalid statement: " + line);
        }
        return tag;
    }

    private void parseNamedArgs(Tag tag) {
        List<NamedArg> args = JavaSyntaxTool.parseNamedArgs(tag.args);
        if (args.size() > 0) {
            tag.namedArgs = args;
            String ar = "";
            for (NamedArg na : args) {
                ar = ar + na.toNamed() + ", ";
            }
            if (ar.endsWith(", ")) {
                ar = ar.substring(0, ar.length() - 2);
            }
            tag.args = ar;
        }
    }
}

