/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.template;

import cn.bran.japid.compiler.OpMode;
import cn.bran.japid.compiler.TranslateTemplateTask;
import cn.bran.japid.rendererloader.RendererClass;
import cn.bran.japid.rendererloader.RendererCompiler;
import cn.bran.japid.rendererloader.TemplateClassLoader;
import cn.bran.japid.template.JapidPlainController;
import cn.bran.japid.template.JapidTemplateBaseWithoutPlay;
import cn.bran.japid.util.DirUtil;
import cn.bran.japid.util.JapidFlags;
import cn.bran.japid.util.StackTraceUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidRenderer {
    public static final Map<String, RendererClass> classes = new ConcurrentHashMap<String, RendererClass>();
    public static TemplateClassLoader crlr;
    public static RendererCompiler compiler;
    public static String templateRoot;
    public static final String JAPIDVIEWS = "japidviews";
    public static String sep;
    public static String japidviews;
    public static List<String> importlines;
    public static int refreshInterval;
    public static long lastRefreshed;
    private static boolean inited;
    private static OpMode opMode;
    private static ClassLoader _parentClassLoader;

    public static JapidTemplateBaseWithoutPlay getRenderer(String name) {
        Class<? extends JapidTemplateBaseWithoutPlay> c = JapidRenderer.getClass(name);
        try {
            return c.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<? extends JapidTemplateBaseWithoutPlay> getClass(String name) {
        JapidRenderer.refreshClasses(name);
        RendererClass rc = classes.get(name);
        if (rc == null) {
            throw new RuntimeException("renderer class not found: " + name);
        }
        try {
            Class<? extends JapidTemplateBaseWithoutPlay> cls = rc.getClz();
            if (cls != null) {
                return cls;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (String c : classes.keySet()) {
            RendererClass rendererClass = classes.get(c);
            rendererClass.setLastUpdated(0L);
        }
        ClassLoader cl = _parentClassLoader == null ? JapidRenderer.class.getClassLoader() : _parentClassLoader;
        TemplateClassLoader classReloader = new TemplateClassLoader(cl);
        try {
            Class<?> loadClass = classReloader.loadClass(name);
            rc.setClz(loadClass);
            return loadClass;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean timeToRefresh() {
        long now = System.currentTimeMillis();
        if (now - lastRefreshed > (long)refreshInterval) {
            lastRefreshed = now;
            return true;
        }
        return false;
    }

    static synchronized void refreshClasses(String targetClass) {
        if (!JapidRenderer.timeToRefresh()) {
            return;
        }
        try {
            String[] allHtml = DirUtil.getAllTemplateHtmlFiles(new File(templateRoot));
            Set<String> currentClassesOnDir = JapidRenderer.createNameSet(allHtml);
            HashSet<String> tmp = new HashSet<String>(currentClassesOnDir);
            Set<String> keySet = classes.keySet();
            tmp.removeAll(keySet);
            JapidRenderer.removeRemoved(currentClassesOnDir, keySet);
            for (String c : tmp) {
                RendererClass rc = JapidRenderer.newRendererClass(c);
                classes.put(c, rc);
            }
            List<File> gen = JapidRenderer.gen(templateRoot);
            HashSet<String> updatedClasses = new HashSet<String>();
            if (gen.size() > 0) {
                for (File f : gen) {
                    String className = JapidRenderer.getClassName(f);
                    updatedClasses.add(className);
                    RendererClass rendererClass = classes.get(className);
                    if (rendererClass == null) {
                        throw new RuntimeException("any new key should have been in the classes container: " + className);
                    }
                    rendererClass.setSourceCode(JapidRenderer.readSource(f));
                    JapidRenderer.removeInnerClasses(className);
                    JapidRenderer.cleanClassHolder(rendererClass);
                }
            }
            for (String k : classes.keySet()) {
                RendererClass rc = classes.get(k);
                if (rc.getSourceCode() == null) {
                    if (!rc.getClassName().contains("$")) {
                        rc.setSourceCode(JapidRenderer.getSourceCode(k));
                        JapidRenderer.cleanClassHolder(rc);
                        updatedClasses.add(k);
                        continue;
                    }
                    rc.setLastUpdated(0L);
                    continue;
                }
                if (rc.getBytecode() != null) continue;
                JapidRenderer.cleanClassHolder(rc);
                updatedClasses.add(k);
            }
            if (updatedClasses.size() > 0) {
                String[] names = new String[updatedClasses.size()];
                int i = 0;
                for (String s : updatedClasses) {
                    names[i++] = s;
                }
                long t = System.currentTimeMillis();
                compiler.compile(names);
                JapidRenderer.howlong("compile time for " + names.length + " classes", t);
                for (String k : classes.keySet()) {
                    RendererClass rc = classes.get(k);
                    rc.setClz(null);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeInnerClasses(String className) {
        Iterator<String> i = classes.keySet().iterator();
        while (i.hasNext()) {
            String k = i.next();
            if (!k.startsWith(className + "$")) continue;
            i.remove();
        }
    }

    public static void removeRemoved(Set<String> currentClassesOnDir, Set<String> keySet) {
        Iterator<String> i = keySet.iterator();
        while (i.hasNext()) {
            String k = i.next();
            int q = k.indexOf(36);
            if (q > 0) {
                k = k.substring(0, q);
            }
            if (currentClassesOnDir.contains(k)) continue;
            i.remove();
        }
    }

    public static TemplateClassLoader getCrlr() {
        return crlr;
    }

    public static boolean isInited() {
        return inited;
    }

    public static OpMode getOpMode() {
        return opMode;
    }

    static void howlong(String string, long t) {
        if (JapidFlags.verbose) {
            System.out.println(string + ":" + (System.currentTimeMillis() - t) + "ms");
        }
    }

    static void cleanClassHolder(RendererClass rendererClass) {
        rendererClass.setBytecode(null);
        rendererClass.setClz(null);
        rendererClass.setLastUpdated(0L);
    }

    static Set<String> createNameSet(String[] allHtml) {
        HashSet<String> names = new HashSet<String>();
        for (String f : allHtml) {
            names.add(JapidRenderer.getClassName(new File(f)));
        }
        return names;
    }

    static String getSourceCode(String k) {
        String pathname = templateRoot + sep + k;
        pathname = pathname.replace(".", sep);
        File f = new File(pathname + ".java");
        return JapidRenderer.readSource(f);
    }

    static RendererClass newRendererClass(String c) {
        RendererClass rc = new RendererClass();
        rc.setClassName(c);
        rc.setLastUpdated(0L);
        return rc;
    }

    static String readSource(File f) {
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedInputStream bis = new BufferedInputStream(fis);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)bis, "UTF-8"));
            StringBuilder b = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                b.append(line + "\n");
            }
            br.close();
            return b.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String getClassName(File f) {
        String path = f.getPath();
        String substring = path.substring(path.indexOf(JAPIDVIEWS));
        if ((substring = substring.replace('/', '.').replace('\\', '.')).endsWith(".java")) {
            substring = substring.substring(0, substring.length() - 5);
        } else if (substring.endsWith(".html")) {
            substring = substring.substring(0, substring.length() - 5);
        }
        return substring;
    }

    static void setRefreshInterval(int i) {
        refreshInterval = i * 1000;
    }

    static void setTemplateRoot(String root) {
        templateRoot = root;
        japidviews = templateRoot + sep + JAPIDVIEWS + sep;
    }

    public static void main(String[] args) throws IOException {
        if (args.length > 0) {
            String arg0 = args[0];
            JapidRenderer.setTemplateRoot(".");
            if ("gen".equals(arg0)) {
                JapidRenderer.gen(templateRoot);
            } else if ("regen".equals(arg0)) {
                JapidRenderer.regen(templateRoot);
            } else if ("clean".equals(arg0)) {
                JapidRenderer.delAllGeneratedJava(JapidRenderer.getJapidviewsDir(templateRoot));
            } else if ("mkdir".equals(arg0)) {
                JapidRenderer.mkdir(templateRoot);
            } else if ("changed".equals(arg0)) {
                JapidRenderer.changed(japidviews);
            } else {
                System.err.println("help:  optionas are: gen, regen, mkdir and clean");
            }
        } else {
            System.err.println("help:  optionas are: gen, regen, mkdir and clean");
        }
    }

    private static void changed(String root) {
        List<File> changedFiles = DirUtil.findChangedSrcFiles(new File(root));
        for (File f : changedFiles) {
            System.out.println("changed: " + f.getPath());
        }
    }

    static List<File> mkdir(String root) throws IOException {
        File tags;
        String japidviewsDir = JapidRenderer.getJapidviewsDir(root);
        File layouts = new File(japidviewsDir + "_layouts");
        if (!layouts.exists()) {
            boolean mkdirs = layouts.mkdirs();
            assert (mkdirs);
            JapidRenderer.log("created: " + layouts.getPath());
        }
        if (!(tags = new File(japidviewsDir + "_tags")).exists()) {
            boolean mkdirs = tags.mkdirs();
            assert (mkdirs);
            JapidRenderer.log("created: " + tags.getPath());
        }
        File[] dirs = new File[]{layouts, tags};
        ArrayList<File> res = new ArrayList<File>();
        res.addAll(Arrays.asList(dirs));
        return res;
    }

    private static String getJapidviewsDir(String root) {
        return root + sep + JAPIDVIEWS + sep;
    }

    static void regen() throws IOException {
        JapidRenderer.regen(templateRoot);
    }

    public static void regen(String root) throws IOException {
        JapidRenderer.delAllGeneratedJava(JapidRenderer.getJapidviewsDir(root));
        JapidRenderer.gen(root);
    }

    static void delAllGeneratedJava(String pathname) {
        String[] javas;
        for (String j : javas = DirUtil.getAllFileNames(new File(pathname), new String[]{"java"})) {
            JapidRenderer.log("removed: " + pathname + j);
            boolean delete = new File(pathname + File.separatorChar + j).delete();
            if (delete) continue;
            throw new RuntimeException("file was not deleted: " + j);
        }
    }

    static List<File> gen(String packageRoot) throws IOException {
        List<File> changedFiles = JapidRenderer.reloadChanged(packageRoot);
        if (changedFiles.size() <= 0) {
            JapidRenderer.log("All java files are up to date.");
        }
        JapidRenderer.rmOrphanJava(packageRoot);
        return changedFiles;
    }

    static List<File> reloadChanged(String root) {
        try {
            JapidRenderer.mkdir(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        TranslateTemplateTask t = new TranslateTemplateTask();
        t.setUsePlay(false);
        File rootDir = new File(root);
        t.setPackageRoot(rootDir);
        t.setInclude(new File(japidviews));
        if (DirUtil.hasLayouts(root)) {
            t.addImport("japidviews ._layouts.*");
        }
        if (DirUtil.hasJavaTags(root)) {
            t.addImport(root + "/" + "._javatags.*");
        }
        if (DirUtil.hasTags(root)) {
            t.addImport("japidviews ._tags.*");
        }
        for (String imp : importlines) {
            t.addImport(imp);
        }
        t.execute();
        return t.getChangedTargetFiles();
    }

    static File[] getAllJavaFilesInDir(String root) {
        String[] allFiles = DirUtil.getAllFileNames(new File(root), new String[]{".java"});
        File[] fs = new File[allFiles.length];
        int i = 0;
        for (String f : allFiles) {
            String path = f.replace(".java", "");
            fs[i++] = new File(path);
        }
        return fs;
    }

    static boolean rmOrphanJava(String packageRoot) {
        boolean hasRealOrphan = false;
        try {
            String pathname = JapidRenderer.getJapidviewsDir(packageRoot);
            File src = new File(pathname);
            if (!src.exists()) {
                JapidRenderer.log("Could not find required Japid root directory: " + pathname);
                return hasRealOrphan;
            }
            Set<File> oj = DirUtil.findOrphanJava(src, null);
            for (File j : oj) {
                String path = j.getPath();
                hasRealOrphan = true;
                String realfile = pathname + File.separator + path;
                File file = new File(realfile);
                boolean r = file.delete();
                if (r) {
                    JapidRenderer.log("deleted orphan " + realfile);
                    continue;
                }
                JapidRenderer.log("failed to delete: " + realfile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasRealOrphan;
    }

    static List<File> reloadChanged() {
        return JapidRenderer.reloadChanged(templateRoot);
    }

    static void log(String m) {
        if (JapidFlags.verbose) {
            System.out.println("[JapidRender]: " + m);
        }
    }

    static void gen() {
        if (templateRoot == null) {
            throw new RuntimeException("the template root directory must be set");
        }
        try {
            JapidRenderer.gen(templateRoot);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isDevMode() {
        return opMode == OpMode.dev;
    }

    static String removeSemi(String imp) {
        if ((imp = imp.trim()).endsWith(";")) {
            imp = imp.substring(0, imp.length() - 1);
        }
        return imp;
    }

    public static void addStaticImportLine(String imp) {
        importlines.add(" static " + JapidRenderer.removeSemi(imp));
    }

    public static void addImportLine(String imp) {
        importlines.add(JapidRenderer.removeSemi(imp));
    }

    public String render(Class<? extends JapidTemplateBaseWithoutPlay> cls, Object ... args) {
        return JapidPlainController.renderWith(cls, args);
    }

    public static void init(OpMode opMode, String templateRoot, int refreshInterval, ClassLoader parentClassLoader) {
        inited = true;
        JapidRenderer.opMode = opMode;
        JapidRenderer.setTemplateRoot(templateRoot);
        JapidRenderer.setRefreshInterval(refreshInterval);
        _parentClassLoader = parentClassLoader;
        if (_parentClassLoader == null) {
            _parentClassLoader = JapidRenderer.class.getClassLoader();
        }
        crlr = new TemplateClassLoader(parentClassLoader);
        compiler = new RendererCompiler(classes, crlr);
    }

    public static String render(Object ... args) {
        String templateName = JapidRenderer.findTemplate();
        return JapidPlainController.renderJapidWith(templateName, args);
    }

    public static String renderWith(String templateName, Object ... args) {
        return JapidPlainController.renderJapidWith(templateName, args);
    }

    private static String findTemplate() {
        String japidRenderInvoker = StackTraceUtils.getJapidRenderInvoker();
        return japidRenderInvoker;
    }

    public static String renderWith(Class<? extends JapidTemplateBaseWithoutPlay> cla, Object ... args) {
        return JapidPlainController.renderWith(cla, args);
    }

    static {
        templateRoot = "plainjapid";
        sep = File.separator;
        japidviews = templateRoot + sep + JAPIDVIEWS + sep;
        importlines = new ArrayList<String>();
        _parentClassLoader = null;
    }
}

