/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirUtil {
    public static Set<File> findOrphanJava(File src, File target) {
        if (target == null) {
            target = src;
        }
        String[] allSrc = DirUtil.getAllFileNames(src, new String[]{".java", ".html", ".txt", ".json", ".xml"});
        HashSet<String> javas = new HashSet<String>();
        HashSet<String> srcFiles = new HashSet<String>();
        for (String s : allSrc) {
            if (s.endsWith(".java")) {
                javas.add(s);
                continue;
            }
            srcFiles.add(DirUtil.mapSrcToJava(s));
        }
        javas.removeAll(srcFiles);
        HashSet<File> re = new HashSet<File>();
        for (String j : javas) {
            re.add(new File(j));
        }
        return re;
    }

    public static String[] getAllFileNames(File dir, String[] exts) {
        ArrayList<String> files = new ArrayList<String>();
        DirUtil.getAllFileNames("", dir, files, exts);
        String[] ret = new String[files.size()];
        return files.toArray(ret);
    }

    public static String[] getAllTemplateHtmlFiles(File dir) {
        ArrayList<String> files = new ArrayList<String>();
        DirUtil.getAllFileNames("", dir, files, new String[]{".html"});
        String[] ret = new String[files.size()];
        return files.toArray(ret);
    }

    public static Set<File> getAllFiles(File dir, String[] exts, Set<File> fs) {
        Set<File> scanFiles = DirUtil.scanFiles(dir, exts, fs);
        return scanFiles;
    }

    private static Set<File> scanFiles(File dir, String[] exts, Set<File> fs) {
        File[] flist;
        for (File f : flist = dir.listFiles()) {
            if (f.isDirectory()) {
                DirUtil.getAllFiles(f, exts, fs);
                continue;
            }
            if (!DirUtil.match(f, exts)) continue;
            fs.add(f);
        }
        return fs;
    }

    private static void getAllFileNames(String leadingPath, File dir, List<String> files, String[] exts) {
        File[] flist = dir.listFiles();
        if (flist == null) {
            throw new RuntimeException("directory exists? " + dir.getPath());
        }
        for (File f : flist) {
            if (f.isDirectory()) {
                DirUtil.getAllFileNames(leadingPath + f.getName() + File.separatorChar, f, files, exts);
                continue;
            }
            if (!DirUtil.match(f, exts)) continue;
            files.add(leadingPath + f.getName());
        }
    }

    static boolean match(File f, String[] exts) {
        for (String ext : exts) {
            if (!f.getName().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static List<File> findChangedSrcFiles(File srcDir) {
        Set<File> allSrc = new HashSet<File>();
        allSrc = DirUtil.getAllFiles(srcDir, new String[]{".java", ".html", ".txt", ".json", ".xml", ".js"}, allSrc);
        HashMap<String, Long> javas = new HashMap<String, Long>();
        HashMap<String, Long> srcFiles = new HashMap<String, Long>();
        for (File s : allSrc) {
            String path = s.getPath();
            long modi = s.lastModified();
            if (path.endsWith(".java")) {
                javas.put(path, modi);
                continue;
            }
            srcFiles.put(path, modi);
        }
        ArrayList<File> rs = new ArrayList<File>();
        for (String src : srcFiles.keySet()) {
            String javak = DirUtil.mapSrcToJava(src);
            Long t = (Long)javas.get(javak);
            if (t == null) {
                rs.add(new File(src));
                continue;
            }
            Long srcStamp = (Long)srcFiles.get(src);
            if (srcStamp.compareTo(t) <= 0) continue;
            rs.add(new File(src));
        }
        return rs;
    }

    public static String mapSrcToJava(String k) {
        if (k.endsWith(".txt")) {
            return DirUtil.getRoot(k) + "_txt" + ".java";
        }
        if (k.endsWith(".xml")) {
            return DirUtil.getRoot(k) + "_xml" + ".java";
        }
        if (k.endsWith(".json")) {
            return DirUtil.getRoot(k) + "_json" + ".java";
        }
        if (k.endsWith(".css")) {
            return DirUtil.getRoot(k) + "_css" + ".java";
        }
        if (k.endsWith(".js")) {
            return DirUtil.getRoot(k) + "_js" + ".java";
        }
        return DirUtil.getRoot(k) + ".java";
    }

    public static String mapJavaToSrc(String k) {
        if (k.endsWith(".java")) {
            k = k.substring(0, k.lastIndexOf(".java"));
        }
        if (k.endsWith("_txt")) {
            return k.substring(0, k.lastIndexOf("_txt")) + ".txt";
        }
        if (k.endsWith("_xml")) {
            return k.substring(0, k.lastIndexOf("_xml")) + ".xml";
        }
        if (k.endsWith("_json")) {
            return k.substring(0, k.lastIndexOf("_json")) + ".json";
        }
        if (k.endsWith("_css")) {
            return k.substring(0, k.lastIndexOf("_css")) + ".css";
        }
        if (k.endsWith("_js")) {
            return k.substring(0, k.lastIndexOf("_js")) + ".js";
        }
        return k + ".html";
    }

    private static String getRoot(String k) {
        int indexOf = k.lastIndexOf(".");
        if (indexOf > 0) {
            return k.substring(0, indexOf);
        }
        return k;
    }

    public static void writeStringToFile(File file, String content) throws IOException {
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        BufferedWriter bw = new BufferedWriter(fw);
        bw.append(content);
        bw.close();
    }

    public static void touch(File newer) throws IOException {
        DirUtil.writeStringToFile(newer, "");
    }

    public static boolean containsTemplateFiles(String root, String dirName) {
        String sep = File.separator;
        String japidViews = root + sep + "japidviews" + sep;
        String dir = japidViews + dirName;
        return DirUtil.containsTemplatesInDir(dir);
    }

    public static boolean containsTemplatesInDir(String dirName) {
        File javatags = new File(dirName);
        if (javatags.exists()) {
            String[] temps = DirUtil.getAllFileNames(javatags, new String[]{".html", ".js", ".txt", ".css", ".xml", ".json"});
            return temps.length > 0;
        }
        return false;
    }

    public static boolean hasTags(String root) {
        String dirName = "_tags";
        return DirUtil.containsTemplateFiles(root, dirName);
    }

    public static boolean hasJavaTags(String root) {
        String dirName = "_javatags";
        return DirUtil.containsTemplateFiles(root, dirName);
    }

    public static boolean hasLayouts(String root) {
        String dirName = "_layouts";
        return DirUtil.containsTemplateFiles(root, dirName);
    }
}

