/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import cn.bran.japid.compiler.NamedArg;
import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.TokenMgrError;
import japa.parser.ast.BlockComment;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.LineComment;
import japa.parser.ast.Node;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.TypeParameter;
import japa.parser.ast.body.AnnotationDeclaration;
import japa.parser.ast.body.AnnotationMemberDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.EmptyMemberDeclaration;
import japa.parser.ast.body.EmptyTypeDeclaration;
import japa.parser.ast.body.EnumConstantDeclaration;
import japa.parser.ast.body.EnumDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.InitializerDeclaration;
import japa.parser.ast.body.JavadocComment;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.body.VariableDeclaratorId;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.ArrayAccessExpr;
import japa.parser.ast.expr.ArrayCreationExpr;
import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.AssignExpr;
import japa.parser.ast.expr.BinaryExpr;
import japa.parser.ast.expr.BooleanLiteralExpr;
import japa.parser.ast.expr.CastExpr;
import japa.parser.ast.expr.CharLiteralExpr;
import japa.parser.ast.expr.ClassExpr;
import japa.parser.ast.expr.ConditionalExpr;
import japa.parser.ast.expr.DoubleLiteralExpr;
import japa.parser.ast.expr.EnclosedExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.FieldAccessExpr;
import japa.parser.ast.expr.InstanceOfExpr;
import japa.parser.ast.expr.IntegerLiteralExpr;
import japa.parser.ast.expr.IntegerLiteralMinValueExpr;
import japa.parser.ast.expr.LongLiteralExpr;
import japa.parser.ast.expr.LongLiteralMinValueExpr;
import japa.parser.ast.expr.MarkerAnnotationExpr;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.MethodCallExpr;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.NullLiteralExpr;
import japa.parser.ast.expr.ObjectCreationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.SingleMemberAnnotationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import japa.parser.ast.expr.SuperExpr;
import japa.parser.ast.expr.ThisExpr;
import japa.parser.ast.expr.UnaryExpr;
import japa.parser.ast.expr.VariableDeclarationExpr;
import japa.parser.ast.stmt.AssertStmt;
import japa.parser.ast.stmt.BlockStmt;
import japa.parser.ast.stmt.BreakStmt;
import japa.parser.ast.stmt.CatchClause;
import japa.parser.ast.stmt.ContinueStmt;
import japa.parser.ast.stmt.DoStmt;
import japa.parser.ast.stmt.EmptyStmt;
import japa.parser.ast.stmt.ExplicitConstructorInvocationStmt;
import japa.parser.ast.stmt.ExpressionStmt;
import japa.parser.ast.stmt.ForStmt;
import japa.parser.ast.stmt.ForeachStmt;
import japa.parser.ast.stmt.IfStmt;
import japa.parser.ast.stmt.LabeledStmt;
import japa.parser.ast.stmt.ReturnStmt;
import japa.parser.ast.stmt.SwitchEntryStmt;
import japa.parser.ast.stmt.SwitchStmt;
import japa.parser.ast.stmt.SynchronizedStmt;
import japa.parser.ast.stmt.ThrowStmt;
import japa.parser.ast.stmt.TryStmt;
import japa.parser.ast.stmt.TypeDeclarationStmt;
import japa.parser.ast.stmt.WhileStmt;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.PrimitiveType;
import japa.parser.ast.type.ReferenceType;
import japa.parser.ast.type.Type;
import japa.parser.ast.type.VoidType;
import japa.parser.ast.type.WildcardType;
import japa.parser.ast.visitor.GenericVisitor;
import japa.parser.ast.visitor.VoidVisitor;
import japa.parser.ast.visitor.VoidVisitorAdapter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSyntaxTool {
    private static final String UTF_8 = "UTF-8";
    private static final String classTempForParams = "class T { void t(%s) {} }";
    private static final String classTempForArgs = "class T {  {  foo(%s); } }";
    private static final String classTempForArgsNoParenthesis = "class T {  {  foo%s; } }";
    private static final String classTempForExpr = "class T {  {  f = %s ; } }";
    public static final Pattern AS_PATTERN = Pattern.compile("(.*)->\\s*(\\w+)");
    static final String classTempForStmt = "class T {  {   %s ; } }";
    static final String varDeclTemp = "class T {  {  for (%s : collection){} } }";
    public static final Pattern methPattern = Pattern.compile("[\\w\\.\\$\\s]+\\(.*\\)");
    public static String IF_PREDICATE = "class T {  {  if %s {} } }";
    public static String IF_PREDICATE_BRACE = "class T {  {  if %s } } }";
    public static String IF_PREDICATE_OPEN = "class T {  {  if(%s) {} } }";
    public static String IF_PREDICATE_OPEN_BRACE = "class T {  {  if (%s) } } }";
    public static final String TEMP_FOR_HEADER = "class T {  {  for (%s){} } }";

    public static CompilationUnit parse(String src) throws ParseException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(src.getBytes(UTF_8));
            CompilationUnit cu = JavaParser.parse((InputStream)in, (String)UTF_8);
            return cu;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (TokenMgrError e) {
            throw new ParseException(e.getMessage());
        }
        return null;
    }

    public static boolean isValid(String src) {
        try {
            CompilationUnit cu = JavaSyntaxTool.parse(src);
            return true;
        }
        catch (ParseException e) {
            String m = e.getMessage() + "\n";
            System.out.println(m.substring(0, m.indexOf(10)));
            return false;
        }
    }

    public static List<Parameter> parseParams(String line) {
        final ArrayList<Parameter> ret = new ArrayList<Parameter>();
        if (line == null || line.trim().length() == 0) {
            return ret;
        }
        line = line.replace("@default(", "@Default(");
        String cl = String.format(classTempForParams, line);
        try {
            CompilationUnit cu = JavaSyntaxTool.parse(cl);
            VoidVisitorAdapter visitor = new VoidVisitorAdapter(){

                public void visit(Parameter p, Object arg) {
                    ret.add(p);
                }
            };
            cu.accept((VoidVisitor)visitor, null);
        }
        catch (ParseException e) {
            throw new RuntimeException("the line does not seem to be a valid param list declaration: " + line);
        }
        return ret;
    }

    public static List<String> parseArgs(String line) {
        String cl;
        final ArrayList<String> ret = new ArrayList<String>();
        if (line == null || line.trim().length() == 0) {
            return ret;
        }
        VoidVisitorAdapter visitor = new VoidVisitorAdapter(){

            public void visit(MethodCallExpr n, Object arg) {
                List args = n.getArgs();
                if (args != null) {
                    for (Expression e : args) {
                        ret.add(e.toString());
                    }
                }
            }
        };
        if ((line = line.trim()).startsWith("(")) {
            cl = String.format(classTempForArgsNoParenthesis, line);
            try {
                CompilationUnit cu = JavaSyntaxTool.parse(cl);
                cu.accept((VoidVisitor)visitor, null);
                return ret;
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        cl = String.format(classTempForArgs, line);
        try {
            CompilationUnit cu = JavaSyntaxTool.parse(cl);
            cu.accept((VoidVisitor)visitor, null);
        }
        catch (ParseException e) {
            throw new RuntimeException("the line does not seem to be a valid arg list: " + line);
        }
        return ret;
    }

    public static List<NamedArg> parseNamedArgs(String line) {
        final ArrayList<NamedArg> ret = new ArrayList<NamedArg>();
        if (line == null || line.trim().length() == 0) {
            return ret;
        }
        line = line.trim();
        String cl = String.format(classTempForArgs, line);
        final String finalLine = line;
        try {
            CompilationUnit cu = JavaSyntaxTool.parse(cl);
            VoidVisitorAdapter visitor = new VoidVisitorAdapter(){
                boolean hasNamed = false;
                boolean hasUnNamed = false;

                public void visit(MethodCallExpr n, Object arg) {
                    List args = n.getArgs();
                    if (args != null) {
                        for (Expression expr : args) {
                            if (expr instanceof AssignExpr) {
                                if (this.hasUnNamed) {
                                    throw new RuntimeException("the line has mixed named and un-named arg list. It's not valid in Japid tag invocation. It must be all-or-none.: " + finalLine);
                                }
                                this.hasNamed = true;
                                AssignExpr ae = (AssignExpr)expr;
                                NamedArg na = new NamedArg(ae.getTarget(), ae.getValue());
                                ret.add(na);
                                continue;
                            }
                            if (this.hasNamed) {
                                throw new RuntimeException("the line has mixed named and un-named arg list. It's not valid in Japid tag invocation. It must be all-or-none.: " + finalLine);
                            }
                            this.hasUnNamed = true;
                        }
                    }
                }
            };
            cu.accept((VoidVisitor)visitor, null);
        }
        catch (ParseException e) {
            throw new RuntimeException("the line does not seem to be a valid arg list: " + line + ". ");
        }
        return ret;
    }

    public static boolean hasMethod(String javaSource, String string) throws ParseException {
        CompilationUnit cu = JavaSyntaxTool.parse(javaSource);
        return JavaSyntaxTool.hasMethod(cu, string);
    }

    public static boolean hasMethodInvocatioin(CompilationUnit cu, final String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        final StringBuilder re = new StringBuilder();
        VoidVisitorAdapter visitor = new VoidVisitorAdapter(){

            public void visit(MethodCallExpr n, Object arg) {
                if (string.equals(n.getName())) {
                    re.append(1);
                    return;
                }
                super.visit(n, arg);
            }
        };
        cu.accept((VoidVisitor)visitor, null);
        return re.length() != 0;
    }

    public static boolean hasMethod(CompilationUnit cu, final String string) {
        final StringBuilder sb = new StringBuilder();
        VoidVisitorAdapter visitor = new VoidVisitorAdapter(){

            public void visit(MethodDeclaration n, Object arg) {
                if (n.getName().equals(string)) {
                    sb.append(1);
                    return;
                }
            }
        };
        cu.accept((VoidVisitor)visitor, null);
        return sb.length() != 0;
    }

    public static boolean hasMethod(CompilationUnit cu, final String name, final int modis, final String returnType, String paramList) {
        final StringBuilder sb = new StringBuilder();
        if (paramList == null) {
            paramList = "";
        }
        String formalParamList = JavaSyntaxTool.addParamNamesPlaceHolder(paramList);
        final List<Parameter> params = JavaSyntaxTool.parseParams(formalParamList);
        VoidVisitorAdapter visitor = new VoidVisitorAdapter(){

            public void visit(MethodDeclaration n, Object arg) {
                Type type;
                int modifiers2;
                if (n.getName().equals(name) && (modifiers2 = n.getModifiers()) == modis && (type = n.getType()).toString().equals(returnType)) {
                    ArrayList<Parameter> ps = n.getParameters();
                    if (ps == null) {
                        ps = new ArrayList<Parameter>();
                    }
                    if (JavaSyntaxTool.paramsMatch(params, ps)) {
                        sb.append(1);
                        return;
                    }
                }
            }
        };
        cu.accept((VoidVisitor)visitor, null);
        return sb.length() != 0;
    }

    public static boolean hasMethod(CompilationUnit cu, String name, String modifiers, String returnType, String paramList) {
        int modis = JavaSyntaxTool.parseModifiers(modifiers);
        return JavaSyntaxTool.hasMethod(cu, name, modis, returnType, paramList);
    }

    static String addParamNamesPlaceHolder(String paramList) {
        List<String> names = JavaSyntaxTool.getNames(paramList);
        String formalParamList = "";
        for (int i = 0; i < names.size(); ++i) {
            formalParamList = formalParamList + names.get(i) + " " + (char)(97 + i) + ",";
        }
        if (formalParamList.endsWith(",")) {
            formalParamList = formalParamList.substring(0, formalParamList.length() - 1);
        }
        return formalParamList;
    }

    private static List<String> getNames(String paramList) {
        paramList = paramList.replace(' ', ',');
        String[] pams = paramList.split(",");
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < pams.length; ++i) {
            String p = pams[i].trim();
            if (p.length() <= 0) continue;
            names.add(p);
        }
        return names;
    }

    protected static boolean paramsMatch(List<Parameter> params, List<Parameter> ps) {
        if (params == ps) {
            return true;
        }
        if (params == null && ps != null || params != null && ps == null) {
            return false;
        }
        if (params.size() != ps.size()) {
            return false;
        }
        for (int i = 0; i < params.size(); ++i) {
            Parameter p2;
            Parameter p1 = params.get(i);
            if (JavaSyntaxTool.matchParams(p1, p2 = ps.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchParams(Parameter p1, Parameter p2) {
        if (p1.equals((Object)p2)) {
            return true;
        }
        if (p1.getModifiers() != p2.getModifiers()) {
            return false;
        }
        return p1.getType().equals((Object)p2.getType());
    }

    private static int parseModifiers(String modifiers) {
        int ret = 0;
        List<String> names = JavaSyntaxTool.getNames(modifiers);
        for (String m : names) {
            if (m.equals("public")) {
                ret |= 1;
                continue;
            }
            if (m.equals("private")) {
                ret |= 2;
                continue;
            }
            if (m.equals("protected")) {
                ret |= 4;
                continue;
            }
            if (m.equals("static")) {
                ret |= 8;
                continue;
            }
            if (m.equals("final")) {
                ret |= 0x10;
                continue;
            }
            if (m.equals("final")) {
                ret |= 0x10;
                continue;
            }
            if (!m.equals("synchronized")) continue;
            ret |= 0x20;
        }
        return ret;
    }

    public static String addFinalToAllParams(String paramline) {
        if (paramline == null) {
            return null;
        }
        if ((paramline = paramline.trim()).length() == 0) {
            return "";
        }
        List<Parameter> params = JavaSyntaxTool.parseParams(paramline);
        String s = "";
        for (Parameter p : params) {
            s = s + "final " + p.getType() + " " + p.getId().getName() + ", ";
        }
        return s.substring(0, s.lastIndexOf(", "));
    }

    public static String boxPrimitiveTypesInParams(String paramline) {
        if (paramline == null) {
            return null;
        }
        if ((paramline = paramline.trim()).length() == 0) {
            return "";
        }
        List<Parameter> params = JavaSyntaxTool.parseParams(paramline);
        String s = "";
        for (Parameter p : params) {
            String decl = p.getType() + " " + p.getId().getName();
            decl = JavaSyntaxTool.cleanDeclPrimitive(decl);
            s = s + decl + ", ";
        }
        return s.substring(0, s.lastIndexOf(", "));
    }

    public static String matchLongestPossibleExpr(String src) {
        if (src == null || src.trim().length() == 0) {
            return "";
        }
        src = src.trim();
        String expr = "";
        for (int i = src.length(); i > 0; --i) {
            expr = src.substring(0, i);
            if (expr.endsWith(";")) continue;
            String ss = String.format(classTempForExpr, expr);
            try {
                JavaSyntaxTool.parse(ss);
                break;
            }
            catch (ParseException e) {
                expr = "";
            }
        }
        return expr.trim();
    }

    public static String getDefault(Parameter p) {
        String r = "";
        List annotations = p.getAnnotations();
        if (annotations == null) {
            return null;
        }
        for (AnnotationExpr an : annotations) {
            String name = an.getName().getName();
            if (!"Default".equals(name)) continue;
            String string = an.toString();
            r = string.substring("@Default(".length(), string.length() - 1);
            break;
        }
        return r;
    }

    public static String cleanDeclPrimitive(String decl) {
        decl = decl.trim();
        int i = decl.length();
        String var = "";
        String type = "";
        while (--i >= 0) {
            char c = decl.charAt(i);
            if (c != ' ' && c != '\t') continue;
            var = decl.substring(i + 1);
            type = decl.substring(0, i).trim();
            break;
        }
        if ("int".equals(type)) {
            decl = "Integer " + var;
        } else if ("long".equals(type)) {
            decl = "Long " + var;
        } else if ("short".equals(type)) {
            decl = "Short " + var;
        } else if ("byte".equals(type)) {
            decl = "Byte " + var;
        } else if ("float".equals(type)) {
            decl = "Float " + var;
        } else if ("double".equals(type)) {
            decl = "Double " + var;
        } else if ("char".equals(type)) {
            decl = "Character " + var;
        } else if ("boolean".equals(type)) {
            decl = "Boolean " + var;
        }
        return decl;
    }

    public static String[] breakArgParts(String s) {
        Matcher m = AS_PATTERN.matcher(s);
        if (m.matches()) {
            String[] r = new String[]{m.group(1), m.group(2)};
            return r;
        }
        return new String[]{s};
    }

    public static boolean isValidExpr(String expr) {
        String ss = String.format(classTempForExpr, expr);
        try {
            JavaSyntaxTool.parse(ss);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static void isValidMethDecl(String line) {
        String classTempForMeth = "class T {  %s{} }";
        String classString = String.format("class T {  %s{} }", line);
        try {
            CompilationUnit cu = JavaSyntaxTool.parse(classString);
            VoidVisitorAdapter visitor = new VoidVisitorAdapter(){};
            cu.accept((VoidVisitor)visitor, null);
        }
        catch (ParseException e) {
            throw new RuntimeException("the line does not seem to be a valid method declaration: " + line + ". Was expecting something like foo(int a, String b).");
        }
    }

    public static void isValidMethodCall(String src) {
        String classString = String.format(classTempForStmt, src);
        try {
            List<CodeNode> nodes = JavaSyntaxTool.parseCode(classString);
            if (JavaSyntaxTool.tyepMatch(nodes, 5, MethodCallExpr.class) && JavaSyntaxTool.getIndentatioCount(nodes, 4) == 1) {
                return;
            }
            throw new RuntimeException("the line does not seem to be a valid method invocation expression: " + src + ". Was expecting something like x.foo(a, b).");
        }
        catch (RuntimeException e) {
            throw new RuntimeException("the line does not seem to be a valid method invocation expression: " + src + ". Was expecting something like foo(a, b).");
        }
    }

    private static int getIndentatioCount(List<CodeNode> nodes, int i) {
        int c = 0;
        for (CodeNode n : nodes) {
            if (n.nestLevel != i) continue;
            ++c;
        }
        return c;
    }

    private static boolean tyepMatch(List<CodeNode> nodes, int pos, Class<? extends Node> targetClass) {
        return nodes.size() > pos && nodes.get((int)pos).node.getClass() == targetClass;
    }

    public static boolean isValidSingleVarDecl(String src) {
        String classString = String.format(varDeclTemp, src);
        try {
            CompilationUnit cu = JavaSyntaxTool.parse(classString);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidMethodCallSimple(String src) {
        if (src == null) {
            return false;
        }
        if ((src = src.trim()).length() < 3) {
            return false;
        }
        return methPattern.matcher(src).matches();
    }

    public static boolean isIf(String part) {
        String classString = String.format(IF_PREDICATE, part);
        try {
            CompilationUnit cu = JavaSyntaxTool.parse(classString);
            return true;
        }
        catch (ParseException e) {
            classString = String.format(IF_PREDICATE_BRACE, part);
            try {
                CompilationUnit cu = JavaSyntaxTool.parse(classString);
                return true;
            }
            catch (ParseException e1) {
                return false;
            }
        }
    }

    public static boolean isOpenIf(String part) {
        if ((part = part.trim()).endsWith("{")) {
            part = part.substring(0, part.length() - 1);
        }
        String classString = String.format(IF_PREDICATE_OPEN, part);
        try {
            CompilationUnit cu = JavaSyntaxTool.parse(classString);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidForLoopPredicate(String part) {
        String classString = String.format(TEMP_FOR_HEADER, part);
        try {
            CompilationUnit cu = JavaSyntaxTool.parse(classString);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static List<CodeNode> parseCode(String code) {
        try {
            final LinkedList<CodeNode> nodes = new LinkedList<CodeNode>();
            CompilationUnit cu = JavaSyntaxTool.parse(code);
            VoidVisitorAdapter visitor = new VoidVisitorAdapter(){
                int nested = 0;

                public void visit(AnnotationDeclaration n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(AnnotationMemberDeclaration n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ArrayAccessExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ArrayCreationExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ArrayInitializerExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(AssertStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(AssignExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(BinaryExpr n, Object arg) {
                    if (n.getOperator() == BinaryExpr.Operator.binOr) {
                        nodes.add(new CodeNode(this.nested++, (Node)new BinaryOrExpr(n)));
                    } else {
                        nodes.add(new CodeNode(this.nested++, (Node)n));
                    }
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(BlockComment n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(BlockStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(BooleanLiteralExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(BreakStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(CastExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(CatchClause n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(CharLiteralExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ClassExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ClassOrInterfaceDeclaration n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ClassOrInterfaceType n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(CompilationUnit n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ConditionalExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ConstructorDeclaration n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ContinueStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(DoStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(DoubleLiteralExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(EmptyMemberDeclaration n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(EmptyStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(EmptyTypeDeclaration n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(EnclosedExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(EnumConstantDeclaration n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(EnumDeclaration n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ExplicitConstructorInvocationStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ExpressionStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(FieldAccessExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(FieldDeclaration n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ForeachStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ForStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(IfStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ImportDeclaration n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(InitializerDeclaration n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(InstanceOfExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(IntegerLiteralExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(IntegerLiteralMinValueExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(JavadocComment n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(LabeledStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(LineComment n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(LongLiteralExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(LongLiteralMinValueExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(MarkerAnnotationExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(MemberValuePair n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(MethodCallExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(MethodDeclaration n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(NameExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(NormalAnnotationExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(NullLiteralExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ObjectCreationExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(PackageDeclaration n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(Parameter n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(PrimitiveType n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(QualifiedNameExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ReferenceType n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ReturnStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(SingleMemberAnnotationExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(StringLiteralExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(SuperExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(SwitchEntryStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(SwitchStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(SynchronizedStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ThisExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(ThrowStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(TryStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(TypeDeclarationStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(TypeParameter n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(UnaryExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(VariableDeclarationExpr n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(VariableDeclarator n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(VariableDeclaratorId n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(VoidType n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(WhileStmt n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }

                public void visit(WildcardType n, Object arg) {
                    nodes.add(new CodeNode(this.nested++, (Node)n));
                    super.visit(n, arg);
                    --this.nested;
                }
            };
            cu.accept((VoidVisitor)visitor, null);
            return nodes;
        }
        catch (ParseException e) {
            throw new RuntimeException("invalid Java code: " + code + ". " + (Object)((Object)e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BinaryOrExpr
    extends Expression {
        BinaryExpr expr;

        public BinaryOrExpr(BinaryExpr expr) {
            this.expr = expr;
        }

        public <R, A> R accept(GenericVisitor<R, A> arg0, A arg1) {
            return null;
        }

        public <A> void accept(VoidVisitor<A> arg0, A arg1) {
        }
    }

    public static class CodeNode {
        public int nestLevel;
        public Node node;

        public CodeNode(int nestLevel, Node node) {
            this.nestLevel = nestLevel;
            this.node = node;
        }
    }

    public static class Param {
        public String type;
        public String name;

        public Param(String type, String name) {
            this.type = type;
            this.name = name;
        }
    }
}

