/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.rendererloader;

import cn.bran.japid.rendererloader.RendererClass;
import cn.bran.japid.template.JapidRenderer;
import cn.bran.japid.util.JapidFlags;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateClassLoader
extends ClassLoader {
    private Map<String, Class<?>> localClasses = new ConcurrentHashMap();
    private ClassLoader parentClassLoader;

    public TemplateClassLoader(ClassLoader cl) {
        super(TemplateClassLoader.class.getClassLoader());
        this.parentClassLoader = cl;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (!name.startsWith("japidviews")) {
            try {
                Class<?> cls = this.parentClassLoader.loadClass(name);
                return cls;
            }
            catch (ClassNotFoundException e) {
                return super.loadClass(name);
            }
        }
        String oid = "[TemplateClassLoader@" + Integer.toHexString(this.hashCode()) + "]";
        Class<?> cla = this.localClasses.get(name);
        if (cla != null) {
            System.out.println(oid + " loaded from local cache : " + name);
            return cla;
        }
        RendererClass rc = JapidRenderer.classes.get(name);
        byte[] bytecode = rc.bytecode;
        if (bytecode == null) {
            throw new RuntimeException(oid + " could not find the bytecode for: " + name);
        }
        Class<?> cl = this.defineClass(name, bytecode, 0, bytecode.length);
        rc.setClz(cl);
        this.localClasses.put(name, cl);
        rc.lastUpdated = 1L;
        if (JapidFlags.verbose) {
            System.out.println(oid + " reloaded from bytecode: " + name);
        }
        return cl;
    }

    protected byte[] getClassDefinition(String name) {
        InputStream is = this.getResourceAsStream(name = name.replace(".", "/") + ".class");
        if (is == null) {
            return null;
        }
        try {
            int count;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((count = is.read(buffer, 0, buffer.length)) > 0) {
                os.write(buffer, 0, count);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

