/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.template.ActionRunner;
import cn.bran.japid.template.JapidTemplateBaseWithoutPlay;
import cn.bran.play.JapidPlayTemplate;
import java.io.File;
import java.io.IOException;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import play.Play;
import play.classloading.ApplicationClasses;
import play.exceptions.TemplateExecutionException;
import play.templates.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JapidTemplateBase
extends JapidTemplateBaseWithoutPlay {
    protected TreeMap<Integer, ActionRunner> actionRunners = new TreeMap();

    public JapidTemplateBase(StringBuilder out) {
        super(out);
    }

    public TreeMap<Integer, ActionRunner> getActionRunners() {
        return this.actionRunners;
    }

    public JapidTemplateBaseWithoutPlay setActionRunners(TreeMap<Integer, ActionRunner> actionRunners) {
        this.actionRunners = actionRunners;
        return this;
    }

    protected void handleException(RuntimeException e) {
        StackTraceElement[] stackTrace;
        if (Play.mode == Play.Mode.PROD) {
            throw e;
        }
        if (e instanceof TemplateExecutionException) {
            throw e;
        }
        for (StackTraceElement ele : stackTrace = e.getStackTrace()) {
            String jsrc;
            String[] splitSrc;
            String line;
            int lineMarker;
            String className = ele.getClassName();
            if (!className.startsWith("japidviews")) continue;
            int lineNumber = ele.getLineNumber();
            ApplicationClasses.ApplicationClass applicationClass = Play.classes.getApplicationClass(className);
            if (applicationClass == null || (lineMarker = (line = (splitSrc = (jsrc = applicationClass.javaSource).split("\n"))[lineNumber - 1]).lastIndexOf("// line ")) <= 0) continue;
            int oriLineNumber = Integer.parseInt(line.substring(lineMarker + 8).trim());
            StackTraceElement[] newStack = new StackTraceElement[stackTrace.length + 1];
            newStack[0] = new StackTraceElement(this.sourceTemplate, "", this.sourceTemplate, oriLineNumber);
            System.arraycopy(stackTrace, 0, newStack, 1, stackTrace.length);
            e.setStackTrace(newStack);
            File file = new File("app/" + this.sourceTemplate);
            JapidPlayTemplate jpt = new JapidPlayTemplate();
            jpt.name = this.sourceTemplate;
            try {
                jpt.source = FileUtils.readFileToString((File)file);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw new TemplateExecutionException((Template)jpt, Integer.valueOf(oriLineNumber), e.getMessage(), (Throwable)e);
        }
        throw e;
    }
}

