/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.compiler.JapidTemplateTransformer;
import cn.bran.japid.compiler.TranslateTemplateTask;
import cn.bran.japid.util.DirUtil;
import cn.bran.play.JapidPlayAdapter;
import cn.bran.play.NoEnhance;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import play.Play;
import play.data.validation.Error;
import play.data.validation.Validation;
import play.i18n.Lang;
import play.i18n.Messages;
import play.mvc.Http;
import play.mvc.Scope;
import play.templates.JavaExtensions;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidCommands {
    private static final String APP = "app";

    public static void main(String[] args) throws IOException {
        String arg0 = args[0];
        String applicationPath = ".";
        if (args.length > 1) {
            applicationPath = args[1];
        }
        Play.applicationPath = new File(applicationPath);
        String appPath = Play.applicationPath.getAbsolutePath() + File.separator;
        if ("gen".equals(arg0)) {
            JapidCommands.gen(appPath + APP);
        } else if ("regen".equals(arg0)) {
            JapidCommands.regen(appPath + APP);
        } else if ("clean".equals(arg0)) {
            JapidCommands.delAllGeneratedJava(appPath + APP + File.separator + "japidviews");
        } else if ("mkdir".equals(arg0)) {
            JapidCommands.mkdir(appPath + APP);
        } else {
            JapidCommands.log("not known: " + arg0);
        }
    }

    public static List<File> mkdir(String root) throws IOException {
        boolean mkdirs;
        File ff;
        String cp;
        String[] controllers;
        File notifiers;
        File tags;
        File layouts;
        String sep = File.separator;
        String japidViews = root + sep + "japidviews" + sep;
        File javatags = new File(japidViews + "_javatags");
        if (!javatags.exists()) {
            boolean mkdirs2 = javatags.mkdirs();
            assert (mkdirs2);
            JapidCommands.log("created: " + japidViews + "_javatags");
        }
        if (!(layouts = new File(japidViews + "_layouts")).exists()) {
            boolean mkdirs3 = layouts.mkdirs();
            assert (mkdirs3);
            JapidCommands.log("created: " + japidViews + "_layouts");
        }
        if (!(tags = new File(japidViews + "_tags")).exists()) {
            boolean mkdirs4 = tags.mkdirs();
            assert (mkdirs4);
            JapidCommands.log("created: " + japidViews + "_tags");
        }
        if (!(notifiers = new File(japidViews + "_notifiers")).exists()) {
            boolean mkdirs5 = notifiers.mkdirs();
            assert (mkdirs5);
            JapidCommands.log("created: " + japidViews + "_notifiers");
        }
        File[] dirs = new File[]{javatags, layouts, tags};
        ArrayList<File> res = new ArrayList<File>();
        res.addAll(Arrays.asList(dirs));
        try {
            String controllerPath = root + sep + "controllers";
            File controllerPathFile = new File(controllerPath);
            if (controllerPathFile.exists()) {
                for (String f : controllers = JapidCommands.getAllJavaFilesInDir(controllerPathFile)) {
                    cp = japidViews + f;
                    ff = new File(cp);
                    if (ff.exists()) continue;
                    mkdirs = ff.mkdirs();
                    assert (mkdirs);
                    res.add(ff);
                    JapidCommands.log("created: " + cp);
                }
            }
        }
        catch (Exception e) {
            JapidCommands.log(e.toString());
        }
        try {
            String notifiersDir = root + sep + "notifiers";
            File notifiersDirFile = new File(notifiersDir);
            if (!notifiersDirFile.exists()) {
                if (notifiersDirFile.mkdir()) {
                    JapidCommands.log("created the email notifiers directory. ");
                } else {
                    JapidCommands.log("email notifiers directory did not exist and could not be created for unknow reason. ");
                }
            }
            for (String f : controllers = JapidCommands.getAllJavaFilesInDir(notifiersDirFile)) {
                cp = japidViews + "_notifiers" + sep + f;
                ff = new File(cp);
                if (ff.exists()) continue;
                mkdirs = ff.mkdirs();
                assert (mkdirs);
                res.add(ff);
                JapidCommands.log("created: " + cp);
            }
        }
        catch (Exception e) {
            JapidCommands.log(e.toString());
        }
        return res;
    }

    public static void regen() throws IOException {
        JapidCommands.regen(APP);
    }

    public static void regen(String root) throws IOException {
        String pathname = root + File.separatorChar + "japidviews";
        JapidCommands.delAllGeneratedJava(pathname);
        JapidCommands.gen(root);
    }

    public static void delAllGeneratedJava(String pathname) {
        String[] javas;
        for (String j : javas = DirUtil.getAllFileNames((File)new File(pathname), (String[])new String[]{"java"})) {
            if (j.contains("_javatags")) continue;
            String filePath = pathname + File.separatorChar + j;
            JapidCommands.log("removed: " + filePath);
            boolean delete = new File(filePath).delete();
            if (delete) continue;
            throw new RuntimeException("file was not deleted: " + j);
        }
    }

    public static void gen(String packageRoot) throws IOException {
        List<File> changedFiles = JapidCommands.reloadChanged(packageRoot);
        if (changedFiles.size() > 0) {
            for (File f : changedFiles) {
                String relativePath = JapidTemplateTransformer.getRelativePath((File)f, (File)Play.applicationPath);
                JapidCommands.log("updated: " + relativePath.replace("html", "java"));
            }
        } else {
            JapidCommands.log("No java files need to be updated.");
        }
        JapidCommands.rmOrphanJava();
    }

    public static List<File> reloadChanged(String root) {
        try {
            JapidCommands.mkdir(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        TranslateTemplateTask t = new TranslateTemplateTask();
        File rootDir = new File(root);
        t.setPackageRoot(rootDir);
        t.setInclude(new File(rootDir, "japidviews"));
        t.clearImports();
        t.importStatic(JapidPlayAdapter.class);
        t.importStatic(Validation.class);
        t.importStatic(JavaExtensions.class);
        t.addAnnotation(NoEnhance.class);
        if (DirUtil.hasLayouts((String)root)) {
            t.addImport("japidviews._layouts.*");
        }
        if (DirUtil.hasJavaTags((String)root)) {
            t.addImport("japidviews._javatags.*");
        }
        if (DirUtil.hasTags((String)root)) {
            t.addImport("japidviews._tags.*");
        }
        t.addImport("models.*");
        t.addImport("controllers.*");
        t.addImport(Scope.class.getName() + ".*");
        t.addImport(Messages.class);
        t.addImport(Lang.class);
        t.addImport(Http.class.getName() + ".*");
        t.addImport(Validation.class.getName());
        t.addImport(Error.class.getName());
        List<String> javatags = JapidCommands.scanJavaTags(root);
        for (String f : javatags) {
            t.addImport("static " + f + ".*");
        }
        t.execute();
        List changedFiles = t.getChangedFiles();
        return changedFiles;
    }

    public static List<String> scanJavaTags(String root) {
        String sep = File.separator;
        String japidViews = root + sep + "japidviews" + sep;
        File javatags = new File(japidViews + "_javatags");
        if (!javatags.exists()) {
            boolean mkdirs = javatags.mkdirs();
            assert (mkdirs);
            JapidCommands.log("created: " + japidViews + "_javatags");
        }
        File[] javafiles = javatags.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        });
        ArrayList<String> files = new ArrayList<String>();
        for (File f : javafiles) {
            String fname = f.getName();
            files.add("japidviews._javatags." + fname.substring(0, fname.lastIndexOf(".java")));
        }
        return files;
    }

    public static String[] getAllJavaFilesInDir(File root) {
        String[] allFiles = DirUtil.getAllFileNames((File)root, (String[])new String[]{".java"});
        for (int i = 0; i < allFiles.length; ++i) {
            allFiles[i] = allFiles[i].replace(".java", "");
        }
        return allFiles;
    }

    public static boolean rmOrphanJava() {
        boolean hasOrphan = false;
        String appAbs = Play.applicationPath.getAbsolutePath() + File.separator + APP;
        hasOrphan = JapidCommands.removeOrphanedJavaFrom(appAbs);
        Collection modules = Play.modules.values();
        for (VirtualFile module : modules) {
            try {
                String absoluteRootPath;
                VirtualFile root = module.child(APP);
                VirtualFile japidViewDir = root.child("japidviews");
                File japidFile = japidViewDir.getRealFile();
                if (!japidFile.exists() || !JapidCommands.removeOrphanedJavaFrom(absoluteRootPath = root.getRealFile().getAbsolutePath())) continue;
                hasOrphan = true;
            }
            catch (Throwable t) {}
        }
        return hasOrphan;
    }

    private static boolean removeOrphanedJavaFrom(String root) {
        boolean hasRealOrphan = false;
        try {
            String pathname = root + File.separator + "japidviews";
            File src = new File(pathname);
            if (!src.exists()) {
                JapidCommands.log("Could not find required Japid package structure: " + pathname);
                JapidCommands.log("Please use \"play japid:mkdir\" command to create the Japid view structure.");
                return hasRealOrphan;
            }
            Set oj = DirUtil.findOrphanJava((File)src, null);
            for (File j : oj) {
                String path = j.getPath();
                if (path.contains("_javatags")) continue;
                hasRealOrphan = true;
                String realfile = pathname + File.separator + path;
                File file = new File(realfile);
                boolean r = file.delete();
                if (r) {
                    JapidCommands.log("deleted orphan " + realfile);
                    continue;
                }
                JapidCommands.log("failed to delete: " + realfile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasRealOrphan;
    }

    public static List<File> reloadChanged() {
        List<File> reloadChanged = JapidCommands.reloadChanged(new File(Play.applicationPath, APP).getAbsolutePath());
        Collection modules = Play.modules.values();
        for (VirtualFile module : modules) {
            try {
                VirtualFile root = module.child(APP);
                VirtualFile japidViewDir = root.child("japidviews");
                File japidFile = japidViewDir.getRealFile();
                if (!japidFile.exists()) continue;
                String absoluteRootPath = root.getRealFile().getAbsolutePath();
                reloadChanged.addAll(JapidCommands.reloadChanged(absoluteRootPath));
            }
            catch (Throwable t) {}
        }
        return reloadChanged;
    }

    private static void log(String m) {
        System.out.println("[JapidCommands]: " + m);
    }
}

