/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.template.RenderResult;
import cn.bran.play.AltCache;
import cn.bran.play.CachedItemStatus;
import cn.bran.play.CachedRenderResult;
import cn.bran.play.ShouldRefreshException;
import play.cache.Cache;
import play.libs.Time;

public class RenderResultCache {
    static final double SAFE_TIME_ZONE = 0.9;
    public static final String READ_THRU_FLASH = "j.rtf";
    private static ThreadLocal<Boolean> ignoreCacheFlash = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Boolean> ignoreCache = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static AltCache altCache;

    public static AltCache getAltCache() {
        return altCache;
    }

    public static void setAltCache(AltCache altCache) {
        RenderResultCache.altCache = altCache;
    }

    public static void setIgnoreCache(boolean b) {
        ignoreCache.set(b);
    }

    public static void setIgnoreCacheInCurrentAndNextReq(boolean b) {
        ignoreCache.set(b);
        ignoreCacheFlash.set(b);
    }

    public static boolean shouldIgnoreCache() {
        Boolean should = ignoreCache.get();
        if (should == null) {
            return false;
        }
        return should;
    }

    public static void set(String key, RenderResult rr, String ttl) {
        long tl = (long)Time.parseDuration((String)ttl) * 1000L;
        CachedItemStatus cachedItemStatus = new CachedItemStatus(tl);
        RenderResultCache.cacheset(key, ttl, new CachedRenderResult(cachedItemStatus, rr));
    }

    private static void cacheset(String key, String ttl, CachedRenderResult rrc) {
        if (altCache != null) {
            altCache.set(key, rrc, ttl);
        } else {
            Cache.set((String)key, (Object)rrc, (String)ttl);
        }
    }

    public static RenderResult get(String key) throws ShouldRefreshException {
        if (RenderResultCache.shouldIgnoreCache()) {
            return null;
        }
        CachedRenderResult renderResult = RenderResultCache.cacheget(key);
        if (renderResult == null) {
            return null;
        }
        if (renderResult.status.shouldRefresh()) {
            throw new ShouldRefreshException(renderResult);
        }
        return renderResult.rr;
    }

    private static CachedRenderResult cacheget(String key) {
        if (altCache != null) {
            return altCache.get(key);
        }
        return (CachedRenderResult)Cache.get((String)key);
    }

    public static boolean shouldIgnoreCacheInCurrentAndNextReq() {
        return ignoreCacheFlash.get();
    }

    public static void delete(String key) {
        if (altCache != null) {
            altCache.delete(key);
        } else {
            Cache.delete((String)key);
        }
    }
}

