/*
 * Decompiled with CFR 0.152.
 */
package play.modules.jelastic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import play.Logger;
import play.Play;
import play.modules.jelastic.CustomMultiPartEntity;
import play.modules.jelastic.model.AuthenticationResponse;
import play.modules.jelastic.model.CreateObjectResponse;
import play.modules.jelastic.model.DeployResponse;
import play.modules.jelastic.model.UploadResponse;

public class Jelastic {
    private Map<String, String> config;
    private String command;
    private String shema = "https";
    private int port = -1;
    private Double version = 1.0;
    private long totalSize;
    private int numSt;
    private CookieStore cookieStore = null;
    private String urlAuthentication = "/" + this.version + "/users/authentication/rest/signin";
    private String urlUploader = "/" + this.version + "/storage/uploader/rest/upload";
    private String urlCreateObject = "/deploy/createobject";
    private String urlDeploy = "/deploy/DeployArchive";

    public int getPort() {
        return this.port;
    }

    public String getShema() {
        return this.shema;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public String getUrlAuthentication() {
        return this.urlAuthentication;
    }

    public String getUrlUploader() {
        return this.urlUploader;
    }

    public String getUrlCreateObject() {
        return this.urlCreateObject;
    }

    public String getUrlDeploy() {
        return this.urlDeploy;
    }

    public Jelastic(String command) {
        this.command = command;
        this.initConfigurations();
    }

    private void initConfigurations() {
        this.config = new HashMap<String, String>();
        String email = Play.configuration.getProperty("jelastic.api.login");
        String password = Play.configuration.getProperty("jelastic.api.password");
        String context = Play.configuration.getProperty("jelastic.api.context");
        String environment = Play.configuration.getProperty("jelastic.api.environment");
        String apihoster = Play.configuration.getProperty("jelastic.api.apihoster");
        String app_war = System.getProperty("jelastic.app.war");
        if (app_war == null) {
            throw new IllegalArgumentException("jelastic.app.war is not set or no generate war");
        }
        this.config.put("war_file", app_war);
        email = System.getProperty("jelastic.api.login", email);
        if (email == null || email.length() <= 0) {
            throw new IllegalArgumentException("jelastic.api.login is not set in application.conf or from --l");
        }
        this.config.put("login", email);
        password = System.getProperty("jelastic.api.password", password);
        if (password == null || password.length() <= 0) {
            throw new IllegalArgumentException("jelastic.api.password is not set in application.conf or from --p");
        }
        this.config.put("password", password);
        context = System.getProperty("jelastic.api.context", context);
        if (context == null || context.length() <= 0) {
            throw new IllegalArgumentException("jelastic.api.context is not set in application.conf or from --c");
        }
        this.config.put("context", context);
        environment = System.getProperty("jelastic.api.environment", environment);
        if (environment == null || environment.length() <= 0) {
            throw new IllegalArgumentException("jelastic.api.environment is not set in application.conf or from --e");
        }
        this.config.put("environment", environment);
        apihoster = System.getProperty("jelastic.api.apihoster", apihoster);
        if (apihoster == null) {
            throw new IllegalArgumentException("jelastic.api.apihoster is not set in application.conf or from --a");
        }
        this.config.put("apihoster", apihoster);
    }

    public static void main(String[] args) {
        Play.readConfiguration();
        Thread.currentThread().setContextClassLoader((ClassLoader)Play.classloader);
        if (args == null || args.length != 1) {
            System.out.println("jelastic.app.war is not set in application.conf or from --jelastic.app.war");
        } else {
            Jelastic jelastic = new Jelastic(args[0]);
            jelastic.startProcessing();
        }
    }

    private void startProcessing() {
        if (Command.fromString(this.command).equals((Object)Command.DEPLOY)) {
            this.deployApp();
        } else if (Command.fromString(this.command).equals((Object)Command.PUBLISH)) {
            this.publishApp();
        } else {
            System.out.println("unknown command for jelastic module");
        }
    }

    private void deployApp() {
        System.out.print("Authentication processing...");
        AuthenticationResponse authenticationResponse = this.authentication();
        if (authenticationResponse.getResult() == 0) {
            System.out.println(" : OK");
            System.out.println("File Uploading processing ...");
            UploadResponse uploadResponse = this.upload(authenticationResponse);
            if (uploadResponse.getResult() == 0) {
                System.out.println("File Uploading : OK");
                System.out.print("Registration project processing...");
                CreateObjectResponse createObjectResponse = this.createObject(uploadResponse, authenticationResponse);
                if (createObjectResponse.getResult() == 0 && createObjectResponse.getResponse().getResult() == 0) {
                    System.out.println(" : OK");
                    System.out.print("Deploy processing...");
                    DeployResponse deployResponse = this.deploy(authenticationResponse, uploadResponse);
                    if (deployResponse.getResult() == 0 && deployResponse.getResponse().getResult() == 0 && deployResponse.getResponse().getResponses()[0].getResult() == 0) {
                        System.out.println(" : OK");
                    } else {
                        System.err.println(" : " + deployResponse.getResponse().getError());
                    }
                } else {
                    System.err.println(" : " + createObjectResponse.getError());
                }
            } else {
                System.err.println(" : " + uploadResponse.getError());
            }
        } else {
            System.err.println(" : " + authenticationResponse.getError());
        }
    }

    private void publishApp() {
        System.out.print("Authentication processing...");
        AuthenticationResponse authenticationResponse = this.authentication();
        if (authenticationResponse.getResult() == 0) {
            System.out.println(" : OK");
            System.out.print("File Uploading processing ...");
            UploadResponse uploadResponse = this.upload(authenticationResponse);
            if (uploadResponse.getResult() == 0) {
                System.out.println("File Uploaded : OK");
                System.out.print("Registration File processing...");
                CreateObjectResponse createObjectResponse = this.createObject(uploadResponse, authenticationResponse);
                if (createObjectResponse.getResult() == 0 && createObjectResponse.getResponse().getResult() == 0) {
                    System.out.println(" : OK");
                } else {
                    System.err.println(" : " + createObjectResponse.getError());
                }
            } else {
                System.err.println(" : " + uploadResponse.getError());
            }
        } else {
            System.err.println(" : " + authenticationResponse.getError());
        }
    }

    private AuthenticationResponse authentication() {
        AuthenticationResponse authenticationResponse = null;
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient = Jelastic.wrapClient(httpclient);
            ArrayList<BasicNameValuePair> qparams = new ArrayList<BasicNameValuePair>();
            qparams.add(new BasicNameValuePair("login", this.config.get("login")));
            qparams.add(new BasicNameValuePair("password", this.config.get("password")));
            URI uri = URIUtils.createURI((String)this.getShema(), (String)this.config.get("apihoster"), (int)this.getPort(), (String)this.getUrlAuthentication(), (String)URLEncodedUtils.format(qparams, (String)"UTF-8"), null);
            Logger.debug((String)("Authentication url : " + uri.toString()), (Object[])new Object[0]);
            HttpGet httpGet = new HttpGet(uri);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = (String)httpclient.execute((HttpUriRequest)httpGet, (ResponseHandler)responseHandler);
            Logger.debug((String)("Authentication response : " + responseBody), (Object[])new Object[0]);
            Gson gson = new GsonBuilder().setVersion(this.version.doubleValue()).create();
            authenticationResponse = (AuthenticationResponse)gson.fromJson(responseBody, AuthenticationResponse.class);
        }
        catch (URISyntaxException e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (ClientProtocolException e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        return authenticationResponse;
    }

    public UploadResponse upload(AuthenticationResponse authenticationResponse) {
        UploadResponse uploadResponse = null;
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient = Jelastic.wrapClient(httpclient);
            httpclient.setCookieStore(this.getCookieStore());
            File file = new File(this.config.get("war_file"));
            if (!file.exists()) {
                throw new IllegalArgumentException("First build artifact and try again. Artifact not found .. ");
            }
            CustomMultiPartEntity multipartEntity = new CustomMultiPartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, new CustomMultiPartEntity.ProgressListener(){

                public void transferred(long num) {
                    if ((int)((float)num / (float)Jelastic.this.totalSize * 100.0f) != Jelastic.this.numSt) {
                        System.out.println("File Uploading : [" + (int)((float)num / (float)Jelastic.this.totalSize * 100.0f) + "%]");
                        Jelastic.this.numSt = (int)((float)num / (float)Jelastic.this.totalSize * 100.0f);
                    }
                }
            });
            multipartEntity.addPart("fid", (ContentBody)new StringBody("123456"));
            multipartEntity.addPart("session", (ContentBody)new StringBody(authenticationResponse.getSession()));
            multipartEntity.addPart("file", (ContentBody)new FileBody(file));
            this.totalSize = multipartEntity.getContentLength();
            URI uri = URIUtils.createURI((String)this.getShema(), (String)this.config.get("apihoster"), (int)this.getPort(), (String)this.getUrlUploader(), null, null);
            Logger.debug((String)("Upload url : " + uri.toString()), (Object[])new Object[0]);
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setEntity((HttpEntity)multipartEntity);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = (String)httpclient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
            Logger.debug((String)("Upload response : " + responseBody), (Object[])new Object[0]);
            Gson gson = new GsonBuilder().setVersion(this.version.doubleValue()).create();
            uploadResponse = (UploadResponse)gson.fromJson(responseBody, UploadResponse.class);
        }
        catch (URISyntaxException e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (ClientProtocolException e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        return uploadResponse;
    }

    public CreateObjectResponse createObject(UploadResponse upLoader, AuthenticationResponse authentication) {
        CreateObjectResponse createObjectResponse = null;
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient = Jelastic.wrapClient(httpclient);
            httpclient.setCookieStore(this.getCookieStore());
            ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
            nameValuePairList.add(new BasicNameValuePair("charset", "UTF-8"));
            nameValuePairList.add(new BasicNameValuePair("session", authentication.getSession()));
            nameValuePairList.add(new BasicNameValuePair("type", "JDeploy"));
            nameValuePairList.add(new BasicNameValuePair("data", "{'name':'" + upLoader.getName() + "', 'archive':'" + upLoader.getFile() + "', 'link':0, 'size':" + upLoader.getSize() + ", 'comment':'" + upLoader.getName() + "'}"));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nameValuePairList, "UTF-8");
            if (Logger.isDebugEnabled()) {
                for (NameValuePair nameValuePair : nameValuePairList) {
                    Logger.debug((String)(nameValuePair.getName() + " : " + nameValuePair.getValue()), (Object[])new Object[0]);
                }
            }
            URI uri = URIUtils.createURI((String)this.getShema(), (String)this.config.get("apihoster"), (int)this.getPort(), (String)this.getUrlCreateObject(), null, null);
            Logger.debug((String)("CreateObject url : " + uri.toString()), (Object[])new Object[0]);
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setEntity((HttpEntity)entity);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = (String)httpclient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
            Logger.debug((String)("CreateObject response : " + responseBody), (Object[])new Object[0]);
            Gson gson = new GsonBuilder().setVersion(this.version.doubleValue()).create();
            createObjectResponse = (CreateObjectResponse)gson.fromJson(responseBody, CreateObjectResponse.class);
        }
        catch (URISyntaxException e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (ClientProtocolException e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        return createObjectResponse;
    }

    public DeployResponse deploy(AuthenticationResponse authentication, UploadResponse upLoader) {
        DeployResponse deployResponse = null;
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient = Jelastic.wrapClient(httpclient);
            httpclient.setCookieStore(this.getCookieStore());
            ArrayList<BasicNameValuePair> qparams = new ArrayList<BasicNameValuePair>();
            qparams.add(new BasicNameValuePair("charset", "UTF-8"));
            qparams.add(new BasicNameValuePair("session", authentication.getSession()));
            qparams.add(new BasicNameValuePair("archiveUri", upLoader.getFile()));
            qparams.add(new BasicNameValuePair("archiveName", upLoader.getName()));
            qparams.add(new BasicNameValuePair("newContext", this.config.get("context")));
            qparams.add(new BasicNameValuePair("domain", this.config.get("environment")));
            if (Logger.isDebugEnabled()) {
                for (NameValuePair nameValuePair : qparams) {
                    Logger.debug((String)(nameValuePair.getName() + " : " + nameValuePair.getValue()), (Object[])new Object[0]);
                }
            }
            URI uri = URIUtils.createURI((String)this.getShema(), (String)this.config.get("apihoster"), (int)this.getPort(), (String)this.getUrlDeploy(), (String)URLEncodedUtils.format(qparams, (String)"UTF-8"), null);
            Logger.debug((String)("Deploy url : " + uri.toString()), (Object[])new Object[0]);
            HttpGet httpGet = new HttpGet(uri);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = (String)httpclient.execute((HttpUriRequest)httpGet, (ResponseHandler)responseHandler);
            Logger.debug((String)("Deploy response : " + responseBody), (Object[])new Object[0]);
            Gson gson = new GsonBuilder().setVersion(this.version.doubleValue()).create();
            deployResponse = (DeployResponse)gson.fromJson(responseBody, DeployResponse.class);
        }
        catch (URISyntaxException e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (ClientProtocolException e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        return deployResponse;
    }

    public static DefaultHttpClient wrapClient(DefaultHttpClient base) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx);
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = base.getConnectionManager();
            SchemeRegistry sr = ccm.getSchemeRegistry();
            sr.register(new Scheme("https", (SocketFactory)ssf, 443));
            return new DefaultHttpClient(ccm, base.getParams());
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Command {
        DEPLOY("deploy"),
        PUBLISH("publish");

        private String title;

        private Command(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public static Command fromString(String text) {
            if (text != null) {
                for (Command b : Command.values()) {
                    if (!text.equalsIgnoreCase(b.title)) continue;
                    return b;
                }
            }
            return null;
        }
    }
}

