/*
 * Decompiled with CFR 0.152.
 */
package play.modules.jersey;

import com.sun.jersey.api.container.ContainerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.modules.jersey.PlayContainer;
import play.modules.jersey.provider.DefaultJacksonProvider;
import play.modules.jersey.provider.DefaultJacksonXMLProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JerseyPlugin
extends PlayPlugin {
    public PlayContainer container;
    final Set<Class<?>> resourceClasses = new HashSet();
    public String path;
    private boolean started;
    public static final String LOG_PREP = "Jersey plugin: ";

    public void onConfigurationRead() {
        JerseyPlugin.log("Configuration read", new Object[0]);
        this.path = Play.configuration.getProperty("jersey.path");
        if (this.path == null) {
            this.path = "/rest";
        }
    }

    public void onApplicationStart() {
        try {
            if (!this.started) {
                JerseyPlugin.log("Starting Jersey", new Object[0]);
                this.createContainer();
                JerseyPlugin.log("Jersey started", new Object[0]);
                this.started = true;
            } else if (Play.mode != Play.Mode.PROD) {
                this.createContainer();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    private void createContainer() {
        this.resourceClasses.clear();
        List classes = Play.classes.all();
        JerseyPlugin.log("Default Providers: " + DefaultJacksonProvider.class.getName() + ", " + DefaultJacksonXMLProvider.class.getName(), new Object[0]);
        this.resourceClasses.add(DefaultJacksonProvider.class);
        this.resourceClasses.add(DefaultJacksonXMLProvider.class);
        for (ApplicationClasses.ApplicationClass ac : classes) {
            if (!this.isRessource(ac.javaClass)) continue;
            JerseyPlugin.log("Discovered Ressource class: " + ac.javaClass, new Object[0]);
            this.resourceClasses.add(ac.javaClass);
        }
        this.container = (PlayContainer)ContainerFactory.createContainer(PlayContainer.class, this.resourceClasses);
    }

    private boolean isRessource(Class<?> javaClass) {
        if (javaClass.isInterface() || Modifier.isAbstract(javaClass.getModifiers())) {
            return false;
        }
        return this.hasAnnotation(javaClass, Path.class) || this.hasAnnotation(javaClass, Provider.class);
    }

    private boolean hasAnnotation(Class<?> type, Class<? extends Annotation> annotation) {
        if (type == null) {
            return false;
        }
        if (type.isAnnotationPresent(annotation)) {
            return true;
        }
        for (Class<?> interfaceType : type.getInterfaces()) {
            if (!this.hasAnnotation(interfaceType, annotation)) continue;
            return true;
        }
        return this.hasAnnotation(type.getSuperclass(), annotation);
    }

    public static void log(String message, Object ... params) {
        Logger.info((String)(LOG_PREP + message), (Object[])params);
    }
}

