/*
 * Decompiled with CFR 0.152.
 */
package play.modules.jersey;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.spi.container.ContainerListener;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.WebApplication;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import play.mvc.Http;
import play.mvc.results.Error;
import play.mvc.results.Forbidden;
import play.mvc.results.NotFound;

public final class PlayContainer
implements ContainerListener {
    private WebApplication application;

    public PlayContainer(WebApplication application) throws ContainerException {
        this.application = application;
    }

    public void handle(Http.Request request, Http.Response response) {
        WebApplication target = this.application;
        try {
            URI baseUri = new URI(request.getBase() + "/");
            URI requestUri = baseUri.resolve(request.url);
            ContainerRequest cRequest = new ContainerRequest(target, request.method, baseUri, requestUri, this.getHeaders(request), request.body);
            target.handleRequest(cRequest, (ContainerResponseWriter)new Writer(request, response));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.close(response);
        }
    }

    private void close(Http.Response response) {
        try {
            response.out.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private InBoundHeaders getHeaders(Http.Request request) {
        InBoundHeaders header = new InBoundHeaders();
        for (Map.Entry e : request.headers.entrySet()) {
            for (String h : ((Http.Header)e.getValue()).values) {
                header.add((String)e.getKey(), (Object)h);
            }
        }
        return header;
    }

    public void onReload() {
        WebApplication oldApplication = this.application;
        this.application = this.application.clone();
        oldApplication.destroy();
    }

    private static final class Writer
    implements ContainerResponseWriter {
        final Http.Response response;
        final Http.Request request;

        Writer(Http.Request request, Http.Response response) {
            this.response = response;
            this.request = request;
        }

        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse cResponse) throws IOException {
            int code = cResponse.getStatus();
            String method = this.request.method;
            this.response.status = code;
            switch (code) {
                case 404: {
                    throw new NotFound(method, this.request.path);
                }
                case 500: {
                    throw new Error(cResponse.getStatusType().getReasonPhrase());
                }
                case 403: {
                    throw new Forbidden("Forbidden");
                }
            }
            for (Map.Entry e : cResponse.getHttpHeaders().entrySet()) {
                for (Object value : (List)e.getValue()) {
                    this.response.setHeader((String)e.getKey(), ContainerResponse.getHeaderValue(value));
                }
            }
            return this.response.out;
        }

        public void finish() throws IOException {
            this.response.out.close();
        }
    }
}

