/*
 * Decompiled with CFR 0.152.
 */
package play.modules.jersey.provider;

import com.fasterxml.jackson.xml.XmlMapper;
import com.fasterxml.jackson.xml.util.DefaultXmlPrettyPrinter;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.VisibilityChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Singleton
public class DefaultJacksonXMLProvider
implements MessageBodyWriter<Object> {
    XmlMapper mapper;

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE) || mediaType.isCompatible(MediaType.TEXT_XML_TYPE);
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.getMapper().configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        this.getMapper().writeValue(entityStream, t);
    }

    private XmlMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new XmlMapper();
            this.mapper.prettyPrintingWriter((PrettyPrinter)new DefaultXmlPrettyPrinter());
            this.mapper.disableDefaultTyping();
            DeserializationConfig deserializationConfig = this.mapper.getDeserializationConfig();
            deserializationConfig.enable(DeserializationConfig.Feature.AUTO_DETECT_FIELDS);
            this.mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
            this.mapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
            this.mapper.setVisibilityChecker((VisibilityChecker)VisibilityChecker.Std.defaultInstance().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        }
        return this.mapper;
    }
}

