/**
 * Copyright (c) 2011 Piero Sartini
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package controllers;

import play.Logger;
import play.Play;
import play.modules.jersey.JerseyPlugin;
import play.modules.jersey.PlayContainer;
import play.mvc.Controller;

/**
 * @author Piero Sartini
 */
public class JerseyController extends Controller {
    public static void serve() {
        Logger.debug("Jersey controller invoked: %s", request.url);
        JerseyPlugin plugin = Play.plugin(JerseyPlugin.class);
        PlayContainer container = plugin.container;
        container.handle(request, response);
    }
}
