/**
 * Copyright (c) 2011 Piero Sartini
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package play.modules.jersey.provider;

import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import javax.ws.rs.ext.Provider;

/**
 * @author Piero Sartini
 */
@Provider
public class DefaultJacksonProvider extends JacksonJsonProvider {
	public DefaultJacksonProvider() {
		super();
		_mapperConfig.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
		_mapperConfig.configure(SerializationConfig.Feature.WRITE_ENUMS_USING_TO_STRING, true);
		_mapperConfig.configure(DeserializationConfig.Feature.READ_ENUMS_USING_TO_STRING, true);
		_mapperConfig.getConfiguredMapper().getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
	}
}
