/**
 * Copyright (c) 2011 Piero Sartini
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package play.modules.jersey.provider;

import com.fasterxml.jackson.xml.XmlMapper;
import com.fasterxml.jackson.xml.util.DefaultXmlPrettyPrinter;
import com.sun.jersey.spi.resource.Singleton;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.*;
import org.codehaus.jackson.map.introspect.VisibilityChecker;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

/**
 * @author Piero Sartini
 */
@Provider @Singleton
public class DefaultJacksonXMLProvider implements MessageBodyWriter<Object> {
	XmlMapper mapper;

	public long getSize(final Object t, final Class<?> type, final Type genericType,
	                    final Annotation[] annotations, final MediaType mediaType) {
		return -1;
	}

	public boolean isWriteable(final Class<?> type, final Type genericType,
	                           final Annotation[] annotations, final MediaType mediaType) {
		return mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE) ||
				mediaType.isCompatible(MediaType.TEXT_XML_TYPE);
	}

	public void writeTo(final Object t, final Class<?> type, final Type genericType,
	                    final Annotation[] annotations, final MediaType mediaType,
	                    final MultivaluedMap<String, Object> httpHeaders,
	                    final OutputStream entityStream) throws IOException, WebApplicationException {
		getMapper().configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
		getMapper().writeValue(entityStream, t);

	}

	private XmlMapper getMapper() {
		if (mapper == null) {
			mapper = new XmlMapper();
			mapper.prettyPrintingWriter(new DefaultXmlPrettyPrinter());
			//mapper = new ObjectMapper(new J);
			mapper.disableDefaultTyping(); //enableDefaultTyping(); // defaults for defaults (see below); include as wrapper-array, non-concrete types
			//mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_CONCRETE_AND_ARRAYS, JsonTypeInfo.As.WRAPPER_OBJECT); // all non-final types
			//mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES,);
			DeserializationConfig deserializationConfig = mapper.getDeserializationConfig();
			deserializationConfig.enable(DeserializationConfig.Feature.AUTO_DETECT_FIELDS);
			mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
			mapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
			mapper.setVisibilityChecker(VisibilityChecker.Std.defaultInstance()
					.withFieldVisibility(JsonAutoDetect.Visibility.ANY)
					.withGetterVisibility(JsonAutoDetect.Visibility.NONE)
					.withSetterVisibility(JsonAutoDetect.Visibility.NONE)
					.withIsGetterVisibility(JsonAutoDetect.Visibility.NONE)
					.withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
			//Version v = mapper.version();
			//logger.finest("Initialized RedisJacksonCache with Jackson Version: " + v);
		}
		return mapper;
	}
}
