/*
 * Decompiled with CFR 0.152.
 */
package play.modules.jpagen;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Pattern;
import play.Logger;
import play.Play;
import play.libs.IO;
import play.modules.jpagen.SimpleDB;
import play.templates.BaseTemplate;
import play.templates.GroovyTemplateCompiler;
import play.vfs.VirtualFile;

public class ListGenerator {
    public static void main(String[] args) throws Exception {
        try {
            File root = new File(System.getProperty("application.path"));
            Play.init((File)root, (String)System.getProperty("play.id", ""));
            Thread.currentThread().setContextClassLoader((ClassLoader)Play.classloader);
            String driver = Play.configuration.getProperty("db.driver");
            String url = Play.configuration.getProperty("db.url");
            String user = Play.configuration.getProperty("db.user");
            String password = Play.configuration.getProperty("db.pass", "");
            String[] excludePattern = Play.configuration.getProperty("jpagen.excludes", "").split(",");
            String[] includePattern = Play.configuration.getProperty("jpagen.includes", "").split(",");
            Logger.info((String)"Exclude pattern: %s", (Object[])new Object[]{Arrays.asList(excludePattern)});
            Logger.info((String)"Include pattern: %s", (Object[])new Object[]{Arrays.asList(includePattern)});
            String temp = Play.configuration.getProperty("db.default.schema", "");
            String[] schemas = null;
            schemas = temp.split(",");
            String templateListPath = Play.configuration.getProperty("jpagen.template.list", "jpagen/list.tmpl");
            Logger.info((String)"driver: %s url: %s user: %s password: %s", (Object[])new Object[]{driver, url, user, password});
            SimpleDB db = new SimpleDB(driver, url, user, password);
            Connection con = db.getConnection();
            VirtualFile templateListFile = VirtualFile.search((Collection)Play.templatesPath, (String)templateListPath);
            Logger.info((String)"templateFile: %s", (Object[])new Object[]{templateListFile.getName()});
            GroovyTemplateCompiler compiler = new GroovyTemplateCompiler();
            BaseTemplate listTemplate = compiler.compile(templateListFile);
            DatabaseMetaData meta = con.getMetaData();
            ArrayList<String> tableList = new ArrayList<String>();
            for (String schema : schemas) {
                ResultSet rs = meta.getTables(null, schema, null, new String[]{"TABLE"});
                while (rs.next()) {
                    boolean bExclude = false;
                    boolean bInclude = true;
                    String table = null;
                    table = schema.length() > 0 ? schema + "." + rs.getString("TABLE_NAME").trim() : rs.getString("TABLE_NAME").trim();
                    if (excludePattern != null && excludePattern.length > 0) {
                        for (String exclude : excludePattern) {
                            if (exclude.length() <= 0 || !Pattern.compile(Pattern.quote(exclude)).matcher(table).find()) continue;
                            bExclude = true;
                            Logger.info((String)"Table %s excluded", (Object[])new Object[]{table});
                        }
                    }
                    if (includePattern != null && includePattern.length > 0) {
                        if (bExclude) {
                            bInclude = false;
                        } else {
                            for (String include : includePattern) {
                                if (include.length() <= 0 || Pattern.compile(Pattern.quote(include)).matcher(table).find()) continue;
                                Logger.info((String)"Table %s excluded", (Object[])new Object[]{table});
                                bInclude = false;
                            }
                        }
                    }
                    if (bExclude || !bInclude) continue;
                    tableList.add(table);
                    Logger.info((String)"Added table %s", (Object[])new Object[]{table});
                }
                Collections.sort(tableList);
                rs.close();
            }
            db.close();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("url", url);
            params.put("tables", tableList);
            String output = listTemplate.render(params);
            String relativePath = "conf/table_list.conf";
            if (!VirtualFile.fromRelativePath((String)relativePath).exists()) {
                File entityFile = VirtualFile.fromRelativePath((String)relativePath).getRealFile();
                IO.writeContent((CharSequence)output, (File)entityFile);
                Logger.info((String)"Process finished: Generated conf/table_list.conf with %s tables", (Object[])new Object[]{tableList.size()});
            } else {
                Logger.warn((String)"File %s already exists...NOT OVERWRITING", (Object[])new Object[]{relativePath});
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        System.exit(0);
    }
}

