/*
 * Decompiled with CFR 0.152.
 */
package play.modules.jpagen;

import com.mchange.v2.c3p0.DriverManagerDataSourceFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import play.exceptions.DatabaseException;

public class SimpleDB {
    public DataSource datasource = null;
    ThreadLocal<Connection> localConnection = new ThreadLocal();

    public SimpleDB(String driver, String url, String user, String password) {
        try {
            Class.forName(driver);
            this.datasource = DriverManagerDataSourceFactory.create((String)driver, (String)url, (String)user, (String)password);
        }
        catch (Exception e) {
            throw new RuntimeException("ERROR: Can't get connection: ", e);
        }
    }

    public void close() {
        if (this.localConnection.get() != null) {
            try {
                Connection connection = this.localConnection.get();
                this.localConnection.set(null);
                connection.close();
            }
            catch (Exception e) {
                throw new DatabaseException("It's possible than the connection was not properly closed !", (Throwable)e);
            }
        }
    }

    public Connection getConnection() {
        try {
            if (this.localConnection.get() != null) {
                return this.localConnection.get();
            }
            Connection connection = this.datasource.getConnection();
            this.localConnection.set(connection);
            return connection;
        }
        catch (SQLException ex) {
            throw new DatabaseException("Cannot obtain a new connection (" + ex.getMessage() + ")", (Throwable)ex);
        }
        catch (NullPointerException e) {
            if (this.datasource == null) {
                throw new DatabaseException("No database found. Check the configuration of your application.", (Throwable)e);
            }
            throw e;
        }
    }

    public boolean execute(String SQL) {
        try {
            return this.getConnection().createStatement().execute(SQL);
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex.getMessage(), (Throwable)ex);
        }
    }

    public ResultSet executeQuery(String SQL) {
        try {
            return this.getConnection().createStatement().executeQuery(SQL);
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex.getMessage(), (Throwable)ex);
        }
    }
}

