/*
 * Decompiled with CFR 0.152.
 */
package play.modules.jpagen;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import play.Logger;
import play.Play;
import play.libs.IO;
import play.modules.jpagen.Column;
import play.modules.jpagen.IdClass;
import play.modules.jpagen.ModeEnum;
import play.modules.jpagen.SimpleDB;
import play.modules.jpagen.Table;
import play.templates.BaseTemplate;
import play.templates.GroovyTemplateCompiler;
import play.templates.JavaExtensions;
import play.vfs.VirtualFile;

public class Generator {
    private static List<String> keyword = new ArrayList<String>();

    public static void main(String[] args) throws Exception {
        Generator.init();
        try {
            String mode;
            File root = new File(System.getProperty("application.path"));
            Play.init((File)root, (String)System.getProperty("play.id", ""));
            Thread.currentThread().setContextClassLoader((ClassLoader)Play.classloader);
            String driver = Play.configuration.getProperty("db.driver");
            String url = Play.configuration.getProperty("db.url");
            String user = Play.configuration.getProperty("db.user");
            String password = Play.configuration.getProperty("db.pass", "");
            String temp = Play.configuration.getProperty("db.default.schema", "");
            String[] schemas = null;
            if (temp.length() > 0) {
                schemas = temp.split(",");
            }
            if ((mode = Play.configuration.getProperty("jpagen.mode")) == null || mode.trim().length() == 0) {
                throw new ExceptionInInitializerError("ERROR: Parameter jpagen.mode is mandatory!");
            }
            if (ModeEnum.valueOf(mode.toUpperCase()) == null) {
                throw new ExceptionInInitializerError("ERROR: Parameter jpagen.mode provided is not supported: MYSQL or ORACLE only!");
            }
            String packageName = Play.configuration.getProperty("jpagen.package.name", "models");
            String templatePath = Play.configuration.getProperty("jpagen.template.entity", "jpagen/entity.tmpl");
            String templateIdPath = Play.configuration.getProperty("jpagen.template.idClass", "jpagen/idClass.tmpl");
            Logger.info((String)"driver: %s url: %s user: %s password: %s", (Object[])new Object[]{driver, url, user, password});
            SimpleDB db = new SimpleDB(driver, url, user, password);
            Connection con = db.getConnection();
            VirtualFile templateFile = VirtualFile.search((Collection)Play.templatesPath, (String)templatePath);
            Logger.info((String)"templateFile: %s", (Object[])new Object[]{templateFile.getName()});
            GroovyTemplateCompiler compiler1 = new GroovyTemplateCompiler();
            BaseTemplate entityTemplate = compiler1.compile(templateFile);
            VirtualFile templateIdFile = VirtualFile.search((Collection)Play.templatesPath, (String)templateIdPath);
            Logger.info((String)"templateIdFile: %s", (Object[])new Object[]{templateIdFile.getName()});
            GroovyTemplateCompiler compiler2 = new GroovyTemplateCompiler();
            BaseTemplate idTemplate = compiler2.compile(templateIdFile);
            DatabaseMetaData meta = con.getMetaData();
            List<String> tableList = new ArrayList();
            if (Play.getVirtualFile((String)"conf/table_list.conf").exists()) {
                Logger.info((String)"Using table_list.conf", (Object[])new Object[0]);
                tableList = IO.readLines((File)Play.getFile((String)"conf/table_list.conf"));
                Logger.info((String)"TableList contains %s lines (including comments and empty lines)", (Object[])new Object[]{tableList.size()});
            } else {
                Logger.info((String)"Using metadata", (Object[])new Object[0]);
                ResultSet rs = null;
                if (schemas != null) {
                    for (String schema : schemas) {
                        rs = meta.getTables(null, schema, null, new String[]{"TABLE"});
                        while (rs.next()) {
                            tableList.add(schema + "." + rs.getString("TABLE_NAME"));
                        }
                        rs.close();
                    }
                } else {
                    rs = meta.getTables(null, null, null, new String[]{"TABLE"});
                    while (rs.next()) {
                        tableList.add(rs.getString("TABLE_NAME"));
                    }
                    rs.close();
                }
            }
            int count = 0;
            int idCount = 0;
            int skipCount = 0;
            int skipIdCount = 0;
            for (String tableName : tableList) {
                String relativePath;
                if (tableName == null || tableName.trim().length() == 0 || tableName.startsWith("#")) {
                    Logger.debug((String)"skipping line...", (Object[])new Object[0]);
                    continue;
                }
                String schema = "";
                if (tableName.indexOf(".") > 0) {
                    Logger.info((String)"tableName: %s", (Object[])new Object[]{tableName});
                    String[] names = tableName.split("\\.");
                    Logger.debug((String)"%s", (Object[])new Object[]{Arrays.asList(names)});
                    schema = names[0];
                    tableName = names[1];
                } else {
                    Logger.info((String)"No schema for table %s", (Object[])new Object[]{tableName});
                }
                Logger.debug((String)"Working on table %s", (Object[])new Object[]{schema + "." + tableName});
                Table table = new Table();
                table.tableName = tableName;
                table.packageName = packageName;
                table.className = JavaExtensions.camelCase((String)table.tableName.replaceAll("_", " "));
                ArrayList<String> keys = new ArrayList<String>();
                ResultSet rsKeys = meta.getPrimaryKeys(null, schema.length() == 0 ? null : schema, tableName);
                while (rsKeys.next()) {
                    String key = rsKeys.getString("COLUMN_NAME");
                    keys.add(key);
                    Logger.info((String)"Table: %s, primaryKey: %s", (Object[])new Object[]{(schema.length() > 0 ? schema + "." : "") + tableName, key});
                }
                rsKeys.close();
                if (keys.size() == 0) {
                    table.isIdLess = true;
                    table.extend = "Model";
                }
                PreparedStatement ps = null;
                if (mode.equalsIgnoreCase(ModeEnum.MYSQL.name())) {
                    ps = con.prepareStatement("select * from " + (schema.length() > 0 ? schema + "." : "") + tableName + " limit 0");
                }
                if (mode.equalsIgnoreCase(ModeEnum.ORACLE.name())) {
                    ps = con.prepareStatement("select * from " + (schema.length() > 0 ? schema + "." : "") + tableName + " where rownum < 2");
                }
                ResultSet rs = ps.executeQuery();
                ResultSetMetaData tm = rs.getMetaData();
                IdClass idClass = new IdClass();
                idClass.className = table.className + "Id";
                idClass.packageName = table.packageName;
                int cc = tm.getColumnCount();
                for (int i = 1; i <= cc; ++i) {
                    Column column = new Column();
                    column.columnName = tm.getColumnName(i);
                    column.columnType = tm.getColumnClassName(i).substring(tm.getColumnClassName(i).lastIndexOf(".") + 1);
                    if (column.columnType.equals("[B")) {
                        Logger.error((String)"BLOB??? %s", (Object[])new Object[]{tm.getColumnClassName(i)});
                        column.columnType = "Blob";
                    }
                    if (column.columnType.equals("String")) {
                        column.max = tm.getPrecision(i);
                    }
                    column.columnPropertyName = JavaExtensions.camelCase((String)column.columnName.toLowerCase().replaceAll("_", " "));
                    column.columnPropertyName = Generator.normalizeColumnName(column.columnPropertyName.substring(0, 1).toLowerCase() + column.columnPropertyName.substring(1));
                    if (tm.isNullable(i) == 0) {
                        column.nullable = false;
                    }
                    if (keys.contains(column.columnName)) {
                        column.primary = true;
                        if (keys.size() > 1) {
                            idClass.keys.add(column);
                        }
                    }
                    if (column.columnPropertyName.equals("id")) {
                        table.extend = "GenericModel";
                    }
                    table.columns.add(column);
                }
                rs.close();
                ps.close();
                if (keys.size() > 1) {
                    table.idClass = table.className + "Id.class";
                    Logger.info((String)"Key: %s", (Object[])new Object[]{idClass.className});
                    String relativePath2 = "app/" + packageName.replace('.', '/') + "/" + table.className + "Id.java";
                    if (!VirtualFile.fromRelativePath((String)relativePath2).exists()) {
                        File idFile = VirtualFile.fromRelativePath((String)relativePath2).getRealFile();
                        HashMap<String, IdClass> params = new HashMap<String, IdClass>();
                        params.put("idClass", idClass);
                        String output = idTemplate.render(params);
                        IO.writeContent((CharSequence)output, (File)idFile);
                        ++idCount;
                    } else {
                        ++skipIdCount;
                        Logger.warn((String)"File %s already exists...NOT OVERWRITING", (Object[])new Object[]{relativePath2});
                    }
                }
                if (!VirtualFile.fromRelativePath((String)(relativePath = "app/" + packageName.replace('.', '/') + "/" + table.className + ".java")).exists()) {
                    HashMap<String, Table> params = new HashMap<String, Table>();
                    params.put("table", table);
                    String output = entityTemplate.render(params);
                    File entityFile = VirtualFile.fromRelativePath((String)relativePath).getRealFile();
                    IO.writeContent((CharSequence)output, (File)entityFile);
                    ++count;
                } else {
                    ++skipCount;
                    Logger.warn((String)"File %s already exists...NOT OVERWRITING", (Object[])new Object[]{relativePath});
                }
                Logger.debug((String)"Table done: %s", (Object[])new Object[]{tableName});
            }
            db.close();
            Logger.info((String)"Process finished: %s Entities and %s Composite Keys generated", (Object[])new Object[]{count, idCount});
            Logger.warn((String)"%s Entities and %s Composite Keys SKIPPED", (Object[])new Object[]{skipCount, skipIdCount});
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        System.exit(0);
    }

    private static String normalizeColumnName(String column) {
        if (keyword.contains(column)) {
            return column + "Col";
        }
        return column;
    }

    private static void init() {
        keyword.add("abstract");
        keyword.add("assert");
        keyword.add("boolean");
        keyword.add("break");
        keyword.add("byte");
        keyword.add("case");
        keyword.add("catch");
        keyword.add("char");
        keyword.add("class");
        keyword.add("const");
        keyword.add("continue");
        keyword.add("default");
        keyword.add("do");
        keyword.add("double");
        keyword.add("else");
        keyword.add("entityId");
        keyword.add("enum");
        keyword.add("extends");
        keyword.add("final");
        keyword.add("finally");
        keyword.add("float");
        keyword.add("for");
        keyword.add("goto");
        keyword.add("if");
        keyword.add("implements");
        keyword.add("import");
        keyword.add("instanceof");
        keyword.add("int");
        keyword.add("interface");
        keyword.add("long");
        keyword.add("native");
        keyword.add("new");
        keyword.add("package");
        keyword.add("private");
        keyword.add("protected");
        keyword.add("public");
        keyword.add("return");
        keyword.add("short");
        keyword.add("static");
        keyword.add("strictfp");
        keyword.add("super");
        keyword.add("switch");
        keyword.add("synchronized");
        keyword.add("this");
        keyword.add("throw");
        keyword.add("throws");
        keyword.add("transient");
        keyword.add("try");
        keyword.add("void");
        keyword.add("volatile");
        keyword.add("while");
    }
}

