/*
 * Decompiled with CFR 0.152.
 */
package play.modules.jpastats;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.hibernate.Session;
import org.hibernate.stat.Statistics;
import play.Play;
import play.PlayPlugin;
import play.db.jpa.JPA;
import play.mvc.Http;

public class JPAStatsPlugin
extends PlayPlugin {
    private static ThreadLocal<Long> databaseQueryCount = new ThreadLocal();
    private static ThreadLocal<Long> hibernateQueryCount = new ThreadLocal();
    private static ThreadLocal<Long> collectionFetchCount = new ThreadLocal();
    private static ThreadLocal<Long> entityFetchCount = new ThreadLocal();
    private static ThreadLocal<Statistics> statistics = new ThreadLocal();
    private boolean enabled;
    private boolean headers;

    public void onConfigurationRead() {
        this.enabled = Boolean.valueOf(Play.configuration.getProperty("jpastats.enabled", "true"));
        this.headers = Boolean.valueOf(Play.configuration.getProperty("jpastats.headers", "false"));
    }

    public void beforeActionInvocation(Method m) {
        if (this.enabled) {
            Statistics stats = ((Session)JPA.em().getDelegate()).getSessionFactory().getStatistics();
            stats.setStatisticsEnabled(true);
            statistics.set(stats);
        }
        databaseQueryCount.set(JPAStatsPlugin.currentDatabaseQueryCount());
        hibernateQueryCount.set(JPAStatsPlugin.currentHibernateQueryCount());
        collectionFetchCount.set(JPAStatsPlugin.currentCollectionFetchCount());
        entityFetchCount.set(JPAStatsPlugin.currentEntityFetchCount());
    }

    public void afterActionInvocation() {
        if (this.headers) {
            this.addHeadersToResponse();
        }
    }

    private void addHeadersToResponse() {
        ArrayList<Http.Header> headers = new ArrayList<Http.Header>(4);
        headers.add(new Http.Header("X-Database-Queries", new Long(JPAStatsPlugin.getDatabaseQueryCount()).toString()));
        headers.add(new Http.Header("X-Hibernate-Queries", new Long(JPAStatsPlugin.getHibernateQueryCount()).toString()));
        headers.add(new Http.Header("X-Collection-Fetches", new Long(JPAStatsPlugin.getCollectionFetchCount()).toString()));
        headers.add(new Http.Header("X-Entity-Fetches", new Long(JPAStatsPlugin.getEntityFetchCount()).toString()));
        for (Http.Header header : headers) {
            Http.Response.current().headers.put(header.name, header);
        }
    }

    public static long getDatabaseQueryCount() {
        return JPAStatsPlugin.currentDatabaseQueryCount() - databaseQueryCount.get();
    }

    public static long getHibernateQueryCount() {
        return JPAStatsPlugin.currentHibernateQueryCount() - hibernateQueryCount.get();
    }

    public static long getCollectionFetchCount() {
        return JPAStatsPlugin.currentCollectionFetchCount() - collectionFetchCount.get();
    }

    public static long getEntityFetchCount() {
        return JPAStatsPlugin.currentEntityFetchCount() - entityFetchCount.get();
    }

    protected static long currentDatabaseQueryCount() {
        try {
            return statistics.get().getPrepareStatementCount();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    protected static long currentHibernateQueryCount() {
        try {
            return statistics.get().getQueryExecutionCount();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    protected static long currentCollectionFetchCount() {
        try {
            return statistics.get().getCollectionFetchCount();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    protected static long currentEntityFetchCount() {
        try {
            return statistics.get().getEntityFetchCount();
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

