/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import siena.BaseQuery;
import siena.BaseQueryData;
import siena.PersistenceManager;
import siena.Query;
import siena.core.BaseMany;
import siena.core.BaseOne;
import siena.core.Many4PM;
import siena.core.One4PM;
import siena.core.SienaIterablePerPage;
import siena.core.batch.BaseBatch;
import siena.core.batch.Batch;
import siena.core.options.PmOption;
import siena.core.options.QueryOption;
import siena.core.options.QueryOptionFetchType;
import siena.core.options.QueryOptionOffset;

public abstract class AbstractPersistenceManager
implements PersistenceManager {
    protected ThreadLocal<Map<Integer, PmOption>> options = new ThreadLocal();

    @Override
    public <T> Query<T> createQuery(Class<T> clazz) {
        return new BaseQuery<T>((PersistenceManager)this, clazz);
    }

    @Override
    public <T> Query<T> createQuery(BaseQueryData<T> data) {
        return new BaseQuery<T>((PersistenceManager)this, data);
    }

    @Override
    public <T> Batch<T> createBatch(Class<T> clazz) {
        return new BaseBatch<T>(this, clazz);
    }

    @Override
    public PersistenceManager option(PmOption opt) {
        Map<Integer, PmOption> map = this.options.get();
        if (map == null) {
            map = new HashMap<Integer, PmOption>();
            this.options.set(map);
        }
        map.put(opt.type, opt);
        return this;
    }

    @Override
    public PmOption option(int type) {
        Map<Integer, PmOption> map = this.options.get();
        if (map == null) {
            return null;
        }
        return map.get(type);
    }

    @Override
    public Map<Integer, PmOption> options() {
        return this.options.get();
    }

    @Override
    public void resetOptions() {
        this.options.remove();
    }

    @Override
    public <T> Many4PM<T> createMany(Class<T> clazz) {
        return new BaseMany<T>(this, clazz);
    }

    @Override
    public <T> One4PM<T> createOne(Class<T> clazz) {
        return new BaseOne<T>(this, clazz);
    }

    @Override
    public <T> T get(Query<T> query) {
        List<T> list = this.fetch(query, 1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <T> void release(Query<T> query) {
        QueryOptionOffset offset = (QueryOptionOffset)query.option(2);
        QueryOption state = query.option(3);
        if (offset.isActive()) {
            offset.offset = 0;
        }
        if (state.isActive()) {
            state.passivate();
        }
    }

    @Override
    public <T> Iterable<T> iterPerPage(Query<T> query, int pageSize) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER_PER_PAGE;
        return new SienaIterablePerPage<T>(query, pageSize);
    }

    @Override
    @Deprecated
    public <T> int count(Query<T> query, int limit) {
        return this.fetch(query, limit).size();
    }

    @Override
    @Deprecated
    public <T> int count(Query<T> query, int limit, Object offset) {
        return this.fetch(query, limit, offset).size();
    }
}

