/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Text;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import siena.ClassInfo;
import siena.Json;
import siena.SienaException;
import siena.Util;
import siena.core.DecimalPrecision;
import siena.embed.Embedded;
import siena.embed.JavaSerializer;
import siena.embed.JsonSerializer;
import siena.gae.GaeMappingUtils;
import siena.gae.Unindexed;

public class GaeNativeSerializer {
    public static void embed(Entity entity, String embeddingColumnName, Object embeddedObj, int level) {
        if (level > 2) {
            return;
        }
        Class<?> clazz = embeddedObj.getClass();
        if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
            throw new SienaException("can't serializer Array/Collection in native mode");
        }
        block11: for (Field f : ClassInfo.getClassInfo(clazz).allFields) {
            Unindexed ui;
            Object propValue;
            String propName;
            block25: {
                Class<?> fieldClass;
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                fieldClass = f.getType();
                                propName = String.valueOf(embeddingColumnName) + "." + ClassInfo.getSingleColumnName(f);
                                propValue = Util.readField(embeddedObj, f);
                                if (propValue == null) break block25;
                                if (fieldClass != Json.class) break block26;
                                propValue = propValue.toString();
                                break block25;
                            }
                            if (!(propValue instanceof String)) break block27;
                            String s = (String)propValue;
                            if (s.length() > 500) {
                                propValue = new Text(s);
                            }
                            break block25;
                        }
                        if (!(propValue instanceof byte[])) break block28;
                        byte[] arr = (byte[])propValue;
                        propValue = arr.length < 1000000 ? new Blob(arr) : new Blob(Arrays.copyOf(arr, 1000000));
                        break block25;
                    }
                    if (!ClassInfo.isEmbedded(f)) break block29;
                    Embedded embed = f.getAnnotation(Embedded.class);
                    switch (embed.mode()) {
                        case SERIALIZE_JSON: {
                            propValue = JsonSerializer.serialize(propValue).toString();
                            String s = (String)propValue;
                            if (s.length() > 500) {
                                propValue = new Text(s);
                                break;
                            }
                            break block25;
                        }
                        case SERIALIZE_JAVA: {
                            try {
                                byte[] b = JavaSerializer.serialize(propValue);
                                if (b.length > 1000000) {
                                    throw new SienaException("object can be java serialized because it's too large >1mb");
                                }
                                propValue = new Blob(b);
                                break block25;
                            }
                            catch (IOException ex) {
                                throw new SienaException(ex);
                            }
                        }
                        case NATIVE: {
                            GaeNativeSerializer.embed(entity, String.valueOf(embeddingColumnName) + "." + ClassInfo.getSingleColumnName(f), propValue, level + 1);
                            continue block11;
                        }
                    }
                    break block25;
                }
                if (fieldClass == BigDecimal.class) {
                    DecimalPrecision ann = f.getAnnotation(DecimalPrecision.class);
                    if (ann == null) {
                        propValue = ((BigDecimal)propValue).toPlainString();
                    } else {
                        switch (ann.storageType()) {
                            case DOUBLE: {
                                propValue = ((BigDecimal)propValue).doubleValue();
                                break;
                            }
                            case NATIVE: 
                            case STRING: {
                                propValue = ((BigDecimal)propValue).toPlainString();
                            }
                        }
                    }
                } else if (Enum.class.isAssignableFrom(fieldClass)) {
                    propValue = propValue.toString();
                } else if (ClassInfo.isModel(fieldClass)) {
                    propValue = Util.readField(propValue, ClassInfo.getIdField(fieldClass));
                }
            }
            if ((ui = f.getAnnotation(Unindexed.class)) == null) {
                entity.setProperty(propName, propValue);
                continue;
            }
            entity.setUnindexedProperty(propName, propValue);
        }
    }

    public static <T> T unembed(Class<T> clazz, String embeddingFieldName, Entity entity, int level) {
        if (level > 2) {
            return null;
        }
        if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
            throw new SienaException("can't serializer Array/Collection in native mode");
        }
        T obj = Util.createObjectInstance(clazz);
        try {
            for (Field f : ClassInfo.getClassInfo(clazz).allFields) {
                String propName = String.valueOf(embeddingFieldName) + "." + ClassInfo.getSingleColumnName(f);
                Object propValue = entity.getProperty(propName);
                if (ClassInfo.isEmbedded(f) && f.getAnnotation(Embedded.class).mode() == Embedded.Mode.NATIVE) {
                    Object value = GaeNativeSerializer.unembed(f.getType(), String.valueOf(embeddingFieldName) + "." + ClassInfo.getSingleColumnName(f), entity, level + 1);
                    Util.setField(obj, f, value);
                    continue;
                }
                if (ClassInfo.isModel(f.getType())) {
                    Class<?> fieldClass = f.getType();
                    Object value = Util.createObjectInstance(fieldClass);
                    Util.setField(value, ClassInfo.getIdField(fieldClass), propValue);
                    Util.setField(obj, f, value);
                    continue;
                }
                GaeMappingUtils.setFromObject(obj, f, propValue);
            }
            return obj;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }
}

