/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.Entity;
import java.util.List;
import siena.core.async.QueryAsync;
import siena.core.async.SienaFuture;
import siena.core.options.QueryOptionPage;
import siena.gae.GaeMappingUtils;
import siena.gae.GaePersistenceManagerAsync;
import siena.gae.QueryOptionGaeContext;

public class GaeSienaFutureListMapper<T>
implements SienaFuture<List<T>> {
    Iterable<Entity> entities;
    QueryAsync<T> query;
    GaePersistenceManagerAsync pm;
    MapType mapType = MapType.ALL;

    public GaeSienaFutureListMapper(GaePersistenceManagerAsync pm, Iterable<Entity> entities, QueryAsync<T> query) {
        this.entities = entities;
        this.query = query;
        this.pm = pm;
    }

    public GaeSienaFutureListMapper(GaePersistenceManagerAsync pm, Iterable<Entity> entities, QueryAsync<T> query, MapType mapType) {
        this.entities = entities;
        this.query = query;
        this.pm = pm;
        this.mapType = mapType;
    }

    @Override
    public List<T> get() {
        List results;
        switch (this.mapType) {
            case KEYS_ONLY: {
                results = GaeMappingUtils.mapEntitiesKeysOnly(this.entities, this.query.getQueriedClass());
                break;
            }
            default: {
                results = this.pm.map(this.query, this.entities);
            }
        }
        QueryOptionPage pag = (QueryOptionPage)this.query.option(1);
        QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)this.query.option(8193);
        if (pag.isPaginating()) {
            gaeCtx.noMoreDataAfter = results.size() == 0;
        }
        return results;
    }

    public static enum MapType {
        ALL,
        KEYS_ONLY;

    }
}

