/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import siena.ClassInfo;
import siena.Generator;
import siena.Id;
import siena.Query;
import siena.QueryFilterSearch;
import siena.SienaException;
import siena.Util;
import siena.jdbc.ConnectionManager;
import siena.jdbc.JdbcDBUtils;
import siena.jdbc.JdbcMappingUtils;
import siena.jdbc.JdbcPersistenceManager;
import siena.jdbc.h2.FullText;

public class H2PersistenceManager
extends JdbcPersistenceManager {
    private static final String DB = "H2";
    private String dbMode = "h2";
    protected static Map<String, Boolean> tableIndexMap = new ConcurrentHashMap<String, Boolean>();

    public H2PersistenceManager() {
    }

    public H2PersistenceManager(ConnectionManager connectionManager, Class<?> listener) {
        super(connectionManager, listener);
    }

    public H2PersistenceManager(ConnectionManager connectionManager, Class<?> listener, String dbMode) {
        super(connectionManager, listener);
        this.dbMode = dbMode;
    }

    @Override
    public void closeConnection() {
    }

    @Override
    protected int insertBatchWithAutoIncrementKey(JdbcPersistenceManager.JdbcClassInfo classInfo, Map<JdbcPersistenceManager.JdbcClassInfo, List<Object>> objMap) throws SQLException, IllegalAccessException {
        PreparedStatement ps = null;
        ps = this.getConnection().prepareStatement(classInfo.insertSQL, 1);
        int res = 0;
        for (Object obj : objMap.get(classInfo)) {
            for (Field field : classInfo.keys) {
                Id id = field.getAnnotation(Id.class);
                if (id.value() != Generator.UUID) continue;
                field.set(obj, UUID.randomUUID().toString());
            }
            this.addParameters(obj, classInfo.insertFields, ps, 1);
            ps.executeUpdate();
            if (!classInfo.generatedKeys.isEmpty()) {
                ResultSet gk = ps.getGeneratedKeys();
                while (gk.next()) {
                    int i = 1;
                    for (Field field : classInfo.generatedKeys) {
                        field.setAccessible(true);
                        JdbcMappingUtils.setFromObject(obj, field, gk.getObject(i++));
                    }
                }
            }
            ++res;
        }
        return res;
    }

    @Override
    public void save(Object obj) {
        JdbcPersistenceManager.JdbcClassInfo classInfo = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(obj.getClass());
        ArrayList<String> keyNames = new ArrayList<String>();
        for (Field field : classInfo.keys) {
            keyNames.add(field.getName());
        }
        PreparedStatement ps = null;
        try {
            try {
                Field idField = classInfo.info.getIdField();
                Object idVal = Util.readField(obj, idField);
                if (idVal == null) {
                    this.insert(obj);
                } else {
                    ArrayList<String> allColumns = new ArrayList<String>();
                    JdbcPersistenceManager.JdbcClassInfo.calculateColumns(classInfo.allFields, allColumns, null, "");
                    Object[] is = new String[allColumns.size()];
                    Arrays.fill(is, "?");
                    ps = this.getConnection().prepareStatement("MERGE INTO " + classInfo.tableName + " (" + Util.join(allColumns, ",") + ") " + "VALUES(" + Util.join(Arrays.asList(is), ",") + ")");
                    int i = 1;
                    i = this.addParameters(obj, classInfo.allFields, ps, i);
                    ps.executeUpdate();
                }
            }
            catch (SienaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        finally {
            JdbcDBUtils.closeStatementAndConnection(this, ps);
        }
    }

    @Override
    public int save(Object ... objects) {
        return this.save(Arrays.asList(objects));
    }

    @Override
    public int save(Iterable<?> objects) {
        HashMap<JdbcPersistenceManager.JdbcClassInfo, Object> generatedObjMap = new HashMap<JdbcPersistenceManager.JdbcClassInfo, Object>();
        HashMap<JdbcPersistenceManager.JdbcClassInfo, Object> objMap = new HashMap<JdbcPersistenceManager.JdbcClassInfo, Object>();
        PreparedStatement ps = null;
        for (Object obj : objects) {
            Object l;
            JdbcPersistenceManager.JdbcClassInfo classInfo = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(obj.getClass());
            Field idField = classInfo.info.getIdField();
            Object idVal = Util.readField(obj, idField);
            if (idVal == null && !classInfo.generatedKeys.isEmpty()) {
                if (!generatedObjMap.containsKey(classInfo)) {
                    l = new ArrayList();
                    l.add(obj);
                    generatedObjMap.put(classInfo, l);
                    continue;
                }
                ((List)generatedObjMap.get(classInfo)).add(obj);
                continue;
            }
            if (!objMap.containsKey(classInfo)) {
                l = new ArrayList();
                l.add(obj);
                objMap.put(classInfo, l);
                continue;
            }
            ((List)objMap.get(classInfo)).add(obj);
        }
        int total = 0;
        try {
            for (JdbcPersistenceManager.JdbcClassInfo classInfo : generatedObjMap.keySet()) {
                total += this.insert((Iterable)generatedObjMap.get(classInfo));
            }
            for (JdbcPersistenceManager.JdbcClassInfo classInfo : objMap.keySet()) {
                ArrayList<String> keyNames = new ArrayList<String>();
                for (Field field : classInfo.keys) {
                    keyNames.add(field.getName());
                }
                ArrayList<String> allColumns = new ArrayList<String>();
                JdbcPersistenceManager.JdbcClassInfo.calculateColumns(classInfo.allFields, allColumns, null, "");
                Object[] is = new String[allColumns.size()];
                Arrays.fill(is, "?");
                ps = this.getConnection().prepareStatement("MERGE INTO " + classInfo.tableName + " (" + Util.join(allColumns, ",") + ") " + "VALUES(" + Util.join(Arrays.asList(is), ",") + ")");
                for (Object obj : (List)objMap.get(classInfo)) {
                    int i = 1;
                    i = this.addParameters(obj, classInfo.allFields, ps, i);
                    ps.addBatch();
                }
                int[] res = ps.executeBatch();
                total += res.length;
            }
            int n = total;
            return n;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatementAndConnection(this, ps);
        }
    }

    @Override
    public void init(Properties p) {
        super.init(p);
        try {
            FullText.init(this.getConnection());
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
    }

    protected <T> List<T> doSearch(Query<T> query, int limit, int offset) {
        try {
            Connection conn = this.getConnection();
            ClassInfo ci = ClassInfo.getClassInfo(query.getQueriedClass());
            if (!tableIndexMap.containsKey(ci.tableName)) {
                List<String> colList = ci.getUpdateFieldsColumnNames();
                String cols = null;
                if (!colList.isEmpty()) {
                    cols = "";
                    int sz = colList.size();
                    int i = 0;
                    while (i < sz) {
                        cols = "h2".equals(this.dbMode) ? String.valueOf(cols) + colList.get(i).toUpperCase() : ("mysql".equals(this.dbMode) ? String.valueOf(cols) + colList.get(i).toLowerCase() : String.valueOf(cols) + colList.get(i).toUpperCase());
                        if (i < sz - 1) {
                            cols = String.valueOf(cols) + ",";
                        }
                        ++i;
                    }
                }
                FullText.createIndex(conn, "PUBLIC", ci.tableName.toUpperCase(), cols);
                tableIndexMap.put(ci.tableName, true);
            }
            String searchString = "";
            Iterator<QueryFilterSearch> it = query.getSearches().iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    searchString = String.valueOf(searchString) + " ";
                } else {
                    first = false;
                }
                searchString = String.valueOf(searchString) + it.next().match;
            }
            ResultSet rs = FullText.searchData(conn, searchString, limit, offset);
            List res = new ArrayList();
            Field idField = ci.getIdField();
            Class<?> idClass = idField.getType();
            while (rs.next()) {
                Object[] keys = (Object[])rs.getArray("KEYS").getArray();
                Object[] realKeys = null;
                if (idField.getType() != String.class) {
                    realKeys = new Object[keys.length];
                    int i = 0;
                    while (i < keys.length) {
                        realKeys[i] = Util.fromString(idClass, (String)keys[i]);
                        ++i;
                    }
                } else {
                    realKeys = keys;
                }
                if (res == null) {
                    res = this.getByKeys(query.getQueriedClass(), realKeys);
                    continue;
                }
                res.addAll(this.getByKeys(query.getQueriedClass(), realKeys));
            }
            return res;
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
    }

    protected <T> List<T> doSearchKeys(Query<T> query, int limit, int offset) {
        try {
            Connection conn = this.getConnection();
            ClassInfo ci = ClassInfo.getClassInfo(query.getQueriedClass());
            if (!tableIndexMap.containsKey(ci.tableName)) {
                List<String> colList = ci.getUpdateFieldsColumnNames();
                String cols = null;
                if (!colList.isEmpty()) {
                    cols = "";
                    int sz = colList.size();
                    int i = 0;
                    while (i < sz) {
                        cols = "h2".equals(this.dbMode) ? String.valueOf(cols) + colList.get(i).toUpperCase() : ("mysql".equals(this.dbMode) ? String.valueOf(cols) + colList.get(i).toLowerCase() : String.valueOf(cols) + colList.get(i).toUpperCase());
                        if (i < sz - 1) {
                            cols = String.valueOf(cols) + ",";
                        }
                        ++i;
                    }
                }
                FullText.createIndex(conn, "PUBLIC", ci.tableName.toUpperCase(), cols);
                tableIndexMap.put(ci.tableName, true);
            }
            String searchString = "";
            Iterator<QueryFilterSearch> it = query.getSearches().iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    searchString = String.valueOf(searchString) + " ";
                } else {
                    first = false;
                }
                searchString = String.valueOf(searchString) + it.next().match;
            }
            ResultSet rs = FullText.searchData(conn, searchString, limit, offset);
            ArrayList res = new ArrayList();
            Class clazz = query.getQueriedClass();
            while (rs.next()) {
                Object[] keys;
                Object[] objectArray = keys = (Object[])rs.getArray("KEYS").getArray();
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    Object key = objectArray[n2];
                    Object obj = Util.createObjectInstance(clazz);
                    for (Field field : JdbcPersistenceManager.JdbcClassInfo.getClassInfo(clazz).keys) {
                        JdbcMappingUtils.setFromObject(obj, field, key);
                    }
                    res.add(obj);
                    ++n2;
                }
            }
            return res;
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    protected <T> int doSearchCount(Query<T> query) {
        try {
            Connection conn = this.getConnection();
            ClassInfo ci = ClassInfo.getClassInfo(query.getQueriedClass());
            if (!tableIndexMap.containsKey(ci.tableName)) {
                List<String> colList = ci.getUpdateFieldsColumnNames();
                String cols = null;
                if (!colList.isEmpty()) {
                    cols = "";
                    int sz = colList.size();
                    int i = 0;
                    while (i < sz) {
                        cols = "h2".equals(this.dbMode) ? String.valueOf(cols) + colList.get(i).toUpperCase() : ("mysql".equals(this.dbMode) ? String.valueOf(cols) + colList.get(i).toLowerCase() : String.valueOf(cols) + colList.get(i).toUpperCase());
                        if (i < sz - 1) {
                            cols = String.valueOf(cols) + ",";
                        }
                        ++i;
                    }
                }
                FullText.createIndex(conn, "PUBLIC", ci.tableName.toUpperCase(), cols);
                tableIndexMap.put(ci.tableName, true);
            }
            String searchString = "";
            Iterator<QueryFilterSearch> it = query.getSearches().iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    searchString = String.valueOf(searchString) + " ";
                } else {
                    first = false;
                }
                searchString = String.valueOf(searchString) + it.next().match;
            }
            ResultSet rs = FullText.searchData(conn, searchString, 0, 0);
            int count = 0;
            while (rs.next()) {
                Object[] keys = (Object[])rs.getArray("KEYS").getArray();
                count += keys.length;
            }
            return count;
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
    }

    @Override
    public <T> List<T> fetch(Query<T> query) {
        if (query.getSearches().isEmpty()) {
            return super.fetch(query);
        }
        return this.doSearch(query, 0, 0);
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit) {
        if (query.getSearches().isEmpty()) {
            return super.fetch(query, limit);
        }
        return this.doSearch(query, limit, 0);
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit, Object offset) {
        if (query.getSearches().isEmpty()) {
            return super.fetch(query, limit, (Integer)offset);
        }
        return this.doSearch(query, limit, (Integer)offset);
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query) {
        if (query.getSearches().isEmpty()) {
            return super.fetchKeys(query);
        }
        return this.doSearchKeys(query, 0, 0);
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit) {
        if (query.getSearches().isEmpty()) {
            return super.fetchKeys(query, limit);
        }
        return this.doSearchKeys(query, limit, 0);
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit, Object offset) {
        if (query.getSearches().isEmpty()) {
            return super.fetchKeys(query, limit, (Integer)offset);
        }
        return this.doSearchKeys(query, limit, (Integer)offset);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query) {
        return super.iter(query);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit) {
        return super.iter(query, limit);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit, Object offset) {
        return super.iter(query, limit, offset);
    }

    @Override
    public <T> int count(Query<T> query) {
        if (query.getSearches().isEmpty()) {
            return super.count(query);
        }
        return this.doSearchCount(query);
    }
}

