/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import siena.ClassInfo;
import siena.DateTime;
import siena.Json;
import siena.Query;
import siena.QueryJoin;
import siena.QueryOrder;
import siena.SienaException;
import siena.SienaRestrictedApiException;
import siena.SimpleDate;
import siena.Text;
import siena.Time;
import siena.Util;
import siena.core.DecimalPrecision;
import siena.core.Polymorphic;
import siena.embed.Embedded;
import siena.jdbc.JdbcMappingUtils;
import siena.jdbc.JdbcPersistenceManager;
import siena.jdbc.QueryOptionJdbcContext;

public class JdbcDBUtils {
    public static final String WHERE = " WHERE ";
    public static final String AND = " AND ";
    public static final String IS_NULL = " IS NULL";
    public static final String IS_NOT_NULL = " IS NOT NULL";

    public static void closeStatement(Statement st) {
        if (st == null) {
            return;
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
    }

    public static void closeStatementAndConnection(JdbcPersistenceManager pm, Statement st) {
        try {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
        }
        finally {
            try {
                if (pm.getConnection().getAutoCommit()) {
                    pm.closeConnection();
                }
            }
            catch (SQLException sQLException) {
            }
            catch (SienaException sienaException) {}
        }
    }

    public static <T> StringBuilder buildSqlSelect(Query<T> query) {
        Class clazz = query.getQueriedClass();
        JdbcPersistenceManager.JdbcClassInfo info = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(clazz);
        ArrayList<String> cols = new ArrayList<String>();
        List<Field> joinFields = JdbcMappingUtils.getJoinFields(query, info);
        if (joinFields == null) {
            JdbcPersistenceManager.JdbcClassInfo.calculateColumnsAliases(info.allFields, cols, info.tableName, "");
            StringBuilder sql = new StringBuilder("SELECT " + Util.join(cols, ", ") + " FROM " + info.tableName);
            return sql;
        }
        JdbcPersistenceManager.JdbcClassInfo.calculateColumnsAliases(info.allFields, cols, info.tableName, "");
        StringBuilder sql = new StringBuilder(" FROM " + info.tableName);
        int i = 0;
        for (Field field : joinFields) {
            JdbcPersistenceManager.JdbcClassInfo fieldInfo = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(field.getType());
            if (!ClassInfo.isModel(field.getType())) {
                throw new SienaException("Join not possible: Field " + field.getName() + " is not a relation field");
            }
            String alias = String.valueOf(fieldInfo.tableName) + i++;
            fieldInfo.joinFieldAliases.put(field.getName(), alias);
            JdbcPersistenceManager.JdbcClassInfo.calculateColumnsAliases(fieldInfo.allFields, cols, alias, "");
            String[] columns = ClassInfo.getColumnNames(field, info.tableName);
            if (columns.length > 1 || fieldInfo.keys.size() > 1) {
                throw new SienaException("Join not possible: join field " + field.getName() + " has multiple keys");
            }
            sql.append(" LEFT JOIN " + fieldInfo.tableName + " AS " + alias + " ON " + columns[0] + " = " + alias + "." + fieldInfo.keys.get(0).getName());
        }
        sql.insert(0, "SELECT " + Util.join(cols, ", "));
        return sql;
    }

    public static <T> void appendSqlOrder(Query<T> query, StringBuilder sql) {
        Class clazz = query.getQueriedClass();
        JdbcPersistenceManager.JdbcClassInfo info = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(clazz);
        List<QueryOrder> orders = query.getOrders();
        List<QueryJoin> joins = query.getJoins();
        if (orders.isEmpty() && joins.isEmpty()) {
            return;
        }
        sql.append(" ORDER BY ");
        boolean first = true;
        for (QueryOrder order : orders) {
            if (!first) {
                sql.append(", ");
            }
            first = false;
            if (order.parentField == null) {
                String[] columns;
                String[] stringArray = columns = ClassInfo.getColumnNames(order.field, info.tableName);
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    String column = stringArray[n2];
                    sql.append(String.valueOf(column) + (order.ascending ? "" : " DESC"));
                    ++n2;
                }
                continue;
            }
            try {
                String[] columns;
                JdbcPersistenceManager.JdbcClassInfo parentCi = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(order.parentField.getType());
                Field subField = order.parentField.getType().getField(order.field.getName());
                String[] stringArray = columns = ClassInfo.getColumnNames(subField, parentCi.joinFieldAliases.get(order.parentField.getName()));
                int n = columns.length;
                int n3 = 0;
                while (n3 < n) {
                    String column = stringArray[n3];
                    sql.append(String.valueOf(column) + (order.ascending ? "" : " DESC"));
                    ++n3;
                }
            }
            catch (NoSuchFieldException ex) {
                throw new SienaException("Order not possible: join sort field " + order.field.getName() + " is not a known field of " + order.parentField.getName(), ex);
            }
        }
    }

    public static <T> void appendSqlLimitOffset(Query<T> query, StringBuilder sql, List<Object> parameters) {
        QueryOptionJdbcContext jdbcCtx = (QueryOptionJdbcContext)query.option(4097);
        sql.append(" LIMIT ?");
        parameters.add(jdbcCtx.realPageSize);
        sql.append(" OFFSET ?");
        parameters.add(jdbcCtx.realOffset);
    }

    public static int toSqlType(Object obj, Field field, String DB) {
        if (obj == null) {
            return -1;
        }
        Class<?> type = field.getType();
        if (type == Byte.class || type == Byte.TYPE) {
            return -6;
        }
        if (type == Short.class || type == Short.TYPE) {
            return 5;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return 4;
        }
        if (type == Long.class || type == Long.TYPE) {
            return -5;
        }
        if (type == Float.class || type == Float.TYPE) {
            return 6;
        }
        if (type == Double.class || type == Double.TYPE) {
            return 8;
        }
        if (type == String.class) {
            if (field.getAnnotation(Text.class) != null) {
                return -1;
            }
            return 12;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return 16;
        }
        if (type == java.util.Date.class) {
            if (field.getAnnotation(DateTime.class) != null) {
                return 93;
            }
            if (field.getAnnotation(Time.class) != null) {
                return 92;
            }
            if (field.getAnnotation(SimpleDate.class) != null) {
                return 91;
            }
            return 93;
        }
        if (type == Json.class) {
            return -1;
        }
        if (type == byte[].class) {
            return 2004;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return 12;
        }
        if (type == BigDecimal.class) {
            DecimalPrecision an = field.getAnnotation(DecimalPrecision.class);
            if (an == null) {
                return 3;
            }
            if (an.storageType() == DecimalPrecision.StorageType.NATIVE) {
                return 3;
            }
            if (an.storageType() == DecimalPrecision.StorageType.STRING) {
                return 12;
            }
            if (an.storageType() == DecimalPrecision.StorageType.DOUBLE) {
                return 8;
            }
            return 3;
        }
        Embedded embedded = field.getAnnotation(Embedded.class);
        if (embedded != null) {
            if ("h2".equals(DB)) {
                return 2005;
            }
            return -1;
        }
        if (field.isAnnotationPresent(Polymorphic.class)) {
            return 2004;
        }
        throw new SienaRestrictedApiException(DB, "createColumn", "Unsupported type for field " + type.getName() + "." + field.getName());
    }

    public static void setObject(PreparedStatement ps, int index, Object value, Field field, String DB) throws SQLException {
        if (value == null) {
            ps.setNull(index, JdbcDBUtils.toSqlType(value, field, DB));
            return;
        }
        Class<?> type = field.getType();
        if (type == Byte.class || type == Byte.TYPE) {
            ps.setByte(index, (Byte)value);
        } else if (type == Short.class || type == Short.TYPE) {
            ps.setShort(index, (Short)value);
        } else if (type == Integer.class || type == Integer.TYPE) {
            ps.setInt(index, (Integer)value);
        } else if (type == Long.class || type == Long.TYPE) {
            ps.setLong(index, (Long)value);
        } else if (type == Float.class || type == Float.TYPE) {
            ps.setFloat(index, ((Float)value).floatValue());
        } else if (type == Double.class || type == Double.TYPE) {
            ps.setDouble(index, (Double)value);
        } else if (type == String.class) {
            ps.setString(index, (String)value);
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            ps.setBoolean(index, (Boolean)value);
        } else if (type == java.util.Date.class) {
            if (field.getAnnotation(DateTime.class) != null) {
                Timestamp ts = new Timestamp(((java.util.Date)value).getTime());
                ps.setTimestamp(index, ts);
            } else if (field.getAnnotation(Time.class) != null) {
                java.sql.Time ts = new java.sql.Time(((java.util.Date)value).getTime());
                ps.setTime(index, ts);
            } else if (field.getAnnotation(SimpleDate.class) != null) {
                Date d = new Date(((java.util.Date)value).getTime());
                ps.setDate(index, d);
            } else {
                Timestamp ts = new Timestamp(((java.util.Date)value).getTime());
                ps.setTimestamp(index, ts);
            }
        } else if (type == Json.class) {
            ps.setString(index, (String)value);
        } else if (type == byte[].class) {
            ByteArrayInputStream bis = new ByteArrayInputStream((byte[])value);
            ps.setBlob(index, bis);
        } else if (Enum.class.isAssignableFrom(type)) {
            ps.setString(index, (String)value);
        } else if (type == BigDecimal.class) {
            DecimalPrecision an = field.getAnnotation(DecimalPrecision.class);
            if (an == null) {
                ps.setObject(index, value);
            } else if (an.storageType() == DecimalPrecision.StorageType.NATIVE) {
                ps.setBigDecimal(index, (BigDecimal)value);
            } else if (an.storageType() == DecimalPrecision.StorageType.STRING) {
                ps.setString(index, ((BigDecimal)value).toPlainString());
            } else if (an.storageType() == DecimalPrecision.StorageType.DOUBLE) {
                ps.setDouble(index, ((BigDecimal)value).doubleValue());
            } else {
                ps.setBigDecimal(index, (BigDecimal)value);
            }
        } else {
            Embedded embedded = field.getAnnotation(Embedded.class);
            if (embedded != null) {
                if ("h2".equals(DB)) {
                    StringReader reader = new StringReader((String)value);
                    ps.setClob(index, reader);
                } else {
                    ps.setString(index, (String)value);
                }
            } else if (field.isAnnotationPresent(Polymorphic.class)) {
                ByteArrayInputStream bis = new ByteArrayInputStream((byte[])value);
                ps.setBlob(index, bis);
            } else {
                throw new SienaRestrictedApiException(DB, "createColumn", "Unsupported type for field " + type.getName() + "." + field.getName());
            }
        }
    }
}

