/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.strategy;

import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.io.read.ArrayBindAction;
import org.apache.commons.betwixt.io.read.BeanBindAction;
import org.apache.commons.betwixt.io.read.MappingAction;
import org.apache.commons.betwixt.io.read.ReadContext;
import org.apache.commons.betwixt.io.read.SimpleTypeBindAction;
import org.apache.commons.betwixt.strategy.ActionMappingStrategy;
import org.xml.sax.Attributes;

public class DefaultActionMappingStrategy
extends ActionMappingStrategy {
    public MappingAction getMappingAction(String namespace, String name, Attributes attributes, ReadContext context) throws Exception {
        MappingAction result = MappingAction.EMPTY;
        ElementDescriptor activeDescriptor = context.getCurrentDescriptor();
        if (activeDescriptor != null) {
            if (activeDescriptor.isHollow()) {
                result = this.isArrayDescriptor(activeDescriptor) ? ArrayBindAction.createMappingAction(activeDescriptor) : BeanBindAction.INSTANCE;
            } else if (activeDescriptor.isSimple()) {
                result = SimpleTypeBindAction.INSTANCE;
            } else {
                ElementDescriptor childDescriptor;
                ElementDescriptor[] descriptors = activeDescriptor.getElementDescriptors();
                if (descriptors.length == 1 && (childDescriptor = descriptors[0]).isHollow() && this.isArrayDescriptor(childDescriptor)) {
                    result = ArrayBindAction.createMappingAction(childDescriptor);
                }
            }
        }
        return result;
    }

    private boolean isArrayDescriptor(ElementDescriptor descriptor) {
        Class propertyType;
        boolean result = false;
        if (descriptor != null && (propertyType = descriptor.getPropertyType()) != null) {
            result = propertyType.isArray();
        }
        return result;
    }
}

