package models;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.Table;

import play.data.validation.Email;
import play.data.validation.InPast;
import play.data.validation.Match;
import play.data.validation.MaxSize;
import play.data.validation.MinSize;
import play.data.validation.Required;
import play.modules.siena.EnhancedModel;
import siena.Column;
import siena.Generator;
import siena.Id;

@siena.Table("user")
public class User extends EnhancedModel{
	/**
	 * 
	 */
	private static final long serialVersionUID = -1397242695765843990L;
	
	@Id(Generator.AUTO_INCREMENT)
    public Long id;
	
	@Required
	@MaxSize(value = 20)
	@Match(value = "^[0-9a-zA-Z]+$",message="Only Letters and Numbers")
	@Column("first_name")
	public String firstName;
	
	@Required
	@Match(value = "^[0-9a-zA-Z]+$", message="Only Letters and Numbers")
	@MaxSize(value = 20)
	@Column("last-name")
	public String lastName;
	
	@MaxSize(value = 100)
	@Column("address")
	public String address;
	
	@Match(value = "^[0-9\\ ]+$", message="Only Numbers and spaces")
	@Column("phone_num")
	public String phoneNum;
	
	@Required
	@InPast
	@Column("date_of_birth")
	public Date dateOfBirth;
	
	@Required
	@MinSize(value = 10)
	@Column("password")
	public String password;
	
	@Required
	@Email
	@Column("email")
	public String email;
	/**
	 * If true then he's male, otherwise she's female.
	 */
	@Column("gender")
	public boolean gender;

	public User(String firstName, String lastName, String address,
			String phoneNum, String password, String email, Date dateOfBirth,boolean gender) {
		this.firstName = firstName;
		this.lastName = lastName;
		this.address = address;
		this.phoneNum = phoneNum;
		this.password = password;
		this.email = email;
		this.dateOfBirth = dateOfBirth;
		this.gender = gender;
	}
}
